﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace jit {

/**
    @brief Jit 環境の情報を表す構造体です。
*/
struct JitEnvironmentInfo
{
    uint64_t rxCodeAddress;
    size_t rxCodeSize;
    uint64_t roCodeAddress;
    size_t roCodeSize;
};

/**
    @brief コード領域の範囲を表す際に使用する構造体です。
*/
struct CodeRange
{
    uint64_t offset;
    uint64_t size;

    bool IsValid() const NN_NOEXCEPT
    {
        return true
            && offset % 4 == 0
            && size % 4 == 0
            && offset <= offset + size
        ;
    }

    bool IsValid(uint64_t wholeSize) const NN_NOEXCEPT
    {
        return true
            && IsValid()
            && size <= wholeSize
            && offset <= wholeSize - size
        ;
    }

    bool IsInRange(const CodeRange& other) const NN_NOEXCEPT
    {
        return true
            && this->offset >= other.offset
            && this->size <= other.size
            && this->offset - other.offset <= other.size - this->size
        ;
    }
};

enum MemorySecurityMode
{
    MemorySecurityMode_Default = 0,
    MemorySecurityMode_NoAslr = 1,
    MemorySecurityMode_AlwaysMapped = 2,
};

}}
