﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   I2C ライブラリのバスアクセス機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

#include <nn/i2c/detail/i2c_Gen.h>

#include "i2c_DeviceName.h"
#include "i2c_BusCommon.h"

#if defined(NN_DETAIL_I2C_ENABLE_GEN_2)
#include <nn/nn_DeviceCode.h>
#endif

namespace nn {
namespace i2c {

#if defined(NN_DETAIL_I2C_ENABLE_GEN_2)

void OpenSession(I2cSession* pOutSession, nn::DeviceCode deviceCode) NN_NOEXCEPT;

#endif

/**
 * @brief 指定したスレーブデバイスとのセッションをオープンします。すなわちスレーブデバイスとの通信を可能な状態にします。
 *
 * @param[out]  pOutSession                    セッション用パラメータ
 * @param[in]   device                         デバイス識別子
 * @pre         ライブラリは初期化済の状態である必要があります。
 *              指定したデバイスはボード上に存在している必要があります。
 * @post        指定したデバイスが使用可能な状態になります。
 * @details     セッションのオープンに成功した場合、有効な　I2cSession　が設定されます。
 *              この関数は指定したスレーブアドレスのデバイスの接続状態の確認は行いません。
 */
void OpenSession(I2cSession* pOutSession, I2cDevice device) NN_NOEXCEPT;

} // i2c
} // nn


