﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/*
    RapidJSON の動作設定を定義するためのヘッダファイル
 */

// int64_t, uint64_t の定義を外部から与える
#include <nn/nn_Common.h>
#define RAPIDJSON_NO_INT64DEFINE

// 名前空間
#define RAPIDJSON_NAMESPACE             nne::rapidjson
#define RAPIDJSON_NAMESPACE_BEGIN       namespace nne { namespace rapidjson {
#define RAPIDJSON_NAMESPACE_END         }}

// assert() の定義
#include <nn/nn_SdkAssert.h>
#define RAPIDJSON_ASSERT(x)             NN_SDK_ASSERT(x)

// C++11 対応
#define RAPIDJSON_HAS_CXX11_RVALUE_REFS 1 //NOLINT(preprocessor/const)
// #define RAPIDJSON_HAS_CXX11_NOEXCEPT
#define RAPIDJSON_HAS_CXX11_TYPETRAITS  1 //NOLINT(preprocessor/const)
