﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{
namespace gpio{

/**
* @brief GPIO パッドの定義
*
* @details NX spec の GPIO ライブラリで現在対応している GPIO パッドの一覧です。
*/
enum GpioPadName
{
    GpioPadName_CodecLdoEnTemp     = 1,  //!< CODEC_LDO_EN_TEMP
    GpioPadName_PowSdEn            = 2,  //!< POW_SD_EN
    GpioPadName_BtRst              = 3,  //!< BT_RST
    GpioPadName_RamCode3           = 4,  //!< RAM_CODE3
    GpioPadName_GameCardReset      = 5,  //!< GAMECARD_REST
    GpioPadName_CodecAlert         = 6,  //!< CODEC_ALERT
    GpioPadName_PowGc              = 7,  //!< POW_GC
    GpioPadName_DebugControllerDet = 8,  //!< DEBUG_CONTROLLER_DET
    GpioPadName_BattChgStatus      = 9,  //!< BATT_CHG_STATUS
    GpioPadName_BattChgEnableN     = 10, //!< BATT_CHG_enable_n
    GpioPadName_FanTach            = 11, //!< FAN_TACH
    GpioPadName_ExtconDetS         = 12, //!< EXTCON_DET_S (UART3_TXへ変更予定)
    GpioPadName_Vdd50AEn           = 13, //!< VDD50A-EN
    GpioPadName_SdevCoaxSel1       = 14, //!< SDEV_COAX_SEL_1
    GpioPadName_GameCardCd         = 15, //!< GAMECARD_CD
    GpioPadName_ProdType0          = 16, //!< PROD_TYPE_0
    GpioPadName_ProdType1          = 17, //!< PROD_TYPE_1
    GpioPadName_ProdType2          = 18, //!< PROD_TYPE_2
    GpioPadName_ProdType3          = 19, //!< PROD_TYPE_3
    GpioPadName_TempAlert          = 20, //!< TEMP_ALERT
    GpioPadName_CodecHpDetIrq      = 21, //!< CODEC_HP_DET_IRQ
    GpioPadName_MotionInt          = 22, //!< MOTION_INT
    GpioPadName_TpIrq              = 23, //!< TP_IRQ
    GpioPadName_ButtonSleep2       = 24, //!< BUTTON_sleep-2
    GpioPadName_ButtonVolUp        = 25, //!< BUTTON_VOL_UP
    GpioPadName_ButtonVolDn        = 26, //!< BUTTON_VOL_DN
    GpioPadName_BattMgicIrq        = 27, //!< BATT_MGIC_IRQ
    GpioPadName_RecoveryKey        = 28, //!< recovery_key
    GpioPadName_PowLcdBlEn         = 29, //!< POW_LCD_BL_EN
    GpioPadName_LcdReset           = 30, //!< LCD_reset
    GpioPadName_PdVconnEn          = 31, //!< PD_VCONN_EN
    GpioPadName_PdRstN             = 32, //!< PD_RST_n
    GpioPadName_Bq24190Irq         = 33, //!< BQ24190_IRQ
    GpioPadName_SdevCoaxSel0       = 34, //!< SDEV_COAX_SEL_0
    GpioPadName_SdWp               = 35, //!< SD_WP
    GpioPadName_TpReset            = 36, //!< TP_RESET
    GpioPadName_BtGpio2            = 37, //!< BT_GPIO_2
    GpioPadName_BtGpio3            = 38, //!< BT_GPIO_3
    GpioPadName_BtGpio4            = 39, //!< BT_GPIO_4
    GpioPadName_CradleIrq          = 40, //!< cradle_IRQ
    GpioPadName_PowVcpuInt         = 41, //!< POW_VCPU_INT
    GpioPadName_Max77621GpuInt     = 42, //!< MAX77621-GPU-INT
    GpioPadName_ExtconChgU         = 43, //!< EXTCON_CHG_U
    GpioPadName_ExtconChgS         = 44, //!< EXTCON_CHG_S
    GpioPadName_WifiRfDisable      = 45, //!< WIFI_RF_DISABLE
    GpioPadName_WifiReset          = 46, //!< WIFI_RESET
    GpioPadName_ApWakeBt           = 47, //!< AP_WAKE_BT
    GpioPadName_BtWakeAp           = 48, //!< BT_WAKE_AP
    GpioPadName_BtGpio5            = 49, //!< BT_GPIO_5
    GpioPadName_PowLcdVddPEn       = 50, //!< POW LCD_VDD_P_EN
    GpioPadName_PowLcdVddNEn       = 51, //!< POW LCD_VDD_N_EN
    GpioPadName_ExtconDetU         = 52, //!< EXTCON_DET_U (UART2_TXへ変更予定)
    GpioPadName_RamCode2           = 53, //!< RAM_CODE2
    GpioPadName_Vdd50BEn           = 54, //!< VDD50B-EN
    GpioPadName_WifiWakeHost       = 55, //!< WIFI_WAKE_HOST
    GpioPadName_SdCd               = 56, //!< SD_CD
    GpioPadName_OtgFet1ForSdev     = 57, //!< OTG_FET_1_FOR_SDEV
    GpioPadName_OtgFet2ForSdev     = 58, //!< OTG_FET_2_FOR_SDEV
    GpioPadName_ExtConWakeU        = 59, //!< EXTCON_DET_U
    GpioPadName_ExtConWakeS        = 60, //!< EXTCON_DET_S
    GpioPadName_PmuIrq             = 61, //!< PMU_IRQ
    GpioPadName_ExtUart2Cts        = 62, //!< EXT_UART2_CTS
    GpioPadName_ExtUart3Cts        = 63, //!< EXT_UART3_CTS
    GpioPadName_5VStepDownEn       = 64, //!< 5V_STEPDOWN_EN
    GpioPadName_UsbSwitchB2Oc      = 65, //!< USB_SWITCH_B2_OC
    GpioPadName_5VStepDownPg       = 66, //!< 5V_STEPDOWN_PG
    GpioPadName_UsbSwitchAEn       = 67, //!< USB_SWITCH_A_EN
    GpioPadName_UsbSwitchAFlag     = 68, //!< USB_SWITCH_A_FLAG
    GpioPadName_UsbSwitchB3Oc      = 69, //!< USB_SWITCH_B3_OC
    GpioPadName_UsbSwitchB3En      = 70, //!< USB_SWITCH_B3_EN
    GpioPadName_UsbSwitchB2En      = 71, //!< USB_SWITCH_B2_EN
    GpioPadName_Hdmi5VEn           = 72, //!< HDMI_5V_EN
    GpioPadName_UsbSwitchB1En      = 73, //!< USB_SWITCH_B1_EN
    GpioPadName_HdmiPdTrEn         = 74, //!< HDMI_PD_TR_EN
    GpioPadName_FanEn              = 75, //!< FAN_EN
    GpioPadName_UsbSwitchB1Oc      = 76, //!< USB_SWITCH_B1_OC
    GpioPadName_PwmFan             = 77, //!< PWM_FAN
    GpioPadName_HdmiHpd            = 78, //!< HDMI_HPD
    GpioPadName_Max77812Irq        = 79, //!< MAX77812 IRQ
    GpioPadName_Debug0             = 80, //!< DEBUG PURPOSE GPIO 0
    GpioPadName_Debug1             = 81, //!< DEBUG PURPOSE GPIO 1
    GpioPadName_Debug2             = 82, //!< DEBUG PURPOSE GPIO 2
    GpioPadName_Debug3             = 83, //!< DEBUG PURPOSE GPIO 3
    GpioPadName_NfcIrq             = 84, //!< NFC IRQ
    GpioPadName_NfcReset           = 85, //!< NFC RESET
    GpioPadName_McuInt             = 86, //!< MCU INT
    GpioPadName_McuBoot            = 87, //!< MCU BOOT
    GpioPadName_McuReset           = 88, //!< MCU RESET
    GpioPadName_Vdd5V3En           = 89, //!< VDD5V3 EN
    GpioPadName_McuPor             = 90, //!< MCU POR


    // For Compatibility with Generic Header
    // Please Do Not Use For NX Spec Development
    GpioPadName_AudioPowerEnable       = 1, //!< Please use GpioPadName_CodecLdoEnTemp
    GpioPadName_EnablePowerToTheSdCard = 2, //!< Please use GpioPadName_PowSdEn
    GpioPadName_BluetoothPowerEnable   = 3, //!< Please use GpioPadName_BtRst
};

} //gpio
} //nn
