﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Gpio ドライバライブラリの初期設定用 API (システムプロセス向け)
 */

#pragma once

#include <nn/nn_Common.h>

#if (defined(NN_GPIO_GEN) && ((NN_GPIO_GEN) == 2))
    // Gen2 API を使用するクライアントからのインクルードを禁止する
    // サーバ・ライブラリ内部からは (Gen1 互換のため) 参照する
    #error This header is not usable in gen 2.
#endif

namespace nn {
namespace gpio {
namespace driver {

//! @name システムプロセス専用 API
//! @{

/**
 * @brief   GPIO ピンの初期設定を行います。
 *
 * @post
 *  Gpio ピンが各ボードごとの初期設定状態に設定されます。
 *
 * @details
 *  Gpio ピンが各ボードごとの初期設定状態に設定されます。@n
 *  特定システムプロセス限定の機能です。許可なく使用しないでください。
 */
void SetInitialGpioConfig() NN_NOEXCEPT;

/**
 * @brief   Wake ピンの初期設定を行います。
 *
 * @post
 *  Wake ピンが各ボードごとの初期設定状態に設定されます。
 *
 * @details
 *  Wake ピンが各ボードごとの初期設定状態に設定されます。@n
 *  特定システムプロセス限定の機能です。許可なく使用しないでください。
 */
void SetInitialWakePinConfig() NN_NOEXCEPT;

//! @}

} // dirver
} // gpio
} // nn
