﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_SystemEvent.h>

namespace nn {
namespace gpio {
namespace driver {
namespace detail {

class EventHolder
{
    NN_DISALLOW_COPY(EventHolder);
    NN_DISALLOW_MOVE(EventHolder);

public:
    EventHolder() NN_NOEXCEPT {}
    bool IsBoundEvent() const NN_NOEXCEPT;
    void AttachEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;
    nn::os::SystemEventType* DetachEvent() NN_NOEXCEPT;
    nn::os::SystemEventType* GetSystemEvent() NN_NOEXCEPT;

private:
    nn::os::SystemEventType* m_pEvent{ nullptr };
};

} // detail
} // driver
} // gpio
} // nn
