﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_TimeSpan.h>
#include <nn/account/account_Api.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/os/os_ThreadApi.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace fs {

    nn::fs::UserId ConvertAccountUidToFsUserId(const nn::account::Uid& uid) NN_NOEXCEPT;
    void CheckUid(const nn::account::Uid& user) NN_NOEXCEPT;
    void AssertCheckUid(const nn::account::Uid& user) NN_NOEXCEPT;

    template<typename Function>
    Result DoContinouslyUntilSaveDataListFetched(Function function) NN_NOEXCEPT
    {
        Result result = ResultSuccess();

        int waitTimeMs = 5;
        for( int retry = 0; retry < 5; ++retry )
        {
            NN_RESULT_TRY(function())
                NN_RESULT_CATCH(ResultInvalidHandle)
                {
                    result = NN_RESULT_CURRENT_RESULT;
                    os::SleepThread(TimeSpan::FromMilliSeconds(waitTimeMs));
                    waitTimeMs *= 2;
                    continue;
                }
            NN_RESULT_END_TRY;
            NN_RESULT_SUCCESS;
        }

        NN_RESULT_THROW(result);
    };

}}
