﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>

namespace nn { namespace fs {

    /**
    * @brief   ストレージ管理UIの挙動を制御するためのパラメータ
    */
    struct UiParameterForStorageManagement
    {
        enum Media : int32_t
        {
            Media_Any,    //!< 使用中のメディア全対象
            Media_Nand,   //!< 本体メモリのみを対象
            Media_Sd,     //!< SDカードのみを対象
            Media_Usb     //!< USBストレージのみを対象
        };

        enum DataType : int32_t
        {
            DataType_Application,   //!< アプリケーションを作成しようとして容量が足りなかった
            DataType_AccountSave,   //!< アプリケーションからユーザーアカウントセーブを作成/拡張しようとして容量足りなかった
            DataType_CacheStorage,  //!< アプリケーションからキャッシュストレージを作成しようとして容量が足りなかった
        };

        UiParameterForStorageManagement() NN_NOEXCEPT
            : needSize(0)
            , media(Media_Any)
            , applId0(0)
            , applId1(0)
            , uid(nn::account::InvalidUid)
            , type(DataType_Application)
        {
        }

        /**
        * @brief   必要な空き容量を設定します。
        *          needSize = 0 にすると、自由にアプリを削除できるモードになります。
        *          本体設定以外は 0 をセットしないでください。
        *          media = TargetMedia_NX にすると、削除対象は本体保存メモリのみになります。
        *
        * @param[in] needSize   確保したい容量
        * @param[in] media      確保対象のメディア
        *
        * @details
        */
        int64_t             needSize;   //!< 必要な空き容量
        Media               media;      //!< 削除対象のメディア
        Bit64               applId0;    //!< 消したくないアプリID
        Bit64               applId1;    //!< 消したくないアプリID(未使用）
        nn::account::Uid    uid;        //!< セーブデータ作成用のUid（未使用。将来のNUPで使用するかも）
        DataType            type;       //!< セーブデータの種類
    };

}}
