﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_Types.h>

namespace nn { namespace friends { namespace service {

/*!
    @brief      サーバーの実行を開始します。
*/
void StartServer() NN_NOEXCEPT;

/*!
    @brief      サーバーの実行を停止します。
*/
void StopServer() NN_NOEXCEPT;

/*!
    @brief      BGTC のイベントがトリガーされたことを通知します。

    @param[in]  isInHalfAwake   半起床中かどうか
*/
void NotifyBgtcEventTriggered(bool isInHalfAwake) NN_NOEXCEPT;

/*!
    @brief      システムが全起床状態になったことを通知します。
*/
void NotifySystemFullAwaked() NN_NOEXCEPT;

/*!
    @brief      システムが MinimumAwake 状態になったことを通知します。

    @param[in]  isWakeSequence  起床シーケンスかどうか
*/
void NotifySystemMinimumAwaked(bool isWakeSequence) NN_NOEXCEPT;

/*!
    @brief      システムがスリープに入る準備を行ったことを通知します。
*/
void NotifySystemSleepReady() NN_NOEXCEPT;

/*!
    @brief      システムがシャットダウンする準備を行ったことを通知します。
*/
void NotifySystemShutdownReady() NN_NOEXCEPT;

/*!
    @brief      スリープ準備完了まで待機します。
*/
void WaitForSleepReady() NN_NOEXCEPT;

/*!
    @brief      シャットダウン準備完了まで待機します。
*/
void WaitForShutdownReady() NN_NOEXCEPT;

}}}
