﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_TypesAdmin.h>
#include <nn/friends/friends_Macros.h>

namespace nn { namespace friends {

/*!
    @brief      拡張情報付きユーザープロフィールを扱うクラスです。
*/
class ProfileExtra
{
public:
    /*!
        @brief      コンストラクタです。
    */
    ProfileExtra() NN_NOEXCEPT;

    /*!
        @brief      ネットワークサービスアカウント ID を取得します。

        @return     ネットワークサービスアカウント ID。
    */
    nn::account::NetworkServiceAccountId GetAccountId() const NN_NOEXCEPT;

    /*!
        @brief      ニックネームを取得します。

        @return     ニックネーム。
    */
    const nn::account::Nickname& GetNickname() const NN_NOEXCEPT;

    /*!
        @brief      ユーザーのプロフィール画像 URL を取得します。

        @param[out] outUrl      プロフィール画像 URL。
        @param[in]  imageSize   画像サイズ。

        @return     処理結果。

        @pre
            - outUrl != nullptr
    */
    nn::Result GetProfileImageUrl(Url* outUrl, ImageSize imageSize) const NN_NOEXCEPT;

    /*!
        @brief      プレイログを取得します。

        @param[in]  index   インデックス。

        @return     プレイログ。

        @pre
            - 0 <= index < PlayLogCountMax

        @details
                    フレンドサーバーに記録するプレイログは @ref PlayLogCountMax 件までです。@n
                    @ref PlayLogCountMax 件以上のアプリケーションを遊んでいる場合、最後に遊んだ時間が古い順に削除されます。

                    プレイログは、ユーザー設定により非公開にされる可能性があります。@n
                    この場合、プレイログはゼロクリアされます。
    */
    const PlayLog& GetPlayLog(int index) const NN_NOEXCEPT;

    /*!
        @brief      有効なデータを保持しているかどうかを確認します。

        @return     有効なデータを保持しているかどうか。
    */
    bool IsValid() const NN_NOEXCEPT;

private:
    //
    NN_FRIENDS_CLASS_STORAGE(1024);
};

}}
