﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*!
    @brief   フレンド情報の表示及び操作に関連する UI を呼び出す処理の API を宣言します。（本体機能向け）
*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>

namespace nn { namespace friends {

/*!
    @brief      ユーザーアカウントの情報を表示します。

    @param[in]  uid     情報を表示する対象のユーザーアカウント。

    @return     処理の結果を返します

    @details
                uid で指定したユーザーアカウントの情報を表示します。
                本関数は内部で UI を表示するため、UI 操作が完了するまで処理をブロックします。
*/
nn::Result ShowMyProfile( const nn::account::Uid& uid ) NN_NOEXCEPT;

/*!
    @brief      ユーザーアカウントの情報を表示します。（HOME メニュー専用）

    @param[in]  uid     情報を表示する対象のユーザーアカウント。

    @return     処理の結果を返します

    @details
                uid で指定したユーザーアカウントの情報を表示します。
                本関数は内部で UI を表示するため、UI 操作が完了するまで処理をブロックします。
                HOME メニューから起動したときのみ演出が異なります。
*/
nn::Result ShowMyProfileForHomeMenu( const nn::account::Uid& uid ) NN_NOEXCEPT;

}} // namespace nn::friends
