﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace util {

/*!
    @brief      アプリケーション情報を取得します。

    @param[out] outInfo     アプリケーション情報。
    @param[in]  processId   プロセス ID。

    @return     処理結果。

    @pre
        - outInfo != nullptr
*/
nn::Result GetApplicationInfo(ApplicationInfo* outInfo, nn::Bit64 processId) NN_NOEXCEPT;

/*!
    @brief      指定したユーザーアカウントが最後に Open されたアプリケーションのアプリケーション情報を取得します。

    @param[out] outInfo アプリケーション情報。
    @param[in]  uid     ユーザーアカウント。

    @return     処理結果。

    @pre
        - outInfo != nullptr
*/
nn::Result GetUserLastOpenedApplicationInfo(ApplicationInfo* outInfo, const nn::account::Uid& uid) NN_NOEXCEPT;

}}}}}
