﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/ipc/friends_INotificationService.sfdl.h>
#include <nn/friends/detail/service/friends_Capability.h>
#include <nn/friends/detail/service/core/friends_ServiceMemoryManager.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace friends { namespace detail { namespace service {

/*!
    @brief      通知サービスです。
*/
class NotificationService
{
public:
    /*!
        @brief      コンストラクタです。

        @param[in]  capability  ケイパビリティ。
        @param[in]  uid         ユーザーアカウント。
    */
    NotificationService(const Capability& capability, const nn::account::Uid& uid) NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~NotificationService() NN_NOEXCEPT;

    /*!
        @brief      フレンドリストの更新を通知します。

        @param[in]  uid ユーザーアカウント。
    */
    void NotifyFriendListUpdated(const nn::account::Uid& uid) NN_NOEXCEPT;

    /*!
        @brief      フレンドプレゼンスの更新を通知します。

        @param[in]  uid         ユーザーアカウント。
        @param[in]  accountId   対象ユーザー。
    */
    void NotifyFriendPresenceUpdated(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;

    /*!
        @brief      フレンド申請の受信を通知します。

        @param[in]  uid ユーザーアカウント。
    */
    void NotifyFriendRequestReceived(const nn::account::Uid& uid) NN_NOEXCEPT;

public:
    // INotificationService
    nn::Result GetEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result Clear() NN_NOEXCEPT;
    nn::Result Pop(nn::sf::Out<nn::friends::detail::ipc::SizedNotificationInfo> outInfo) NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    Capability m_Capability;
    //
    nn::os::SystemEvent m_Event;
    bool m_IsEventCreated;
    //
    nn::account::Uid m_Uid;
    ipc::SizedNotificationInfo m_Infos[NotificationCountMax];
    int m_Count;
    //
    bool m_HasFriendListUpdated;
    bool m_HasFriendRequestReceived;

private:
    //
    void Signal() NN_NOEXCEPT;
};

NN_STATIC_ASSERT(sizeof (NotificationService) <= detail::service::core::ServiceMemoryManager::NotificationServiceSize);

}}}}
