﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/ipc/friends_IFriendService.sfdl.h>
#include <nn/friends/detail/service/friends_Capability.h>
#include <nn/friends/detail/service/core/friends_Task.h>
#include <nn/friends/detail/service/core/friends_ServiceMemoryManager.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace friends { namespace detail { namespace service {

/*!
    @brief      フレンドサービスです。
*/
class FriendService
{
public:
    /*!
        @brief      コンストラクタです。

        @param[in]  capability  ケイパビリティ。
    */
    explicit FriendService(const Capability& capability) NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。

        @details
                    @ref FriendService::GetCompletionEvent を呼び出していた場合、処理完了イベントを Signal します。
    */
    ~FriendService() NN_NOEXCEPT;

public:
    // IFriendService
    nn::Result GetCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result Cancel() NN_NOEXCEPT;
    nn::Result GetFriendListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds, const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetFriendList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result UpdateFriendInfo(const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetFriendProfileImage(nn::sf::Out<std::int32_t> outSize, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result SendFriendRequestForApplication(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result AddFacedFriendRequestForApplication(const nn::account::Uid& uid, const nn::friends::FacedFriendRequestRegistrationKey& key, const nn::account::Nickname& nickname, const nn::sf::InBuffer& image, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetBlockedUserListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetProfileList(const nn::sf::OutArray<nn::friends::detail::ProfileImpl>& outProfiles, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT;
    nn::Result DeclareOpenOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DeclareCloseOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result UpdateUserPresence(const nn::account::Uid& uid, const nn::friends::detail::UserPresenceImpl& presence, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetPlayHistoryRegistrationKey(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, const nn::account::Uid& uid, bool isLocalPlay) NN_NOEXCEPT;
    nn::Result GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, nn::account::NetworkServiceAccountId accountId, bool isLocalPlay) NN_NOEXCEPT;
    nn::Result AddPlayHistory(const nn::account::Uid& uid, const nn::friends::PlayHistoryRegistrationKey& key, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetProfileImageUrl(nn::sf::Out<nn::friends::Url> outUrl, const nn::friends::Url& url, std::int32_t imageSize) NN_NOEXCEPT;
    nn::Result GetFriendCount(nn::sf::Out<std::int32_t> outCount, const nn::account::Uid& uid, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetNewlyFriendCount(nn::sf::Out<std::int32_t> outCount, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetFriendDetailedInfo(nn::sf::Out<nn::friends::detail::FriendDetailedInfoImpl> outInfo, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result SyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result RequestSyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result LoadFriendSetting(nn::sf::Out<nn::friends::detail::FriendSettingImpl> outSetting, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result GetReceivedFriendRequestCount(nn::sf::Out<std::int32_t> outUnreadCount, nn::sf::Out<std::int32_t> outReadCount, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetFriendRequestList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendRequestImpl>& outRequests, const nn::account::Uid& uid, std::int32_t offset, std::int32_t listType) NN_NOEXCEPT;
    nn::Result GetFriendCandidateList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendCandidateImpl>& outCandidates, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
    nn::Result GetNintendoNetworkIdInfo(nn::sf::Out<nn::friends::NintendoNetworkIdUserInfo> outUserInfo, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::NintendoNetworkIdFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
    nn::Result GetSnsAccountLinkage(nn::sf::Out<nn::friends::SnsAccountLinkage> outLinkage, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetSnsAccountProfile(nn::sf::Out<nn::friends::SnsAccountProfile> outProfile, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t type) NN_NOEXCEPT;
    nn::Result GetSnsAccountFriendList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::SnsAccountFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
    nn::Result GetBlockedUserList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::BlockedUserImpl>& outUsers, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT;
    nn::Result SyncBlockedUserList(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetProfileExtraList(const nn::sf::OutArray<nn::friends::detail::ProfileExtraImpl>& outProfiles, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT;
    nn::Result GetRelationship(nn::sf::Out<nn::friends::Relationship> outRelationship, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result GetUserPresenceView(nn::sf::Out<nn::friends::detail::UserPresenceViewImpl> outPresence, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetPlayHistoryList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::PlayHistoryImpl>& outHistories, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetPlayHistoryStatistics(nn::sf::Out<nn::friends::PlayHistoryStatistics> outStatistics, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result LoadUserSetting(nn::sf::Out<nn::friends::detail::UserSettingImpl> outSetting, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result SyncUserSetting(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result RequestListSummaryOverlayNotification() NN_NOEXCEPT;
    nn::Result GetExternalApplicationCatalog(nn::sf::Out<nn::friends::ExternalApplicationCatalog> outCatalog, const nn::friends::ExternalApplicationCatalogId& catalogId, nn::settings::LanguageCode language) NN_NOEXCEPT;
    nn::Result DropFriendNewlyFlags(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DeleteFriend(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result DropFriendNewlyFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result ChangeFriendFavoriteFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT;
    nn::Result ChangeFriendOnlineNotificationFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT;
    nn::Result SendFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType) NN_NOEXCEPT;
    nn::Result SendFriendRequestWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT;
    nn::Result SendFriendRequestWithExternalApplicationCatalogId(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::ExternalApplicationCatalogId& catalogId, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT;
    nn::Result SendFriendRequestWithNintendoNetworkIdInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::MiiName& miiName, const nn::friends::MiiImageUrlParam& miiImageUrlParam, const nn::friends::MiiName& myMiiName, const nn::friends::MiiImageUrlParam& myMiiImageUrlParam) NN_NOEXCEPT;
    nn::Result CancelFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
    nn::Result AcceptFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
    nn::Result RejectFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
    nn::Result ReadFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
    nn::Result GetFacedFriendRequestRegistrationKey(nn::sf::Out<nn::friends::FacedFriendRequestRegistrationKey> outKey, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result AddFacedFriendRequest(const nn::account::Uid& uid, const nn::friends::FacedFriendRequestRegistrationKey& key, const nn::account::Nickname& nickname, const nn::sf::InBuffer& image) NN_NOEXCEPT;
    nn::Result CancelFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result GetFacedFriendRequestProfileImage(nn::sf::Out<std::int32_t> outSize, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result GetFacedFriendRequestProfileImageFromPath(nn::sf::Out<std::int32_t> outSize, const nn::sf::InArray<char>& path, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result ResendFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result GetSnsAccountLinkPageUrl(nn::sf::Out<nn::friends::WebPageUrl> outUrl, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
    nn::Result UnlinkSnsAccount(const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
    nn::Result BlockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason) NN_NOEXCEPT;
    nn::Result BlockUserWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason, const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName) NN_NOEXCEPT;
    nn::Result UnblockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result GetProfileExtraFromFriendCode(nn::sf::Out<nn::friends::detail::ProfileExtraImpl> outProfile, const nn::account::Uid& uid, const nn::friends::FriendCode& friendCode) NN_NOEXCEPT;
    nn::Result DeletePlayHistory(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ChangePresencePermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT;
    nn::Result ChangeFriendRequestReception(const nn::account::Uid& uid, bool newValue) NN_NOEXCEPT;
    nn::Result ChangePlayLogPermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT;
    nn::Result IssueFriendCode(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ClearPlayLog(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DeleteNetworkServiceAccountCache(const nn::account::Uid& uid) NN_NOEXCEPT;

private:
    //
    nn::os::Mutex m_Mutex;
    //
    Capability m_Capability;
    //
    nn::os::SystemEvent m_CompletionEvent;
    bool m_IsCompletionEventCreated;

    //
    Bit64 m_TaskBuffer[2048 / 8];
    //
    detail::service::core::Task* m_Task;
    bool m_IsAlreadyCanceled;
};

NN_STATIC_ASSERT(sizeof (FriendService) <= detail::service::core::ServiceMemoryManager::FriendServiceSize);

}}}}
