﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_StaticAssert.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <algorithm>
#include <atomic>
#include <cstdio>
#include <mutex>

#if defined (NN_BUILD_CONFIG_OS_WIN)
#include <nn/nn_Windows.h>
#endif

#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/fs.h>
#include <nn/time.h>
#include <nn/time/time_StandardUserSystemClock.h>
#include <nn/account/account_Types.h>
#include <nn/account/account_Result.h>
#include <nn/account/account_ApiForSystemServices.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/nifm/nifm_ApiRequest.h>
#include <nn/nifm/nifm_ApiInternetConnectionStatus.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_StringUtil.h>
#include <nn/util/util_Utf8StringUtil.h>
#include <nn/util/util_Uuid.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/friends/friends_Result.h>
#include <nn/friends/friends_ResultFriendRequest.h>
#include <nn/friends/friends_ResultAdmin.h>
#include <nn/friends/friends_ResultPrivate.h>

#include <nn/friends/friends_Types.h>
#include <nn/friends/friends_TypesAdmin.h>

#include <nn/friends/detail/friends_TypesDetail.h>
#include <nn/friends/detail/friends_Log.h>
#include <nn/friends/detail/friends_ImplFriend.h>
#include <nn/friends/detail/friends_ImplFriendDetailedInfo.h>
#include <nn/friends/detail/friends_ImplFriendRequest.h>
#include <nn/friends/detail/friends_ImplFriendCandidate.h>
#include <nn/friends/detail/friends_ImplNintendoNetworkIdFriend.h>
#include <nn/friends/detail/friends_ImplBlockedUser.h>
#include <nn/friends/detail/friends_ImplPlayHistory.h>
#include <nn/friends/detail/friends_ImplPresence.h>
#include <nn/friends/detail/friends_ImplPresenceView.h>
#include <nn/friends/detail/friends_ImplProfile.h>
#include <nn/friends/detail/friends_ImplProfileExtra.h>
#include <nn/friends/detail/friends_ImplSetting.h>
#include <nn/friends/detail/friends_ImplSnsAccountFriend.h>

#include <nn/friends/detail/ipc/friends_IpcSizedStructure.h>

#include <nn/friends/detail/util/friends_HexToNumber.h>

#include <nn/friends/detail/service/core/friends_Account.h>
#include <nn/friends/detail/service/core/friends_AccountStorageManager.h>
#include <nn/friends/detail/service/core/friends_DataVerifier.h>
#include <nn/friends/detail/service/core/friends_FileSystem.h>
#include <nn/friends/detail/service/core/friends_NotificationEventHandler.h>
#include <nn/friends/detail/service/core/friends_ParameterConverter.h>
#include <nn/friends/detail/service/core/friends_Resources.h>
#include <nn/friends/detail/service/core/friends_WebApi.h>

#include <nn/friends/detail/service/json/friends_JsonHttpInputStream.h>
#include <nn/friends/detail/service/json/friends_JsonApi.h>
#include <nn/friends/detail/service/json/friends_JsonPatchGenerator.h>

#include <nn/friends/detail/service/util/friends_ArrayAccessor.h>
#include <nn/friends/detail/service/util/friends_Random.h>
