﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/task/friends_TaskSyncFriendListBase.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンド申請を送信するタスクです。
*/
class SendFriendRequestTask : public SyncFriendListBaseTask
{
public:
    /*!
        @brief      コンストラクタです。
    */
    SendFriendRequestTask() NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  accountId   相手のネットワークサービスアカウント ID。
        @param[in]  requestType フレンド申請手段。

        @return     処理結果。
    */
    nn::Result SetParameter(nn::account::NetworkServiceAccountId accountId, RequestType requestType) NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  accountId           相手のネットワークサービスアカウント ID。
        @param[in]  requestType         フレンド申請手段。
        @param[in]  appInfo             いっしょに遊んだアプリ。
        @param[in]  inAppScreenName     相手のアプリ内表示名。
        @param[in]  myInAppScreenName   自分のアプリ内表示名。

        @return     処理結果。
    */
    nn::Result SetParameter(nn::account::NetworkServiceAccountId accountId, RequestType requestType,
        const ApplicationInfo& appInfo, const InAppScreenName& inAppScreenName, const InAppScreenName& myInAppScreenName) NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  accountId           相手のネットワークサービスアカウント ID。
        @param[in]  requestType         フレンド申請手段。
        @param[in]  catalogId           いっしょに遊んだ外部アプリのカタログ ID。
        @param[in]  inAppScreenName     相手のアプリ内表示名。
        @param[in]  myInAppScreenName   自分のアプリ内表示名。

        @return     処理結果。
    */
    nn::Result SetParameter(nn::account::NetworkServiceAccountId accountId, RequestType requestType,
        const ExternalApplicationCatalogId& catalogId, const InAppScreenName& inAppScreenName, const InAppScreenName& myInAppScreenName) NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  accountId           相手のネットワークサービスアカウント ID。
        @param[in]  requestType         フレンド申請手段。
        @param[in]  miiName             相手の Mii の名前。
        @param[in]  miiImageUrlParam    相手の Mii 画像 URL パラメータ。
        @param[in]  myMiiName           自分の Mii の名前。
        @param[in]  myMiiImageUrlParam  自分の Mii 画像 URL パラメータ。

        @return     処理結果。
    */
    nn::Result SetParameter(nn::account::NetworkServiceAccountId accountId, RequestType requestType,
        const MiiName& miiName, const MiiImageUrlParam& miiImageUrlParam, const MiiName& myMiiName, const MiiImageUrlParam& myMiiImageUrlParam) NN_NOEXCEPT;

private:
    //
    bool m_IsParameterSet;
    bool m_IsParameterSetWithAppInfo;
    bool m_IsParameterSetWithExternalApplicationCatalogId;
    bool m_IsParameterSetWithNintendoNetworkIdInfo;
    //
    nn::account::NetworkServiceAccountId m_AccountId;
    RequestType m_RequestType;
    //
    ApplicationInfo m_AppInfo;
    ExternalApplicationCatalogId m_CatalogId;
    //
    InAppScreenName m_InAppScreenName;
    InAppScreenName m_MyInAppScreenName;
    //
    MiiName m_MiiName;
    MiiImageUrlParam m_MiiImageUrlParam;
    MiiName m_MyMiiName;
    MiiImageUrlParam m_MyMiiImageUrlParam;
    //
    bool m_IsSyncNeeded;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Result StepSend() NN_NOEXCEPT;
    nn::Result CreateSendPostField(char* buffer, size_t size) NN_NOEXCEPT;
    //
    void WriteExtras(detail::service::json::JsonWriter& writer) NN_NOEXCEPT;
    void WriteExtrasWithAppInfo(detail::service::json::JsonWriter& writer) NN_NOEXCEPT;
    void WriteExtrasWithExternalApplicationCatalogId(detail::service::json::JsonWriter& writer) NN_NOEXCEPT;
    void WriteExtrasWithNintendoNetworkIdInfo(detail::service::json::JsonWriter& writer) NN_NOEXCEPT;
};

}}}}}
