﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/task/friends_TaskGetFriendRequestCountBase.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンド申請を既読にするタスクです。
*/
class ReadFriendRequestTask : public GetFriendRequestCountBaseTask
{
public:
    /*!
        @brief      コンストラクタです。
    */
    ReadFriendRequestTask() NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  requestId   フレンド申請 ID。

        @return     処理結果。
    */
    nn::Result SetParameter(RequestId requestId) NN_NOEXCEPT;

private:
    //
    bool m_IsParameterSet;
    //
    RequestId m_RequestId;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Result StepRead() NN_NOEXCEPT;
    nn::Result CreateReadPatch(char* buffer, size_t size) NN_NOEXCEPT;
};

}}}}}
