﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/friends_Task.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      NNID 情報を取得するタスクです。
*/
class GetNintendoNetworkIdInfoTask : public Task
{
public:
    /*!
        @brief      コンストラクタです。
    */
    GetNintendoNetworkIdInfoTask() NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[out] outUserInfo ユーザーアカウントに紐付く NNID のユーザー情報。
        @param[out] outCount    取得した数。
        @param[out] outFriends  フレンドリスト。
        @param[in]  count       フレンドリストの要素数。
        @param[in]  type        アカウントの種類。

        @return     処理結果。
    */
    nn::Result SetParameter(NintendoNetworkIdUserInfo* outUserInfo, int* outCount, NintendoNetworkIdFriendImpl* outFriends,
        int count, NintendoNetworkIdAccountType type) NN_NOEXCEPT;

private:
    //
    bool m_IsParameterSet;
    //
    NintendoNetworkIdUserInfo* m_OutUserInfo;
    int* m_OutCount;
    NintendoNetworkIdFriendImpl* m_OutFriends;
    //
    int m_Count;
    NintendoNetworkIdAccountType m_Type;
    //
    Account::NintendoAccountIdToken m_IdToken;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Result StepGetIdToken() NN_NOEXCEPT;
    //
    nn::Result StepGetList() NN_NOEXCEPT;
};

}}}}}
