﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/task/friends_TaskSyncFriendListBase.h>
#include <nn/friends/detail/service/core/task/friends_TaskGetFriendRequestCountBase.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンド申請の状態を変更するタスクです。
*/
class ChangeFriendRequestStatusTask : public SyncFriendListBaseTask, public GetFriendRequestCountBaseTask
{
public:
    /*!
        @brief      コンストラクタです。
    */
    ChangeFriendRequestStatusTask() NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  requestId   フレンド申請 ID。
        @param[in]  newStatus   新しい設定値。

        @return     処理結果。
    */
    nn::Result SetParameter(RequestId requestId, RequestStatus newStatus) NN_NOEXCEPT;

private:
    //
    bool m_IsParameterSet;
    //
    RequestId m_RequestId;
    RequestStatus m_Status;
    //
    bool m_IsSyncNeeded;
    bool m_IsGetCountNeeded;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Result StepChange() NN_NOEXCEPT;
    nn::Result CreateChangePatch(char* buffer, size_t size) NN_NOEXCEPT;
};

}}}}}
