﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/friends_Task.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンドのオンライン通知フラグを変更するタスクです。
*/
class ChangeFriendOnlineNotificationFlagTask : public Task
{
public:
    /*!
        @brief      コンストラクタです。
    */
    ChangeFriendOnlineNotificationFlagTask() NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  accountId   フレンドのネットワークサービスアカウント ID。
        @param[in]  newValue    新しい設定値。

        @return     処理結果。
    */
    nn::Result SetParameter(nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT;

private:
    //
    bool m_IsParameterSet;
    //
    nn::account::NetworkServiceAccountId m_FriendAccountId;
    bool m_NewValue;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Result StepChange() NN_NOEXCEPT;
    nn::Result CreateChangePatch(char* buffer, size_t size) NN_NOEXCEPT;
};

}}}}}
