﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/core/task/friends_TaskSyncBlockedUserListBase.h>
#include <nn/friends/detail/service/core/task/friends_TaskSyncFriendListBase.h>
#include <nn/friends/detail/service/core/task/friends_TaskGetFriendRequestCountBase.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      ユーザーをブロックするタスクです。
*/
class BlockUserTask : public SyncBlockedUserListBaseTask, public SyncFriendListBaseTask, public GetFriendRequestCountBaseTask
{
public:
    /*!
        @brief      コンストラクタです。
    */
    BlockUserTask() NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  accountId   相手のネットワークサービスアカウント ID。
        @param[in]  blockReason ブロック理由。

        @return     処理結果。
    */
    nn::Result SetParameter(nn::account::NetworkServiceAccountId accountId, BlockReason blockReason) NN_NOEXCEPT;

    /*!
        @brief      パラメータを設定します。

        @param[in]  accountId       相手のネットワークサービスアカウント ID。
        @param[in]  blockReason     ブロック理由。
        @param[in]  appInfo         いっしょに遊んだアプリ。
        @param[in]  inAppScreenName 相手のアプリ内表示名。

        @return     処理結果。
    */
    nn::Result SetParameter(nn::account::NetworkServiceAccountId accountId, BlockReason blockReason,
        const ApplicationInfo& appInfo, const InAppScreenName& inAppScreenName) NN_NOEXCEPT;

private:
    //
    bool m_IsParameterSet;
    bool m_IsParameterSetWithAppInfo;
    //
    nn::account::NetworkServiceAccountId m_AccountId;
    BlockReason m_BlockReason;
    //
    ApplicationInfo m_AppInfo;
    InAppScreenName m_InAppScreenName;

private:
    //
    virtual nn::Result Main() NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::Result StepBlock() NN_NOEXCEPT;
    nn::Result CreateBlockPostField(char* buffer, size_t size) NN_NOEXCEPT;
};

}}}}}
