﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      フレンドリソースリストのハンドラです。
*/
class FriendResourceListForPresenceHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      フレンドリソースのパース結果です。
    */
    struct FriendResourceParseBits
    {
        Bit64 accountId : 1;
        Bit64 presenceStatus : 1;
        Bit64 presenceAppId : 1;
        Bit64 presencePresenceGroupId : 1;
        Bit64 presenceLastUpdateTime : 1;
        Bit64 presenceAppField : 1;
        Bit64 presenceLogoutTime : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    FriendResourceListForPresenceHandler() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~FriendResourceListForPresenceHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[in]  uid ユーザーアカウント。
    */
    void Initialize(const nn::account::Uid& uid) NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    nn::account::Uid m_Uid;
    //
    FriendResource m_Resource;
    //
    FriendResourceParseBits m_Bits;

private:
    //
    bool ParseFriendPresenceAppField(const char* json, size_t length) NN_NOEXCEPT;
};

}}}}}
