﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      外部アプリケーションカタログのハンドラです。
*/
class ExternalApplicationCatalogHandler : public detail::service::json::JsonEventHandler
{
public:
    /*!
        @brief      外部アプリケーションカタログのパース結果です。
    */
    struct ExternalApplicationCatalogParseBits
    {
        Bit64 catalogId : 1;
        Bit64 name : 1;
        Bit64 icon : 1;
    };

public:
    /*!
        @brief      コンストラクタです。
    */
    ExternalApplicationCatalogHandler() NN_NOEXCEPT;

    /*!
        @brief      初期化します。

        @param[out] outCatalog  外部アプリケーションカタログ。
        @param[in]  language    言語コード。

        @pre
            - outCatalog != nullptr
            - language != nullptr
    */
    void Initialize(ExternalApplicationCatalog* outCatalog, const nn::settings::LanguageCode& language) NN_NOEXCEPT;

public:
    // JsonEventHandler
    virtual bool OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT NN_OVERRIDE;

private:
    //
    ExternalApplicationCatalog* m_OutCatalog;
    ExternalApplicationCatalogParseBits m_Bits;
    //
    nn::settings::LanguageCode m_Language;
    const char* m_LanguageNaLocale;
};

}}}}}
