﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>
#include <nn/friends/detail/service/json/friends_JsonEventHandler.h>
#include <nn/friends/detail/service/json/friends_JsonHttpInputStream.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      WEB API モジュールです。
*/
class WebApi
{
public:
    /*!
        @brief      FQDN を取得します。

        @return     FQDN。
    */
    static const char* GetFqdn() NN_NOEXCEPT;

    /*!
        @brief      WEB API を実行します。

        @param[in]  okHandler                   2xx 系成功時のイベントハンドラ。
        @param[in]  errorHandler                エラー時のイベントハンドラ。
        @param[in]  stream                      HTTP 入力ストリーム。
        @param[in]  uid                         ユーザーアカウント。
        @param[in]  cancelable                  キャンセル可能オブジェクト。
        @param[in]  isAuthenticationRequired    認証が必要かどうか。

        @return     処理結果。

        @details
                    本関数は、以下の関数を呼び出します。

                    - JsonHttpInputStream::AddRequestHeader
                    - JsonHttpInputStream::SetBuffer
                    - JsonHttpInputStream::SetCancelable
                    - JsonHttpInputStream::RegisterResponseHeaderEndCallback

                    認証トークンの取得とリクエストヘッダへの設定を自動で行います。
    */
    static nn::Result Call(detail::service::json::JsonEventHandler& okHandler, detail::service::json::JsonEventHandler& errorHandler,
        detail::service::json::JsonHttpInputStream& stream, const nn::account::Uid& uid, const detail::service::util::Cancelable& cancelable,
        bool isAuthenticationRequired = true) NN_NOEXCEPT;

    /*!
        @brief      WEB API を実行します。

        @param[in]  okHandler                   2xx 系成功時のイベントハンドラ。
        @param[in]  stream                      HTTP 入力ストリーム。
        @param[in]  uid                         ユーザーアカウント。
        @param[in]  cancelable                  キャンセル可能オブジェクト。
        @param[in]  isAuthenticationRequired    認証が必要かどうか。

        @return     処理結果。

        @details
                    本関数は、エラー時のイベントハンドラにデフォルトの @ref ErrorHandler を指定します。
    */
    static nn::Result Call(detail::service::json::JsonEventHandler& okHandler,
        detail::service::json::JsonHttpInputStream& stream, const nn::account::Uid& uid, const detail::service::util::Cancelable& cancelable,
        bool isAuthenticationRequired = true) NN_NOEXCEPT;
};

}}}}}
