﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      ユーザーリソースです。
*/
struct UserResource
{
    // 4
    int32_t presencePermission;
    // 4
    int32_t playLogPermission;
    // 1
    bool friendRequestReception;
    // 7
    Bit8 reserved[7];
    // 32
    FriendCode friendCode;
    // 8
    nn::time::PosixTime friendCodeNextIssuableTime;
    // 1024
    ProfileExtraImpl profileExtra;
};

NN_STATIC_ASSERT(sizeof (UserResource) == 1080);

/*!
    @brief      フレンドリソースです。
*/
struct FriendResource
{
    // 8
    nn::account::NetworkServiceAccountId accountId;
    // 40
    nn::account::Nickname nickname;
    char nicknamePadding[7];
    // 160
    Url profileImageUrl;
    // 800
    PlayLog playLog[PlayLogCountMax];
    // 168
    PlayRecord lastPlayRecord;
    // 4
    int32_t requestType;
    // 1
    bool isFavorite;
    // 1
    bool isNewly;
    // 1
    bool isOnlineNotification;
    // 1
    Bit8 reserved1[1];
    // 96
    RouteInfo requestRouteInfo;
    // 224
    FriendPresenceImpl presence;
    // 48
    RouteInfoExtra requestRouteInfoExtra;
    // 8
    nn::time::PosixTime logoutTime;
};

NN_STATIC_ASSERT(sizeof (FriendResource) == 1560);

/*!
    @brief      フレンド申請リソースです。
*/
struct FriendRequestResource
{
    // 8
    RequestId requestId;
    // 8
    nn::account::NetworkServiceAccountId accountId;
    // 40
    nn::account::Nickname nickname;
    char nicknamePadding[7];
    // 160
    Url profileImageUrl;
    // 4
    int32_t requestType;
    // 4
    int32_t requestStatus;
    // 96
    RouteInfo routeInfo;
    // 1
    bool read;
    // 7
    Bit8 reserved2[7];
    // 48
    RouteInfoExtra routeInfoExtra;
};

NN_STATIC_ASSERT(sizeof (FriendRequestResource) == 376);

/*!
    @brief      対面フレンド申請リソースです。
*/
struct FacedFriendRequestResource
{
    // 8
    nn::account::NetworkServiceAccountId accountId;
    // 40
    nn::account::Nickname nickname;
    char nicknamePadding[7];
    // 4
    int32_t requestType;
    // 4
    int32_t requestStatus;
    // 16
    ApplicationInfo appInfo;
    // 72
    InAppScreenName inAppScreenName;
    // 72
    InAppScreenName myInAppScreenName;
};

NN_STATIC_ASSERT(sizeof (FacedFriendRequestResource) == 216);

/*!
    @brief      ブロックしたユーザーのリソースです。
*/
struct BlockedUserResource
{
    // 8
    nn::account::NetworkServiceAccountId accountId;
    // 40
    nn::account::Nickname nickname;
    char nicknamePadding[7];
    // 160
    Url profileImageUrl;
    // 4
    int32_t blockReason;
    // 4
    Bit8 reseved[4];
    // 96
    RouteInfo routeInfo;
};

NN_STATIC_ASSERT(sizeof (BlockedUserResource) == 312);

}}}}}
