﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/detail/service/friends_Common.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

/*!
    @brief      各種システムイベントを監視するモジュールです。

    @details
                以下のシステムイベントを監視します。

                - ユーザーアカウントの登録通知
                - ユーザーアカウントの状態変化通知
                - NPNS の状態変化通知
*/
class EventWatcher
{
public:
    /*!
        @brief      初期化します。

        @details
                    本体起動時点ですでに作成されているユーザーアカウントのリストを取得し、各モジュールに設定します。
    */
    static void Iniaialize() NN_NOEXCEPT;

    /*!
        @brief      スレッドの実行を開始します。
    */
    static void Start() NN_NOEXCEPT;

    /*!
        @brief      スレッドの実行を終了します。
    */
    static void Stop() NN_NOEXCEPT;

    /*!
        @brief      イベントの監視処理を停止します。
    */
    static void Suspend() NN_NOEXCEPT;

    /*!
        @brief      イベントの監視処理を開始します。
    */
    static void Resume() NN_NOEXCEPT;
};

}}}}}
