﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace friends { namespace detail { namespace ipc {

/*!
    @brief      一般権限のサービス名です。
*/
const char ServiceNameForGeneric[] = "friend:u";

/*!
    @brief      閲覧権限のサービス名です。
*/
const char ServiceNameForViewer[] = "friend:v";

/*!
    @brief      管理権限のサービス名です。
*/
const char ServiceNameForManager[] = "friend:m";

/*!
    @brief      システム権限のサービス名です。
*/
const char ServiceNameForSystem[] = "friend:s";

/*!
    @brief      全権のサービス名です。
*/
const char ServiceNameForAdministrator[] = "friend:a";

/*!
    @brief      サービス名の数です。
*/
const int ServiceCount = 5;

}}}}
