﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/account_Types.h>
#include <nn/friends/detail/friends_ImplBlockedUser.h>
#include <nn/friends/detail/friends_ImplFriend.h>
#include <nn/friends/detail/friends_ImplFriendCandidate.h>
#include <nn/friends/detail/friends_ImplFriendDetailedInfo.h>
#include <nn/friends/detail/friends_ImplFriendRequest.h>
#include <nn/friends/detail/friends_ImplNintendoNetworkIdFriend.h>
#include <nn/friends/detail/friends_ImplPlayHistory.h>
#include <nn/friends/detail/friends_ImplPresence.h>
#include <nn/friends/detail/friends_ImplPresenceView.h>
#include <nn/friends/detail/friends_ImplProfile.h>
#include <nn/friends/detail/friends_ImplProfileExtra.h>
#include <nn/friends/detail/friends_ImplSetting.h>
#include <nn/friends/detail/friends_ImplSnsAccountFriend.h>
#include <nn/friends/detail/ipc/friends_IpcSizedStructure.h>
#include <nn/friends/friends_Types.h>
#include <nn/friends/friends_TypesAdmin.h>
#include <nn/friends/friends_TypesFriendRequest.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_Language.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace friends { namespace detail { namespace ipc { // NOLINT(whitespace/braces)

class IFriendService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFriendService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFriendService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCompletionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendListIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::account::NetworkServiceAccountId>& outAccountIds, const ::nn::account::Uid& uid, ::std::int32_t offset, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t offset, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateFriendInfo, (const ::nn::sf::OutArray<::nn::friends::detail::FriendImpl>& outFriends, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendProfileImage, (::nn::sf::Out<::std::int32_t> outSize, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::sf::OutBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestForApplication, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddFacedFriendRequestForApplication, (const ::nn::account::Uid& uid, const ::nn::friends::FacedFriendRequestRegistrationKey& key, const ::nn::account::Nickname& nickname, const ::nn::sf::InBuffer& image, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBlockedUserListIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::account::NetworkServiceAccountId>& outAccountIds, const ::nn::account::Uid& uid, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileList, (const ::nn::sf::OutArray<::nn::friends::detail::ProfileImpl>& outProfiles, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeclareOpenOnlinePlaySession, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeclareCloseOnlinePlaySession, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateUserPresence, (const ::nn::account::Uid& uid, const ::nn::friends::detail::UserPresenceImpl& presence, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryRegistrationKey, (::nn::sf::Out<::nn::friends::PlayHistoryRegistrationKey> outKey, const ::nn::account::Uid& uid, bool isLocalPlay))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId, (::nn::sf::Out<::nn::friends::PlayHistoryRegistrationKey> outKey, ::nn::account::NetworkServiceAccountId accountId, bool isLocalPlay))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddPlayHistory, (const ::nn::account::Uid& uid, const ::nn::friends::PlayHistoryRegistrationKey& key, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileImageUrl, (::nn::sf::Out<::nn::friends::Url> outUrl, const ::nn::friends::Url& url, ::std::int32_t imageSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendCount, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::account::Uid& uid, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNewlyFriendCount, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendDetailedInfo, (::nn::sf::Out<::nn::friends::detail::FriendDetailedInfoImpl> outInfo, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SyncFriendList, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncFriendList, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadFriendSetting, (::nn::sf::Out<::nn::friends::detail::FriendSettingImpl> outSetting, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedFriendRequestCount, (::nn::sf::Out<::std::int32_t> outUnreadCount, ::nn::sf::Out<::std::int32_t> outReadCount, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendRequestList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendRequestImpl>& outRequests, const ::nn::account::Uid& uid, ::std::int32_t offset, ::std::int32_t listType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendCandidateList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendCandidateImpl>& outCandidates, const ::nn::account::Uid& uid, ::std::int32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoNetworkIdInfo, (::nn::sf::Out<::nn::friends::NintendoNetworkIdUserInfo> outUserInfo, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::NintendoNetworkIdFriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountLinkage, (::nn::sf::Out<::nn::friends::SnsAccountLinkage> outLinkage, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountProfile, (::nn::sf::Out<::nn::friends::SnsAccountProfile> outProfile, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountFriendList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::SnsAccountFriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBlockedUserList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::BlockedUserImpl>& outUsers, const ::nn::account::Uid& uid, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SyncBlockedUserList, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileExtraList, (const ::nn::sf::OutArray<::nn::friends::detail::ProfileExtraImpl>& outProfiles, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRelationship, (::nn::sf::Out<::nn::friends::Relationship> outRelationship, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetUserPresenceView, (::nn::sf::Out<::nn::friends::detail::UserPresenceViewImpl> outPresence, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::PlayHistoryImpl>& outHistories, const ::nn::account::Uid& uid, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryStatistics, (::nn::sf::Out<::nn::friends::PlayHistoryStatistics> outStatistics, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadUserSetting, (::nn::sf::Out<::nn::friends::detail::UserSettingImpl> outSetting, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SyncUserSetting, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RequestListSummaryOverlayNotification)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetExternalApplicationCatalog, (::nn::sf::Out<::nn::friends::ExternalApplicationCatalog> outCatalog, const ::nn::friends::ExternalApplicationCatalogId& catalogId, ::nn::settings::LanguageCode language))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DropFriendNewlyFlags, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFriend, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DropFriendNewlyFlag, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ChangeFriendFavoriteFlag, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, bool newValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ChangeFriendOnlineNotificationFlag, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, bool newValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequest, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestWithApplicationInfo, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::ApplicationInfo& appInfo, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcceptFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RejectFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFacedFriendRequestRegistrationKey, (::nn::sf::Out<::nn::friends::FacedFriendRequestRegistrationKey> outKey, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddFacedFriendRequest, (const ::nn::account::Uid& uid, const ::nn::friends::FacedFriendRequestRegistrationKey& key, const ::nn::account::Nickname& nickname, const ::nn::sf::InBuffer& image))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelFacedFriendRequest, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFacedFriendRequestProfileImage, (::nn::sf::Out<::std::int32_t> outSize, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::sf::OutBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFacedFriendRequestProfileImageFromPath, (::nn::sf::Out<::std::int32_t> outSize, const ::nn::sf::InArray<char>& path, const ::nn::sf::OutBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestWithExternalApplicationCatalogId, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::ExternalApplicationCatalogId& catalogId, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResendFacedFriendRequest, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestWithNintendoNetworkIdInfo, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::MiiName& miiName, const ::nn::friends::MiiImageUrlParam& miiImageUrlParam, const ::nn::friends::MiiName& myMiiName, const ::nn::friends::MiiImageUrlParam& myMiiImageUrlParam))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountLinkPageUrl, (::nn::sf::Out<::nn::friends::WebPageUrl> outUrl, const ::nn::account::Uid& uid, ::std::int32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnlinkSnsAccount, (const ::nn::account::Uid& uid, ::std::int32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BlockUser, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t blockReason))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BlockUserWithApplicationInfo, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t blockReason, const ::nn::friends::ApplicationInfo& appInfo, const ::nn::friends::InAppScreenName& inAppScreenName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnblockUser, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileExtraFromFriendCode, (::nn::sf::Out<::nn::friends::detail::ProfileExtraImpl> outProfile, const ::nn::account::Uid& uid, const ::nn::friends::FriendCode& friendCode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeletePlayHistory, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ChangePresencePermission, (const ::nn::account::Uid& uid, ::std::int32_t newValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ChangeFriendRequestReception, (const ::nn::account::Uid& uid, bool newValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ChangePlayLogPermission, (const ::nn::account::Uid& uid, ::std::int32_t newValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IssueFriendCode, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearPlayLog, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteNetworkServiceAccountCache, (const ::nn::account::Uid& uid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFriendService)

        ::nn::Result GetCompletionEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCompletionEvent, (outHandle));
        }

        ::nn::Result Cancel() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Cancel);
        }

        ::nn::Result GetFriendListIds(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::account::NetworkServiceAccountId>& outAccountIds, const ::nn::account::Uid& uid, ::std::int32_t offset, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFriendListIds, (outCount, outAccountIds, uid, offset, filter, processId));
        }

        ::nn::Result GetFriendList(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t offset, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFriendList, (outCount, outFriends, uid, offset, filter, processId));
        }

        ::nn::Result UpdateFriendInfo(const ::nn::sf::OutArray<::nn::friends::detail::FriendImpl>& outFriends, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateFriendInfo, (outFriends, uid, accountIds, processId));
        }

        ::nn::Result GetFriendProfileImage(::nn::sf::Out<::std::int32_t> outSize, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFriendProfileImage, (outSize, uid, accountId, buffer));
        }

        ::nn::Result SendFriendRequestForApplication(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendFriendRequestForApplication, (uid, accountId, inAppScreenName, myInAppScreenName, processId));
        }

        ::nn::Result AddFacedFriendRequestForApplication(const ::nn::account::Uid& uid, const ::nn::friends::FacedFriendRequestRegistrationKey& key, const ::nn::account::Nickname& nickname, const ::nn::sf::InBuffer& image, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddFacedFriendRequestForApplication, (uid, key, nickname, image, inAppScreenName, myInAppScreenName, processId));
        }

        ::nn::Result GetBlockedUserListIds(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::account::NetworkServiceAccountId>& outAccountIds, const ::nn::account::Uid& uid, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBlockedUserListIds, (outCount, outAccountIds, uid, offset));
        }

        ::nn::Result GetProfileList(const ::nn::sf::OutArray<::nn::friends::detail::ProfileImpl>& outProfiles, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProfileList, (outProfiles, uid, accountIds));
        }

        ::nn::Result DeclareOpenOnlinePlaySession(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeclareOpenOnlinePlaySession, (uid));
        }

        ::nn::Result DeclareCloseOnlinePlaySession(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeclareCloseOnlinePlaySession, (uid));
        }

        ::nn::Result UpdateUserPresence(const ::nn::account::Uid& uid, const ::nn::friends::detail::UserPresenceImpl& presence, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateUserPresence, (uid, presence, processId));
        }

        ::nn::Result GetPlayHistoryRegistrationKey(::nn::sf::Out<::nn::friends::PlayHistoryRegistrationKey> outKey, const ::nn::account::Uid& uid, bool isLocalPlay) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPlayHistoryRegistrationKey, (outKey, uid, isLocalPlay));
        }

        ::nn::Result GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId(::nn::sf::Out<::nn::friends::PlayHistoryRegistrationKey> outKey, ::nn::account::NetworkServiceAccountId accountId, bool isLocalPlay) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId, (outKey, accountId, isLocalPlay));
        }

        ::nn::Result AddPlayHistory(const ::nn::account::Uid& uid, const ::nn::friends::PlayHistoryRegistrationKey& key, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddPlayHistory, (uid, key, inAppScreenName, myInAppScreenName, processId));
        }

        ::nn::Result GetProfileImageUrl(::nn::sf::Out<::nn::friends::Url> outUrl, const ::nn::friends::Url& url, ::std::int32_t imageSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProfileImageUrl, (outUrl, url, imageSize));
        }

        ::nn::Result GetFriendCount(::nn::sf::Out<::std::int32_t> outCount, const ::nn::account::Uid& uid, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFriendCount, (outCount, uid, filter, processId));
        }

        ::nn::Result GetNewlyFriendCount(::nn::sf::Out<::std::int32_t> outCount, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNewlyFriendCount, (outCount, uid));
        }

        ::nn::Result GetFriendDetailedInfo(::nn::sf::Out<::nn::friends::detail::FriendDetailedInfoImpl> outInfo, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFriendDetailedInfo, (outInfo, uid, accountId));
        }

        ::nn::Result SyncFriendList(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SyncFriendList, (uid));
        }

        ::nn::Result RequestSyncFriendList(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestSyncFriendList, (uid));
        }

        ::nn::Result LoadFriendSetting(::nn::sf::Out<::nn::friends::detail::FriendSettingImpl> outSetting, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadFriendSetting, (outSetting, uid, accountId));
        }

        ::nn::Result GetReceivedFriendRequestCount(::nn::sf::Out<::std::int32_t> outUnreadCount, ::nn::sf::Out<::std::int32_t> outReadCount, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReceivedFriendRequestCount, (outUnreadCount, outReadCount, uid));
        }

        ::nn::Result GetFriendRequestList(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendRequestImpl>& outRequests, const ::nn::account::Uid& uid, ::std::int32_t offset, ::std::int32_t listType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFriendRequestList, (outCount, outRequests, uid, offset, listType));
        }

        ::nn::Result GetFriendCandidateList(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendCandidateImpl>& outCandidates, const ::nn::account::Uid& uid, ::std::int32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFriendCandidateList, (outCount, outCandidates, uid, type));
        }

        ::nn::Result GetNintendoNetworkIdInfo(::nn::sf::Out<::nn::friends::NintendoNetworkIdUserInfo> outUserInfo, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::NintendoNetworkIdFriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNintendoNetworkIdInfo, (outUserInfo, outCount, outFriends, uid, type));
        }

        ::nn::Result GetSnsAccountLinkage(::nn::sf::Out<::nn::friends::SnsAccountLinkage> outLinkage, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSnsAccountLinkage, (outLinkage, uid));
        }

        ::nn::Result GetSnsAccountProfile(::nn::sf::Out<::nn::friends::SnsAccountProfile> outProfile, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSnsAccountProfile, (outProfile, uid, accountId, type));
        }

        ::nn::Result GetSnsAccountFriendList(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::SnsAccountFriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSnsAccountFriendList, (outCount, outFriends, uid, type));
        }

        ::nn::Result GetBlockedUserList(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::BlockedUserImpl>& outUsers, const ::nn::account::Uid& uid, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBlockedUserList, (outCount, outUsers, uid, offset));
        }

        ::nn::Result SyncBlockedUserList(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SyncBlockedUserList, (uid));
        }

        ::nn::Result GetProfileExtraList(const ::nn::sf::OutArray<::nn::friends::detail::ProfileExtraImpl>& outProfiles, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProfileExtraList, (outProfiles, uid, accountIds));
        }

        ::nn::Result GetRelationship(::nn::sf::Out<::nn::friends::Relationship> outRelationship, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRelationship, (outRelationship, uid, accountId));
        }

        ::nn::Result GetUserPresenceView(::nn::sf::Out<::nn::friends::detail::UserPresenceViewImpl> outPresence, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetUserPresenceView, (outPresence, uid));
        }

        ::nn::Result GetPlayHistoryList(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::PlayHistoryImpl>& outHistories, const ::nn::account::Uid& uid, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPlayHistoryList, (outCount, outHistories, uid, offset));
        }

        ::nn::Result GetPlayHistoryStatistics(::nn::sf::Out<::nn::friends::PlayHistoryStatistics> outStatistics, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPlayHistoryStatistics, (outStatistics, uid));
        }

        ::nn::Result LoadUserSetting(::nn::sf::Out<::nn::friends::detail::UserSettingImpl> outSetting, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadUserSetting, (outSetting, uid));
        }

        ::nn::Result SyncUserSetting(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SyncUserSetting, (uid));
        }

        ::nn::Result RequestListSummaryOverlayNotification() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RequestListSummaryOverlayNotification);
        }

        ::nn::Result GetExternalApplicationCatalog(::nn::sf::Out<::nn::friends::ExternalApplicationCatalog> outCatalog, const ::nn::friends::ExternalApplicationCatalogId& catalogId, ::nn::settings::LanguageCode language) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetExternalApplicationCatalog, (outCatalog, catalogId, language));
        }

        ::nn::Result DropFriendNewlyFlags(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DropFriendNewlyFlags, (uid));
        }

        ::nn::Result DeleteFriend(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteFriend, (uid, accountId));
        }

        ::nn::Result DropFriendNewlyFlag(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DropFriendNewlyFlag, (uid, accountId));
        }

        ::nn::Result ChangeFriendFavoriteFlag(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ChangeFriendFavoriteFlag, (uid, accountId, newValue));
        }

        ::nn::Result ChangeFriendOnlineNotificationFlag(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ChangeFriendOnlineNotificationFlag, (uid, accountId, newValue));
        }

        ::nn::Result SendFriendRequest(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendFriendRequest, (uid, accountId, requestType));
        }

        ::nn::Result SendFriendRequestWithApplicationInfo(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::ApplicationInfo& appInfo, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendFriendRequestWithApplicationInfo, (uid, accountId, requestType, appInfo, inAppScreenName, myInAppScreenName));
        }

        ::nn::Result CancelFriendRequest(const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelFriendRequest, (uid, requestId));
        }

        ::nn::Result AcceptFriendRequest(const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcceptFriendRequest, (uid, requestId));
        }

        ::nn::Result RejectFriendRequest(const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RejectFriendRequest, (uid, requestId));
        }

        ::nn::Result ReadFriendRequest(const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadFriendRequest, (uid, requestId));
        }

        ::nn::Result GetFacedFriendRequestRegistrationKey(::nn::sf::Out<::nn::friends::FacedFriendRequestRegistrationKey> outKey, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFacedFriendRequestRegistrationKey, (outKey, uid));
        }

        ::nn::Result AddFacedFriendRequest(const ::nn::account::Uid& uid, const ::nn::friends::FacedFriendRequestRegistrationKey& key, const ::nn::account::Nickname& nickname, const ::nn::sf::InBuffer& image) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddFacedFriendRequest, (uid, key, nickname, image));
        }

        ::nn::Result CancelFacedFriendRequest(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelFacedFriendRequest, (uid, accountId));
        }

        ::nn::Result GetFacedFriendRequestProfileImage(::nn::sf::Out<::std::int32_t> outSize, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFacedFriendRequestProfileImage, (outSize, uid, accountId, buffer));
        }

        ::nn::Result GetFacedFriendRequestProfileImageFromPath(::nn::sf::Out<::std::int32_t> outSize, const ::nn::sf::InArray<char>& path, const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFacedFriendRequestProfileImageFromPath, (outSize, path, buffer));
        }

        ::nn::Result SendFriendRequestWithExternalApplicationCatalogId(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::ExternalApplicationCatalogId& catalogId, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendFriendRequestWithExternalApplicationCatalogId, (uid, accountId, requestType, catalogId, inAppScreenName, myInAppScreenName));
        }

        ::nn::Result ResendFacedFriendRequest(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResendFacedFriendRequest, (uid, accountId));
        }

        ::nn::Result SendFriendRequestWithNintendoNetworkIdInfo(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::MiiName& miiName, const ::nn::friends::MiiImageUrlParam& miiImageUrlParam, const ::nn::friends::MiiName& myMiiName, const ::nn::friends::MiiImageUrlParam& myMiiImageUrlParam) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SendFriendRequestWithNintendoNetworkIdInfo, (uid, accountId, requestType, miiName, miiImageUrlParam, myMiiName, myMiiImageUrlParam));
        }

        ::nn::Result GetSnsAccountLinkPageUrl(::nn::sf::Out<::nn::friends::WebPageUrl> outUrl, const ::nn::account::Uid& uid, ::std::int32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSnsAccountLinkPageUrl, (outUrl, uid, type));
        }

        ::nn::Result UnlinkSnsAccount(const ::nn::account::Uid& uid, ::std::int32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnlinkSnsAccount, (uid, type));
        }

        ::nn::Result BlockUser(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t blockReason) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BlockUser, (uid, accountId, blockReason));
        }

        ::nn::Result BlockUserWithApplicationInfo(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t blockReason, const ::nn::friends::ApplicationInfo& appInfo, const ::nn::friends::InAppScreenName& inAppScreenName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BlockUserWithApplicationInfo, (uid, accountId, blockReason, appInfo, inAppScreenName));
        }

        ::nn::Result UnblockUser(const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnblockUser, (uid, accountId));
        }

        ::nn::Result GetProfileExtraFromFriendCode(::nn::sf::Out<::nn::friends::detail::ProfileExtraImpl> outProfile, const ::nn::account::Uid& uid, const ::nn::friends::FriendCode& friendCode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProfileExtraFromFriendCode, (outProfile, uid, friendCode));
        }

        ::nn::Result DeletePlayHistory(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeletePlayHistory, (uid));
        }

        ::nn::Result ChangePresencePermission(const ::nn::account::Uid& uid, ::std::int32_t newValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ChangePresencePermission, (uid, newValue));
        }

        ::nn::Result ChangeFriendRequestReception(const ::nn::account::Uid& uid, bool newValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ChangeFriendRequestReception, (uid, newValue));
        }

        ::nn::Result ChangePlayLogPermission(const ::nn::account::Uid& uid, ::std::int32_t newValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ChangePlayLogPermission, (uid, newValue));
        }

        ::nn::Result IssueFriendCode(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IssueFriendCode, (uid));
        }

        ::nn::Result ClearPlayLog(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearPlayLog, (uid));
        }

        ::nn::Result DeleteNetworkServiceAccountCache(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteNetworkServiceAccountCache, (uid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFriendService
    {
    public:
        nn::Result GetCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result Cancel() NN_NOEXCEPT;
        nn::Result GetFriendListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds, const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result GetFriendList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result UpdateFriendInfo(const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result GetFriendProfileImage(nn::sf::Out<std::int32_t> outSize, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
        nn::Result SendFriendRequestForApplication(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result AddFacedFriendRequestForApplication(const nn::account::Uid& uid, const nn::friends::FacedFriendRequestRegistrationKey& key, const nn::account::Nickname& nickname, const nn::sf::InBuffer& image, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result GetBlockedUserListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT;
        nn::Result GetProfileList(const nn::sf::OutArray<nn::friends::detail::ProfileImpl>& outProfiles, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT;
        nn::Result DeclareOpenOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result DeclareCloseOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result UpdateUserPresence(const nn::account::Uid& uid, const nn::friends::detail::UserPresenceImpl& presence, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result GetPlayHistoryRegistrationKey(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, const nn::account::Uid& uid, bool isLocalPlay) NN_NOEXCEPT;
        nn::Result GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, nn::account::NetworkServiceAccountId accountId, bool isLocalPlay) NN_NOEXCEPT;
        nn::Result AddPlayHistory(const nn::account::Uid& uid, const nn::friends::PlayHistoryRegistrationKey& key, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result GetProfileImageUrl(nn::sf::Out<nn::friends::Url> outUrl, const nn::friends::Url& url, std::int32_t imageSize) NN_NOEXCEPT;
        nn::Result GetFriendCount(nn::sf::Out<std::int32_t> outCount, const nn::account::Uid& uid, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result GetNewlyFriendCount(nn::sf::Out<std::int32_t> outCount, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetFriendDetailedInfo(nn::sf::Out<nn::friends::detail::FriendDetailedInfoImpl> outInfo, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
        nn::Result SyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result RequestSyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result LoadFriendSetting(nn::sf::Out<nn::friends::detail::FriendSettingImpl> outSetting, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
        nn::Result GetReceivedFriendRequestCount(nn::sf::Out<std::int32_t> outUnreadCount, nn::sf::Out<std::int32_t> outReadCount, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetFriendRequestList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendRequestImpl>& outRequests, const nn::account::Uid& uid, std::int32_t offset, std::int32_t listType) NN_NOEXCEPT;
        nn::Result GetFriendCandidateList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendCandidateImpl>& outCandidates, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
        nn::Result GetNintendoNetworkIdInfo(nn::sf::Out<nn::friends::NintendoNetworkIdUserInfo> outUserInfo, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::NintendoNetworkIdFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
        nn::Result GetSnsAccountLinkage(nn::sf::Out<nn::friends::SnsAccountLinkage> outLinkage, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetSnsAccountProfile(nn::sf::Out<nn::friends::SnsAccountProfile> outProfile, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t type) NN_NOEXCEPT;
        nn::Result GetSnsAccountFriendList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::SnsAccountFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
        nn::Result GetBlockedUserList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::BlockedUserImpl>& outUsers, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT;
        nn::Result SyncBlockedUserList(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetProfileExtraList(const nn::sf::OutArray<nn::friends::detail::ProfileExtraImpl>& outProfiles, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT;
        nn::Result GetRelationship(nn::sf::Out<nn::friends::Relationship> outRelationship, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
        nn::Result GetUserPresenceView(nn::sf::Out<nn::friends::detail::UserPresenceViewImpl> outPresence, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetPlayHistoryList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::PlayHistoryImpl>& outHistories, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT;
        nn::Result GetPlayHistoryStatistics(nn::sf::Out<nn::friends::PlayHistoryStatistics> outStatistics, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result LoadUserSetting(nn::sf::Out<nn::friends::detail::UserSettingImpl> outSetting, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result SyncUserSetting(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result RequestListSummaryOverlayNotification() NN_NOEXCEPT;
        nn::Result GetExternalApplicationCatalog(nn::sf::Out<nn::friends::ExternalApplicationCatalog> outCatalog, const nn::friends::ExternalApplicationCatalogId& catalogId, nn::settings::LanguageCode language) NN_NOEXCEPT;
        nn::Result DropFriendNewlyFlags(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result DeleteFriend(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
        nn::Result DropFriendNewlyFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
        nn::Result ChangeFriendFavoriteFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT;
        nn::Result ChangeFriendOnlineNotificationFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT;
        nn::Result SendFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType) NN_NOEXCEPT;
        nn::Result SendFriendRequestWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT;
        nn::Result CancelFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
        nn::Result AcceptFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
        nn::Result RejectFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
        nn::Result ReadFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
        nn::Result GetFacedFriendRequestRegistrationKey(nn::sf::Out<nn::friends::FacedFriendRequestRegistrationKey> outKey, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result AddFacedFriendRequest(const nn::account::Uid& uid, const nn::friends::FacedFriendRequestRegistrationKey& key, const nn::account::Nickname& nickname, const nn::sf::InBuffer& image) NN_NOEXCEPT;
        nn::Result CancelFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
        nn::Result GetFacedFriendRequestProfileImage(nn::sf::Out<std::int32_t> outSize, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
        nn::Result GetFacedFriendRequestProfileImageFromPath(nn::sf::Out<std::int32_t> outSize, const nn::sf::InArray<char>& path, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
        nn::Result SendFriendRequestWithExternalApplicationCatalogId(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::ExternalApplicationCatalogId& catalogId, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT;
        nn::Result ResendFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
        nn::Result SendFriendRequestWithNintendoNetworkIdInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::MiiName& miiName, const nn::friends::MiiImageUrlParam& miiImageUrlParam, const nn::friends::MiiName& myMiiName, const nn::friends::MiiImageUrlParam& myMiiImageUrlParam) NN_NOEXCEPT;
        nn::Result GetSnsAccountLinkPageUrl(nn::sf::Out<nn::friends::WebPageUrl> outUrl, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
        nn::Result UnlinkSnsAccount(const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
        nn::Result BlockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason) NN_NOEXCEPT;
        nn::Result BlockUserWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason, const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName) NN_NOEXCEPT;
        nn::Result UnblockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
        nn::Result GetProfileExtraFromFriendCode(nn::sf::Out<nn::friends::detail::ProfileExtraImpl> outProfile, const nn::account::Uid& uid, const nn::friends::FriendCode& friendCode) NN_NOEXCEPT;
        nn::Result DeletePlayHistory(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result ChangePresencePermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT;
        nn::Result ChangeFriendRequestReception(const nn::account::Uid& uid, bool newValue) NN_NOEXCEPT;
        nn::Result ChangePlayLogPermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT;
        nn::Result IssueFriendCode(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result ClearPlayLog(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result DeleteNetworkServiceAccountCache(const nn::account::Uid& uid) NN_NOEXCEPT;
    };
#endif

}}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result Cancel() NN_NOEXCEPT;
    nn::Result GetFriendListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds, const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetFriendList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result UpdateFriendInfo(const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetFriendProfileImage(nn::sf::Out<std::int32_t> outSize, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result SendFriendRequestForApplication(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result AddFacedFriendRequestForApplication(const nn::account::Uid& uid, const nn::friends::FacedFriendRequestRegistrationKey& key, const nn::account::Nickname& nickname, const nn::sf::InBuffer& image, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetBlockedUserListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetProfileList(const nn::sf::OutArray<nn::friends::detail::ProfileImpl>& outProfiles, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT;
    nn::Result DeclareOpenOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DeclareCloseOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result UpdateUserPresence(const nn::account::Uid& uid, const nn::friends::detail::UserPresenceImpl& presence, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetPlayHistoryRegistrationKey(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, const nn::account::Uid& uid, bool isLocalPlay) NN_NOEXCEPT;
    nn::Result GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, nn::account::NetworkServiceAccountId accountId, bool isLocalPlay) NN_NOEXCEPT;
    nn::Result AddPlayHistory(const nn::account::Uid& uid, const nn::friends::PlayHistoryRegistrationKey& key, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetProfileImageUrl(nn::sf::Out<nn::friends::Url> outUrl, const nn::friends::Url& url, std::int32_t imageSize) NN_NOEXCEPT;
    nn::Result GetFriendCount(nn::sf::Out<std::int32_t> outCount, const nn::account::Uid& uid, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result GetNewlyFriendCount(nn::sf::Out<std::int32_t> outCount, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetFriendDetailedInfo(nn::sf::Out<nn::friends::detail::FriendDetailedInfoImpl> outInfo, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result SyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result RequestSyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result LoadFriendSetting(nn::sf::Out<nn::friends::detail::FriendSettingImpl> outSetting, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result GetReceivedFriendRequestCount(nn::sf::Out<std::int32_t> outUnreadCount, nn::sf::Out<std::int32_t> outReadCount, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetFriendRequestList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendRequestImpl>& outRequests, const nn::account::Uid& uid, std::int32_t offset, std::int32_t listType) NN_NOEXCEPT;
    nn::Result GetFriendCandidateList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendCandidateImpl>& outCandidates, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
    nn::Result GetNintendoNetworkIdInfo(nn::sf::Out<nn::friends::NintendoNetworkIdUserInfo> outUserInfo, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::NintendoNetworkIdFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
    nn::Result GetSnsAccountLinkage(nn::sf::Out<nn::friends::SnsAccountLinkage> outLinkage, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetSnsAccountProfile(nn::sf::Out<nn::friends::SnsAccountProfile> outProfile, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t type) NN_NOEXCEPT;
    nn::Result GetSnsAccountFriendList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::SnsAccountFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
    nn::Result GetBlockedUserList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::BlockedUserImpl>& outUsers, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT;
    nn::Result SyncBlockedUserList(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetProfileExtraList(const nn::sf::OutArray<nn::friends::detail::ProfileExtraImpl>& outProfiles, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT;
    nn::Result GetRelationship(nn::sf::Out<nn::friends::Relationship> outRelationship, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result GetUserPresenceView(nn::sf::Out<nn::friends::detail::UserPresenceViewImpl> outPresence, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetPlayHistoryList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::PlayHistoryImpl>& outHistories, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetPlayHistoryStatistics(nn::sf::Out<nn::friends::PlayHistoryStatistics> outStatistics, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result LoadUserSetting(nn::sf::Out<nn::friends::detail::UserSettingImpl> outSetting, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result SyncUserSetting(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result RequestListSummaryOverlayNotification() NN_NOEXCEPT;
    nn::Result GetExternalApplicationCatalog(nn::sf::Out<nn::friends::ExternalApplicationCatalog> outCatalog, const nn::friends::ExternalApplicationCatalogId& catalogId, nn::settings::LanguageCode language) NN_NOEXCEPT;
    nn::Result DropFriendNewlyFlags(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DeleteFriend(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result DropFriendNewlyFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result ChangeFriendFavoriteFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT;
    nn::Result ChangeFriendOnlineNotificationFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT;
    nn::Result SendFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType) NN_NOEXCEPT;
    nn::Result SendFriendRequestWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT;
    nn::Result CancelFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
    nn::Result AcceptFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
    nn::Result RejectFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
    nn::Result ReadFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT;
    nn::Result GetFacedFriendRequestRegistrationKey(nn::sf::Out<nn::friends::FacedFriendRequestRegistrationKey> outKey, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result AddFacedFriendRequest(const nn::account::Uid& uid, const nn::friends::FacedFriendRequestRegistrationKey& key, const nn::account::Nickname& nickname, const nn::sf::InBuffer& image) NN_NOEXCEPT;
    nn::Result CancelFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result GetFacedFriendRequestProfileImage(nn::sf::Out<std::int32_t> outSize, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result GetFacedFriendRequestProfileImageFromPath(nn::sf::Out<std::int32_t> outSize, const nn::sf::InArray<char>& path, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    nn::Result SendFriendRequestWithExternalApplicationCatalogId(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::ExternalApplicationCatalogId& catalogId, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT;
    nn::Result ResendFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result SendFriendRequestWithNintendoNetworkIdInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::MiiName& miiName, const nn::friends::MiiImageUrlParam& miiImageUrlParam, const nn::friends::MiiName& myMiiName, const nn::friends::MiiImageUrlParam& myMiiImageUrlParam) NN_NOEXCEPT;
    nn::Result GetSnsAccountLinkPageUrl(nn::sf::Out<nn::friends::WebPageUrl> outUrl, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
    nn::Result UnlinkSnsAccount(const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT;
    nn::Result BlockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason) NN_NOEXCEPT;
    nn::Result BlockUserWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason, const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName) NN_NOEXCEPT;
    nn::Result UnblockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT;
    nn::Result GetProfileExtraFromFriendCode(nn::sf::Out<nn::friends::detail::ProfileExtraImpl> outProfile, const nn::account::Uid& uid, const nn::friends::FriendCode& friendCode) NN_NOEXCEPT;
    nn::Result DeletePlayHistory(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ChangePresencePermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT;
    nn::Result ChangeFriendRequestReception(const nn::account::Uid& uid, bool newValue) NN_NOEXCEPT;
    nn::Result ChangePlayLogPermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT;
    nn::Result IssueFriendCode(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result ClearPlayLog(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DeleteNetworkServiceAccountCache(const nn::account::Uid& uid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::friends::detail::ipc::IFriendService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCompletionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCompletionEvent, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Cancel);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendListIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::account::NetworkServiceAccountId>& outAccountIds, const ::nn::account::Uid& uid, ::std::int32_t offset, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFriendListIds, (outCount, outAccountIds, uid, offset, filter, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t offset, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFriendList, (outCount, outFriends, uid, offset, filter, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateFriendInfo, (const ::nn::sf::OutArray<::nn::friends::detail::FriendImpl>& outFriends, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateFriendInfo, (outFriends, uid, accountIds, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendProfileImage, (::nn::sf::Out<::std::int32_t> outSize, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFriendProfileImage, (outSize, uid, accountId, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestForApplication, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendFriendRequestForApplication, (uid, accountId, inAppScreenName, myInAppScreenName, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddFacedFriendRequestForApplication, (const ::nn::account::Uid& uid, const ::nn::friends::FacedFriendRequestRegistrationKey& key, const ::nn::account::Nickname& nickname, const ::nn::sf::InBuffer& image, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddFacedFriendRequestForApplication, (uid, key, nickname, image, inAppScreenName, myInAppScreenName, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBlockedUserListIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::account::NetworkServiceAccountId>& outAccountIds, const ::nn::account::Uid& uid, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBlockedUserListIds, (outCount, outAccountIds, uid, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileList, (const ::nn::sf::OutArray<::nn::friends::detail::ProfileImpl>& outProfiles, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProfileList, (outProfiles, uid, accountIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeclareOpenOnlinePlaySession, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeclareOpenOnlinePlaySession, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeclareCloseOnlinePlaySession, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeclareCloseOnlinePlaySession, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateUserPresence, (const ::nn::account::Uid& uid, const ::nn::friends::detail::UserPresenceImpl& presence, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateUserPresence, (uid, presence, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryRegistrationKey, (::nn::sf::Out<::nn::friends::PlayHistoryRegistrationKey> outKey, const ::nn::account::Uid& uid, bool isLocalPlay))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPlayHistoryRegistrationKey, (outKey, uid, isLocalPlay));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId, (::nn::sf::Out<::nn::friends::PlayHistoryRegistrationKey> outKey, ::nn::account::NetworkServiceAccountId accountId, bool isLocalPlay))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId, (outKey, accountId, isLocalPlay));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddPlayHistory, (const ::nn::account::Uid& uid, const ::nn::friends::PlayHistoryRegistrationKey& key, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddPlayHistory, (uid, key, inAppScreenName, myInAppScreenName, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileImageUrl, (::nn::sf::Out<::nn::friends::Url> outUrl, const ::nn::friends::Url& url, ::std::int32_t imageSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProfileImageUrl, (outUrl, url, imageSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendCount, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::account::Uid& uid, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFriendCount, (outCount, uid, filter, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNewlyFriendCount, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNewlyFriendCount, (outCount, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendDetailedInfo, (::nn::sf::Out<::nn::friends::detail::FriendDetailedInfoImpl> outInfo, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFriendDetailedInfo, (outInfo, uid, accountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SyncFriendList, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SyncFriendList, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncFriendList, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestSyncFriendList, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadFriendSetting, (::nn::sf::Out<::nn::friends::detail::FriendSettingImpl> outSetting, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadFriendSetting, (outSetting, uid, accountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedFriendRequestCount, (::nn::sf::Out<::std::int32_t> outUnreadCount, ::nn::sf::Out<::std::int32_t> outReadCount, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReceivedFriendRequestCount, (outUnreadCount, outReadCount, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendRequestList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendRequestImpl>& outRequests, const ::nn::account::Uid& uid, ::std::int32_t offset, ::std::int32_t listType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFriendRequestList, (outCount, outRequests, uid, offset, listType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendCandidateList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendCandidateImpl>& outCandidates, const ::nn::account::Uid& uid, ::std::int32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFriendCandidateList, (outCount, outCandidates, uid, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoNetworkIdInfo, (::nn::sf::Out<::nn::friends::NintendoNetworkIdUserInfo> outUserInfo, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::NintendoNetworkIdFriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNintendoNetworkIdInfo, (outUserInfo, outCount, outFriends, uid, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountLinkage, (::nn::sf::Out<::nn::friends::SnsAccountLinkage> outLinkage, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSnsAccountLinkage, (outLinkage, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountProfile, (::nn::sf::Out<::nn::friends::SnsAccountProfile> outProfile, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSnsAccountProfile, (outProfile, uid, accountId, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountFriendList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::SnsAccountFriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSnsAccountFriendList, (outCount, outFriends, uid, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBlockedUserList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::BlockedUserImpl>& outUsers, const ::nn::account::Uid& uid, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBlockedUserList, (outCount, outUsers, uid, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SyncBlockedUserList, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SyncBlockedUserList, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileExtraList, (const ::nn::sf::OutArray<::nn::friends::detail::ProfileExtraImpl>& outProfiles, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProfileExtraList, (outProfiles, uid, accountIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRelationship, (::nn::sf::Out<::nn::friends::Relationship> outRelationship, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRelationship, (outRelationship, uid, accountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserPresenceView, (::nn::sf::Out<::nn::friends::detail::UserPresenceViewImpl> outPresence, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetUserPresenceView, (outPresence, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::PlayHistoryImpl>& outHistories, const ::nn::account::Uid& uid, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPlayHistoryList, (outCount, outHistories, uid, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryStatistics, (::nn::sf::Out<::nn::friends::PlayHistoryStatistics> outStatistics, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPlayHistoryStatistics, (outStatistics, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadUserSetting, (::nn::sf::Out<::nn::friends::detail::UserSettingImpl> outSetting, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadUserSetting, (outSetting, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SyncUserSetting, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SyncUserSetting, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestListSummaryOverlayNotification)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RequestListSummaryOverlayNotification);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetExternalApplicationCatalog, (::nn::sf::Out<::nn::friends::ExternalApplicationCatalog> outCatalog, const ::nn::friends::ExternalApplicationCatalogId& catalogId, ::nn::settings::LanguageCode language))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetExternalApplicationCatalog, (outCatalog, catalogId, language));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DropFriendNewlyFlags, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DropFriendNewlyFlags, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFriend, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteFriend, (uid, accountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DropFriendNewlyFlag, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DropFriendNewlyFlag, (uid, accountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangeFriendFavoriteFlag, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, bool newValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ChangeFriendFavoriteFlag, (uid, accountId, newValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangeFriendOnlineNotificationFlag, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, bool newValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ChangeFriendOnlineNotificationFlag, (uid, accountId, newValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequest, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendFriendRequest, (uid, accountId, requestType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestWithApplicationInfo, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::ApplicationInfo& appInfo, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendFriendRequestWithApplicationInfo, (uid, accountId, requestType, appInfo, inAppScreenName, myInAppScreenName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelFriendRequest, (uid, requestId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcceptFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcceptFriendRequest, (uid, requestId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RejectFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RejectFriendRequest, (uid, requestId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadFriendRequest, (uid, requestId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFacedFriendRequestRegistrationKey, (::nn::sf::Out<::nn::friends::FacedFriendRequestRegistrationKey> outKey, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFacedFriendRequestRegistrationKey, (outKey, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddFacedFriendRequest, (const ::nn::account::Uid& uid, const ::nn::friends::FacedFriendRequestRegistrationKey& key, const ::nn::account::Nickname& nickname, const ::nn::sf::InBuffer& image))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddFacedFriendRequest, (uid, key, nickname, image));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelFacedFriendRequest, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelFacedFriendRequest, (uid, accountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFacedFriendRequestProfileImage, (::nn::sf::Out<::std::int32_t> outSize, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFacedFriendRequestProfileImage, (outSize, uid, accountId, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFacedFriendRequestProfileImageFromPath, (::nn::sf::Out<::std::int32_t> outSize, const ::nn::sf::InArray<char>& path, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFacedFriendRequestProfileImageFromPath, (outSize, path, buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestWithExternalApplicationCatalogId, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::ExternalApplicationCatalogId& catalogId, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendFriendRequestWithExternalApplicationCatalogId, (uid, accountId, requestType, catalogId, inAppScreenName, myInAppScreenName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResendFacedFriendRequest, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResendFacedFriendRequest, (uid, accountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestWithNintendoNetworkIdInfo, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::MiiName& miiName, const ::nn::friends::MiiImageUrlParam& miiImageUrlParam, const ::nn::friends::MiiName& myMiiName, const ::nn::friends::MiiImageUrlParam& myMiiImageUrlParam))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SendFriendRequestWithNintendoNetworkIdInfo, (uid, accountId, requestType, miiName, miiImageUrlParam, myMiiName, myMiiImageUrlParam));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountLinkPageUrl, (::nn::sf::Out<::nn::friends::WebPageUrl> outUrl, const ::nn::account::Uid& uid, ::std::int32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSnsAccountLinkPageUrl, (outUrl, uid, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnlinkSnsAccount, (const ::nn::account::Uid& uid, ::std::int32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnlinkSnsAccount, (uid, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BlockUser, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t blockReason))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BlockUser, (uid, accountId, blockReason));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BlockUserWithApplicationInfo, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t blockReason, const ::nn::friends::ApplicationInfo& appInfo, const ::nn::friends::InAppScreenName& inAppScreenName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BlockUserWithApplicationInfo, (uid, accountId, blockReason, appInfo, inAppScreenName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnblockUser, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnblockUser, (uid, accountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileExtraFromFriendCode, (::nn::sf::Out<::nn::friends::detail::ProfileExtraImpl> outProfile, const ::nn::account::Uid& uid, const ::nn::friends::FriendCode& friendCode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProfileExtraFromFriendCode, (outProfile, uid, friendCode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeletePlayHistory, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeletePlayHistory, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangePresencePermission, (const ::nn::account::Uid& uid, ::std::int32_t newValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ChangePresencePermission, (uid, newValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangeFriendRequestReception, (const ::nn::account::Uid& uid, bool newValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ChangeFriendRequestReception, (uid, newValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangePlayLogPermission, (const ::nn::account::Uid& uid, ::std::int32_t newValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ChangePlayLogPermission, (uid, newValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IssueFriendCode, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IssueFriendCode, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearPlayLog, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearPlayLog, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteNetworkServiceAccountCache, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteNetworkServiceAccountCache, (uid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::friends::detail::ipc::IFriendService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::friends::detail::ipc::IFriendService))

    // nn::Result GetCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCompletionEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCompletionEvent)

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Cancel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Cancel)

    // nn::Result GetFriendListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds, const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFriendListIds)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAccountIds, 0, (const ::nn::sf::OutArray<::nn::account::NetworkServiceAccountId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAccountIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::friends::detail::ipc::SizedFriendFilter), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (offset, uid, filter, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAccountIds), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFriendListIds)

    // nn::Result GetFriendList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFriendList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outFriends, 0, (const ::nn::sf::OutArray<::nn::friends::detail::FriendImpl>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outFriends))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::friends::detail::ipc::SizedFriendFilter), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (offset, uid, filter, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFriends), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFriendList)

    // nn::Result UpdateFriendInfo(const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateFriendInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outFriends, 0, (const ::nn::sf::OutArray<::nn::friends::detail::FriendImpl>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(accountIds, 1, (const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outFriends, accountIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFriends), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountIds), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateFriendInfo)

    // nn::Result GetFriendProfileImage(nn::sf::Out<std::int32_t> outSize, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFriendProfileImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10110)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFriendProfileImage)

    // nn::Result SendFriendRequestForApplication(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendFriendRequestForApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(inAppScreenName, 0, (const ::nn::friends::InAppScreenName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(myInAppScreenName, 1, (const ::nn::friends::InAppScreenName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (inAppScreenName, myInAppScreenName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (uid, accountId, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAppScreenName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(myInAppScreenName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendFriendRequestForApplication)

    // nn::Result AddFacedFriendRequestForApplication(const nn::account::Uid& uid, const nn::friends::FacedFriendRequestRegistrationKey& key, const nn::account::Nickname& nickname, const nn::sf::InBuffer& image, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddFacedFriendRequestForApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10211)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(inAppScreenName, 0, (const ::nn::friends::InAppScreenName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(myInAppScreenName, 1, (const ::nn::friends::InAppScreenName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(image, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (inAppScreenName, myInAppScreenName, image))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::friends::FacedFriendRequestRegistrationKey), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(nickname, (::nn::account::Nickname), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 104)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 120)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (key, nickname, uid, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(128)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nickname), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(image), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAppScreenName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(myInAppScreenName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddFacedFriendRequestForApplication)

    // nn::Result GetBlockedUserListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBlockedUserListIds)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outAccountIds, 0, (const ::nn::sf::OutArray<::nn::account::NetworkServiceAccountId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outAccountIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAccountIds), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBlockedUserListIds)

    // nn::Result GetProfileList(const nn::sf::OutArray<nn::friends::detail::ProfileImpl>& outProfiles, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProfileList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10500)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outProfiles, 0, (const ::nn::sf::OutArray<::nn::friends::detail::ProfileImpl>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(accountIds, 1, (const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outProfiles, accountIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outProfiles), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProfileList)

    // nn::Result DeclareOpenOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeclareOpenOnlinePlaySession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10600)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeclareOpenOnlinePlaySession)

    // nn::Result DeclareCloseOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeclareCloseOnlinePlaySession)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10601)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeclareCloseOnlinePlaySession)

    // nn::Result UpdateUserPresence(const nn::account::Uid& uid, const nn::friends::detail::UserPresenceImpl& presence, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateUserPresence)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10610)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(presence, 0, (const ::nn::friends::detail::UserPresenceImpl&), 224, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (presence))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(presence), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateUserPresence)

    // nn::Result GetPlayHistoryRegistrationKey(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, const nn::account::Uid& uid, bool isLocalPlay) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPlayHistoryRegistrationKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10700)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outKey, 0, (::nn::sf::Out<::nn::friends::PlayHistoryRegistrationKey>), 64, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outKey))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isLocalPlay, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isLocalPlay, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isLocalPlay)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPlayHistoryRegistrationKey)

    // nn::Result GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, nn::account::NetworkServiceAccountId accountId, bool isLocalPlay) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10701)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outKey, 0, (::nn::sf::Out<::nn::friends::PlayHistoryRegistrationKey>), 64, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outKey))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isLocalPlay, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isLocalPlay, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isLocalPlay)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId)

    // nn::Result AddPlayHistory(const nn::account::Uid& uid, const nn::friends::PlayHistoryRegistrationKey& key, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddPlayHistory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10702)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(key, 0, (const ::nn::friends::PlayHistoryRegistrationKey&), 64, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(inAppScreenName, 1, (const ::nn::friends::InAppScreenName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(myInAppScreenName, 2, (const ::nn::friends::InAppScreenName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (key, inAppScreenName, myInAppScreenName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAppScreenName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(myInAppScreenName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddPlayHistory)

    // nn::Result GetProfileImageUrl(nn::sf::Out<nn::friends::Url> outUrl, const nn::friends::Url& url, std::int32_t imageSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProfileImageUrl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(url, (::nn::friends::Url), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(imageSize, (::std::int32_t), 160)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (url, imageSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(164)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outUrl, (::nn::friends::Url), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outUrl))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(160)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUrl), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(url), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(imageSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProfileImageUrl)

    // nn::Result GetFriendCount(nn::sf::Out<std::int32_t> outCount, const nn::account::Uid& uid, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFriendCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filter, (::nn::friends::detail::ipc::SizedFriendFilter), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (uid, filter, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFriendCount)

    // nn::Result GetNewlyFriendCount(nn::sf::Out<std::int32_t> outCount, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNewlyFriendCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNewlyFriendCount)

    // nn::Result GetFriendDetailedInfo(nn::sf::Out<nn::friends::detail::FriendDetailedInfoImpl> outInfo, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFriendDetailedInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outInfo, 0, (::nn::sf::Out<::nn::friends::detail::FriendDetailedInfoImpl>), 2048, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFriendDetailedInfo)

    // nn::Result SyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SyncFriendList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20103)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SyncFriendList)

    // nn::Result RequestSyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSyncFriendList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20104)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSyncFriendList)

    // nn::Result LoadFriendSetting(nn::sf::Out<nn::friends::detail::FriendSettingImpl> outSetting, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadFriendSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20110)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outSetting, 0, (::nn::sf::Out<::nn::friends::detail::FriendSettingImpl>), 64, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outSetting))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSetting), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadFriendSetting)

    // nn::Result GetReceivedFriendRequestCount(nn::sf::Out<std::int32_t> outUnreadCount, nn::sf::Out<std::int32_t> outReadCount, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReceivedFriendRequestCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outUnreadCount, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outReadCount, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outUnreadCount, outReadCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUnreadCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outReadCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReceivedFriendRequestCount)

    // nn::Result GetFriendRequestList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendRequestImpl>& outRequests, const nn::account::Uid& uid, std::int32_t offset, std::int32_t listType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFriendRequestList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outRequests, 0, (const ::nn::sf::OutArray<::nn::friends::detail::FriendRequestImpl>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outRequests))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(listType, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (offset, listType, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRequests), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(listType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFriendRequestList)

    // nn::Result GetFriendCandidateList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendCandidateImpl>& outCandidates, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFriendCandidateList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outCandidates, 0, (const ::nn::sf::OutArray<::nn::friends::detail::FriendCandidateImpl>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outCandidates))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCandidates), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFriendCandidateList)

    // nn::Result GetNintendoNetworkIdInfo(nn::sf::Out<nn::friends::NintendoNetworkIdUserInfo> outUserInfo, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::NintendoNetworkIdFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNintendoNetworkIdInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outUserInfo, 0, (::nn::sf::Out<::nn::friends::NintendoNetworkIdUserInfo>), 56, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outFriends, 1, (const ::nn::sf::OutArray<::nn::friends::detail::NintendoNetworkIdFriendImpl>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outUserInfo, outFriends))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUserInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFriends), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNintendoNetworkIdInfo)

    // nn::Result GetSnsAccountLinkage(nn::sf::Out<nn::friends::SnsAccountLinkage> outLinkage, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSnsAccountLinkage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLinkage, (::nn::friends::SnsAccountLinkage), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outLinkage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLinkage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSnsAccountLinkage)

    // nn::Result GetSnsAccountProfile(nn::sf::Out<nn::friends::SnsAccountProfile> outProfile, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSnsAccountProfile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20303)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outProfile, 0, (::nn::sf::Out<::nn::friends::SnsAccountProfile>), 896, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outProfile))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (type, uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outProfile), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSnsAccountProfile)

    // nn::Result GetSnsAccountFriendList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::SnsAccountFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSnsAccountFriendList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20304)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outFriends, 0, (const ::nn::sf::OutArray<::nn::friends::detail::SnsAccountFriendImpl>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outFriends))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFriends), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSnsAccountFriendList)

    // nn::Result GetBlockedUserList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::BlockedUserImpl>& outUsers, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBlockedUserList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outUsers, 0, (const ::nn::sf::OutArray<::nn::friends::detail::BlockedUserImpl>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outUsers))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUsers), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBlockedUserList)

    // nn::Result SyncBlockedUserList(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SyncBlockedUserList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SyncBlockedUserList)

    // nn::Result GetProfileExtraList(const nn::sf::OutArray<nn::friends::detail::ProfileExtraImpl>& outProfiles, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProfileExtraList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20500)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outProfiles, 0, (const ::nn::sf::OutArray<::nn::friends::detail::ProfileExtraImpl>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(accountIds, 1, (const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outProfiles, accountIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outProfiles), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProfileExtraList)

    // nn::Result GetRelationship(nn::sf::Out<nn::friends::Relationship> outRelationship, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRelationship)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20501)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRelationship, (::nn::friends::Relationship), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outRelationship))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRelationship), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRelationship)

    // nn::Result GetUserPresenceView(nn::sf::Out<nn::friends::detail::UserPresenceViewImpl> outPresence, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetUserPresenceView)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20600)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outPresence, 0, (::nn::sf::Out<::nn::friends::detail::UserPresenceViewImpl>), 224, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outPresence))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPresence), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetUserPresenceView)

    // nn::Result GetPlayHistoryList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::PlayHistoryImpl>& outHistories, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPlayHistoryList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20700)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outHistories, 0, (const ::nn::sf::OutArray<::nn::friends::detail::PlayHistoryImpl>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outHistories))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHistories), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPlayHistoryList)

    // nn::Result GetPlayHistoryStatistics(nn::sf::Out<nn::friends::PlayHistoryStatistics> outStatistics, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPlayHistoryStatistics)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20701)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStatistics, (::nn::friends::PlayHistoryStatistics), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outStatistics))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStatistics), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPlayHistoryStatistics)

    // nn::Result LoadUserSetting(nn::sf::Out<nn::friends::detail::UserSettingImpl> outSetting, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadUserSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20800)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outSetting, 0, (::nn::sf::Out<::nn::friends::detail::UserSettingImpl>), 2048, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outSetting))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSetting), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadUserSetting)

    // nn::Result SyncUserSetting(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SyncUserSetting)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20801)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SyncUserSetting)

    // nn::Result RequestListSummaryOverlayNotification() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestListSummaryOverlayNotification)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20900)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestListSummaryOverlayNotification)

    // nn::Result GetExternalApplicationCatalog(nn::sf::Out<nn::friends::ExternalApplicationCatalog> outCatalog, const nn::friends::ExternalApplicationCatalogId& catalogId, nn::settings::LanguageCode language) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetExternalApplicationCatalog)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outCatalog, 0, (::nn::sf::Out<::nn::friends::ExternalApplicationCatalog>), 1208, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outCatalog))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(language, (::nn::settings::LanguageCode), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(catalogId, (::nn::friends::ExternalApplicationCatalogId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (language, catalogId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCatalog), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(catalogId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(language)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetExternalApplicationCatalog)

    // nn::Result DropFriendNewlyFlags(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DropFriendNewlyFlags)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DropFriendNewlyFlags)

    // nn::Result DeleteFriend(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteFriend)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteFriend)

    // nn::Result DropFriendNewlyFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DropFriendNewlyFlag)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30110)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DropFriendNewlyFlag)

    // nn::Result ChangeFriendFavoriteFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ChangeFriendFavoriteFlag)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30120)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(newValue, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (newValue, uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(newValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ChangeFriendFavoriteFlag)

    // nn::Result ChangeFriendOnlineNotificationFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ChangeFriendOnlineNotificationFlag)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30121)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(newValue, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (newValue, uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(newValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ChangeFriendOnlineNotificationFlag)

    // nn::Result SendFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendFriendRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requestType, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (requestType, uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendFriendRequest)

    // nn::Result SendFriendRequestWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendFriendRequestWithApplicationInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(inAppScreenName, 0, (const ::nn::friends::InAppScreenName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(myInAppScreenName, 1, (const ::nn::friends::InAppScreenName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (inAppScreenName, myInAppScreenName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requestType, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appInfo, (::nn::friends::ApplicationInfo), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (requestType, uid, accountId, appInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAppScreenName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(myInAppScreenName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendFriendRequestWithApplicationInfo)

    // nn::Result CancelFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelFriendRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requestId, (::nn::friends::RequestId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, requestId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelFriendRequest)

    // nn::Result AcceptFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcceptFriendRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30203)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requestId, (::nn::friends::RequestId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, requestId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcceptFriendRequest)

    // nn::Result RejectFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RejectFriendRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30204)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requestId, (::nn::friends::RequestId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, requestId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RejectFriendRequest)

    // nn::Result ReadFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadFriendRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30205)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requestId, (::nn::friends::RequestId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, requestId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadFriendRequest)

    // nn::Result GetFacedFriendRequestRegistrationKey(nn::sf::Out<nn::friends::FacedFriendRequestRegistrationKey> outKey, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFacedFriendRequestRegistrationKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30210)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outKey, (::nn::friends::FacedFriendRequestRegistrationKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outKey))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFacedFriendRequestRegistrationKey)

    // nn::Result AddFacedFriendRequest(const nn::account::Uid& uid, const nn::friends::FacedFriendRequestRegistrationKey& key, const nn::account::Nickname& nickname, const nn::sf::InBuffer& image) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddFacedFriendRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30211)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(image, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (image))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::friends::FacedFriendRequestRegistrationKey), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(nickname, (::nn::account::Nickname), 64)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 104)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (key, nickname, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(120)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nickname), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(image)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddFacedFriendRequest)

    // nn::Result CancelFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelFacedFriendRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30212)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelFacedFriendRequest)

    // nn::Result GetFacedFriendRequestProfileImage(nn::sf::Out<std::int32_t> outSize, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFacedFriendRequestProfileImage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30213)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFacedFriendRequestProfileImage)

    // nn::Result GetFacedFriendRequestProfileImageFromPath(nn::sf::Out<std::int32_t> outSize, const nn::sf::InArray<char>& path, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFacedFriendRequestProfileImageFromPath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30214)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(path, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (path, buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFacedFriendRequestProfileImageFromPath)

    // nn::Result SendFriendRequestWithExternalApplicationCatalogId(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::ExternalApplicationCatalogId& catalogId, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendFriendRequestWithExternalApplicationCatalogId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30215)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(inAppScreenName, 0, (const ::nn::friends::InAppScreenName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(myInAppScreenName, 1, (const ::nn::friends::InAppScreenName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (inAppScreenName, myInAppScreenName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requestType, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(catalogId, (::nn::friends::ExternalApplicationCatalogId), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (requestType, uid, accountId, catalogId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(catalogId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAppScreenName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(myInAppScreenName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendFriendRequestWithExternalApplicationCatalogId)

    // nn::Result ResendFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResendFacedFriendRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30216)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResendFacedFriendRequest)

    // nn::Result SendFriendRequestWithNintendoNetworkIdInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::MiiName& miiName, const nn::friends::MiiImageUrlParam& miiImageUrlParam, const nn::friends::MiiName& myMiiName, const nn::friends::MiiImageUrlParam& myMiiImageUrlParam) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SendFriendRequestWithNintendoNetworkIdInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30217)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(miiName, (::nn::friends::MiiName), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(miiImageUrlParam, (::nn::friends::MiiImageUrlParam), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(myMiiName, (::nn::friends::MiiName), 48)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(myMiiImageUrlParam, (::nn::friends::MiiImageUrlParam), 80)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(requestType, (::std::int32_t), 96)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 104)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 120)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(7, (miiName, miiImageUrlParam, myMiiName, myMiiImageUrlParam, requestType, uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(128)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requestType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(miiName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(miiImageUrlParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(myMiiName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(myMiiImageUrlParam)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SendFriendRequestWithNintendoNetworkIdInfo)

    // nn::Result GetSnsAccountLinkPageUrl(nn::sf::Out<nn::friends::WebPageUrl> outUrl, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSnsAccountLinkPageUrl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outUrl, 0, (::nn::sf::Out<::nn::friends::WebPageUrl>), 4096, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outUrl))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUrl), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSnsAccountLinkPageUrl)

    // nn::Result UnlinkSnsAccount(const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnlinkSnsAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnlinkSnsAccount)

    // nn::Result BlockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BlockUser)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(blockReason, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (blockReason, uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(blockReason)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BlockUser)

    // nn::Result BlockUserWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason, const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BlockUserWithApplicationInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(inAppScreenName, 0, (const ::nn::friends::InAppScreenName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (inAppScreenName))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(blockReason, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appInfo, (::nn::friends::ApplicationInfo), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (blockReason, uid, accountId, appInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(blockReason), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAppScreenName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BlockUserWithApplicationInfo)

    // nn::Result UnblockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnblockUser)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30402)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::account::NetworkServiceAccountId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnblockUser)

    // nn::Result GetProfileExtraFromFriendCode(nn::sf::Out<nn::friends::detail::ProfileExtraImpl> outProfile, const nn::account::Uid& uid, const nn::friends::FriendCode& friendCode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProfileExtraFromFriendCode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30500)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outProfile, 0, (::nn::sf::Out<::nn::friends::detail::ProfileExtraImpl>), 1024, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outProfile))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(friendCode, (::nn::friends::FriendCode), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (friendCode, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(48)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outProfile), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(friendCode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProfileExtraFromFriendCode)

    // nn::Result DeletePlayHistory(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeletePlayHistory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30700)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeletePlayHistory)

    // nn::Result ChangePresencePermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ChangePresencePermission)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30810)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(newValue, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (newValue, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(newValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ChangePresencePermission)

    // nn::Result ChangeFriendRequestReception(const nn::account::Uid& uid, bool newValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ChangeFriendRequestReception)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30811)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(newValue, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (newValue, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(newValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ChangeFriendRequestReception)

    // nn::Result ChangePlayLogPermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ChangePlayLogPermission)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30812)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(newValue, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (newValue, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(newValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ChangePlayLogPermission)

    // nn::Result IssueFriendCode(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IssueFriendCode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30820)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IssueFriendCode)

    // nn::Result ClearPlayLog(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearPlayLog)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30830)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearPlayLog)

    // nn::Result DeleteNetworkServiceAccountCache(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteNetworkServiceAccountCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(49900)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteNetworkServiceAccountCache)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::NetworkServiceAccountId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::ipc::SizedFriendFilter), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::FriendImpl), 512, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::InAppScreenName), 72, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::FacedFriendRequestRegistrationKey), 64, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Nickname), 33, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::ProfileImpl), 256, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::UserPresenceImpl), 224, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::PlayHistoryRegistrationKey), 64, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::Url), 160, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::FriendDetailedInfoImpl), 2048, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::FriendSettingImpl), 64, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::FriendRequestImpl), 512, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::FriendCandidateImpl), 256, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::NintendoNetworkIdUserInfo), 56, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::NintendoNetworkIdFriendImpl), 256, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::SnsAccountLinkage), 8, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::SnsAccountProfile), 896, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::SnsAccountFriendImpl), 1024, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::BlockedUserImpl), 512, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::ProfileExtraImpl), 1024, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::Relationship), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::UserPresenceViewImpl), 224, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::PlayHistoryImpl), 256, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::PlayHistoryStatistics), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::detail::UserSettingImpl), 2048, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::ExternalApplicationCatalog), 1208, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::ExternalApplicationCatalogId), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::settings::LanguageCode), 8, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::ApplicationInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::RequestId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::MiiName), 32, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::MiiImageUrlParam), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::WebPageUrl), 4096, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::friends::FriendCode), 32, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::friends::detail::ipc::IFriendService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::friends::detail::ipc::IFriendService))

    // nn::Result GetCompletionEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCompletionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCompletionEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCompletionEvent)
    }

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Cancel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Cancel)
    }

    // nn::Result GetFriendListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds, const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendListIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::account::NetworkServiceAccountId>& outAccountIds, const ::nn::account::Uid& uid, ::std::int32_t offset, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFriendListIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAccountIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFriendListIds)
    }

    // nn::Result GetFriendList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t offset, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t offset, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFriendList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFriends)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFriendList)
    }

    // nn::Result UpdateFriendInfo(const nn::sf::OutArray<nn::friends::detail::FriendImpl>& outFriends, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateFriendInfo, (const ::nn::sf::OutArray<::nn::friends::detail::FriendImpl>& outFriends, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateFriendInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFriends)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateFriendInfo)
    }

    // nn::Result GetFriendProfileImage(nn::sf::Out<std::int32_t> outSize, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendProfileImage, (::nn::sf::Out<::std::int32_t> outSize, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFriendProfileImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFriendProfileImage)
    }

    // nn::Result SendFriendRequestForApplication(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestForApplication, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendFriendRequestForApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAppScreenName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(myInAppScreenName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendFriendRequestForApplication)
    }

    // nn::Result AddFacedFriendRequestForApplication(const nn::account::Uid& uid, const nn::friends::FacedFriendRequestRegistrationKey& key, const nn::account::Nickname& nickname, const nn::sf::InBuffer& image, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddFacedFriendRequestForApplication, (const ::nn::account::Uid& uid, const ::nn::friends::FacedFriendRequestRegistrationKey& key, const ::nn::account::Nickname& nickname, const ::nn::sf::InBuffer& image, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddFacedFriendRequestForApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nickname)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(image)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAppScreenName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(myInAppScreenName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddFacedFriendRequestForApplication)
    }

    // nn::Result GetBlockedUserListIds(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::account::NetworkServiceAccountId>& outAccountIds, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBlockedUserListIds, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::account::NetworkServiceAccountId>& outAccountIds, const ::nn::account::Uid& uid, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBlockedUserListIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAccountIds)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBlockedUserListIds)
    }

    // nn::Result GetProfileList(const nn::sf::OutArray<nn::friends::detail::ProfileImpl>& outProfiles, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileList, (const ::nn::sf::OutArray<::nn::friends::detail::ProfileImpl>& outProfiles, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProfileList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outProfiles)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProfileList)
    }

    // nn::Result DeclareOpenOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeclareOpenOnlinePlaySession, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeclareOpenOnlinePlaySession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeclareOpenOnlinePlaySession)
    }

    // nn::Result DeclareCloseOnlinePlaySession(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeclareCloseOnlinePlaySession, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeclareCloseOnlinePlaySession)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeclareCloseOnlinePlaySession)
    }

    // nn::Result UpdateUserPresence(const nn::account::Uid& uid, const nn::friends::detail::UserPresenceImpl& presence, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateUserPresence, (const ::nn::account::Uid& uid, const ::nn::friends::detail::UserPresenceImpl& presence, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateUserPresence)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(presence)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateUserPresence)
    }

    // nn::Result GetPlayHistoryRegistrationKey(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, const nn::account::Uid& uid, bool isLocalPlay) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryRegistrationKey, (::nn::sf::Out<::nn::friends::PlayHistoryRegistrationKey> outKey, const ::nn::account::Uid& uid, bool isLocalPlay))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPlayHistoryRegistrationKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isLocalPlay)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPlayHistoryRegistrationKey)
    }

    // nn::Result GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId(nn::sf::Out<nn::friends::PlayHistoryRegistrationKey> outKey, nn::account::NetworkServiceAccountId accountId, bool isLocalPlay) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId, (::nn::sf::Out<::nn::friends::PlayHistoryRegistrationKey> outKey, ::nn::account::NetworkServiceAccountId accountId, bool isLocalPlay))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isLocalPlay)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId)
    }

    // nn::Result AddPlayHistory(const nn::account::Uid& uid, const nn::friends::PlayHistoryRegistrationKey& key, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddPlayHistory, (const ::nn::account::Uid& uid, const ::nn::friends::PlayHistoryRegistrationKey& key, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddPlayHistory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAppScreenName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(myInAppScreenName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddPlayHistory)
    }

    // nn::Result GetProfileImageUrl(nn::sf::Out<nn::friends::Url> outUrl, const nn::friends::Url& url, std::int32_t imageSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileImageUrl, (::nn::sf::Out<::nn::friends::Url> outUrl, const ::nn::friends::Url& url, ::std::int32_t imageSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProfileImageUrl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUrl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(url)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(imageSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProfileImageUrl)
    }

    // nn::Result GetFriendCount(nn::sf::Out<std::int32_t> outCount, const nn::account::Uid& uid, const nn::friends::detail::ipc::SizedFriendFilter& filter, nn::Bit64 processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendCount, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::account::Uid& uid, const ::nn::friends::detail::ipc::SizedFriendFilter& filter, ::nn::Bit64 processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFriendCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFriendCount)
    }

    // nn::Result GetNewlyFriendCount(nn::sf::Out<std::int32_t> outCount, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNewlyFriendCount, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNewlyFriendCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNewlyFriendCount)
    }

    // nn::Result GetFriendDetailedInfo(nn::sf::Out<nn::friends::detail::FriendDetailedInfoImpl> outInfo, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendDetailedInfo, (::nn::sf::Out<::nn::friends::detail::FriendDetailedInfoImpl> outInfo, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFriendDetailedInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFriendDetailedInfo)
    }

    // nn::Result SyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SyncFriendList, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SyncFriendList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SyncFriendList)
    }

    // nn::Result RequestSyncFriendList(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncFriendList, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSyncFriendList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSyncFriendList)
    }

    // nn::Result LoadFriendSetting(nn::sf::Out<nn::friends::detail::FriendSettingImpl> outSetting, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadFriendSetting, (::nn::sf::Out<::nn::friends::detail::FriendSettingImpl> outSetting, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadFriendSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadFriendSetting)
    }

    // nn::Result GetReceivedFriendRequestCount(nn::sf::Out<std::int32_t> outUnreadCount, nn::sf::Out<std::int32_t> outReadCount, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedFriendRequestCount, (::nn::sf::Out<::std::int32_t> outUnreadCount, ::nn::sf::Out<::std::int32_t> outReadCount, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReceivedFriendRequestCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUnreadCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outReadCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReceivedFriendRequestCount)
    }

    // nn::Result GetFriendRequestList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendRequestImpl>& outRequests, const nn::account::Uid& uid, std::int32_t offset, std::int32_t listType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendRequestList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendRequestImpl>& outRequests, const ::nn::account::Uid& uid, ::std::int32_t offset, ::std::int32_t listType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFriendRequestList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRequests)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(listType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFriendRequestList)
    }

    // nn::Result GetFriendCandidateList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::FriendCandidateImpl>& outCandidates, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFriendCandidateList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::FriendCandidateImpl>& outCandidates, const ::nn::account::Uid& uid, ::std::int32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFriendCandidateList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCandidates)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFriendCandidateList)
    }

    // nn::Result GetNintendoNetworkIdInfo(nn::sf::Out<nn::friends::NintendoNetworkIdUserInfo> outUserInfo, nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::NintendoNetworkIdFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNintendoNetworkIdInfo, (::nn::sf::Out<::nn::friends::NintendoNetworkIdUserInfo> outUserInfo, ::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::NintendoNetworkIdFriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNintendoNetworkIdInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUserInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFriends)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNintendoNetworkIdInfo)
    }

    // nn::Result GetSnsAccountLinkage(nn::sf::Out<nn::friends::SnsAccountLinkage> outLinkage, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountLinkage, (::nn::sf::Out<::nn::friends::SnsAccountLinkage> outLinkage, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSnsAccountLinkage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLinkage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSnsAccountLinkage)
    }

    // nn::Result GetSnsAccountProfile(nn::sf::Out<nn::friends::SnsAccountProfile> outProfile, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountProfile, (::nn::sf::Out<::nn::friends::SnsAccountProfile> outProfile, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSnsAccountProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSnsAccountProfile)
    }

    // nn::Result GetSnsAccountFriendList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::SnsAccountFriendImpl>& outFriends, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountFriendList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::SnsAccountFriendImpl>& outFriends, const ::nn::account::Uid& uid, ::std::int32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSnsAccountFriendList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFriends)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSnsAccountFriendList)
    }

    // nn::Result GetBlockedUserList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::BlockedUserImpl>& outUsers, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBlockedUserList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::BlockedUserImpl>& outUsers, const ::nn::account::Uid& uid, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBlockedUserList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUsers)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBlockedUserList)
    }

    // nn::Result SyncBlockedUserList(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SyncBlockedUserList, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SyncBlockedUserList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SyncBlockedUserList)
    }

    // nn::Result GetProfileExtraList(const nn::sf::OutArray<nn::friends::detail::ProfileExtraImpl>& outProfiles, const nn::account::Uid& uid, const nn::sf::InArray<nn::account::NetworkServiceAccountId>& accountIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileExtraList, (const ::nn::sf::OutArray<::nn::friends::detail::ProfileExtraImpl>& outProfiles, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::account::NetworkServiceAccountId>& accountIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProfileExtraList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outProfiles)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProfileExtraList)
    }

    // nn::Result GetRelationship(nn::sf::Out<nn::friends::Relationship> outRelationship, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRelationship, (::nn::sf::Out<::nn::friends::Relationship> outRelationship, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRelationship)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRelationship)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRelationship)
    }

    // nn::Result GetUserPresenceView(nn::sf::Out<nn::friends::detail::UserPresenceViewImpl> outPresence, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetUserPresenceView, (::nn::sf::Out<::nn::friends::detail::UserPresenceViewImpl> outPresence, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetUserPresenceView)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPresence)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetUserPresenceView)
    }

    // nn::Result GetPlayHistoryList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::friends::detail::PlayHistoryImpl>& outHistories, const nn::account::Uid& uid, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::friends::detail::PlayHistoryImpl>& outHistories, const ::nn::account::Uid& uid, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPlayHistoryList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHistories)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPlayHistoryList)
    }

    // nn::Result GetPlayHistoryStatistics(nn::sf::Out<nn::friends::PlayHistoryStatistics> outStatistics, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPlayHistoryStatistics, (::nn::sf::Out<::nn::friends::PlayHistoryStatistics> outStatistics, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPlayHistoryStatistics)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStatistics)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPlayHistoryStatistics)
    }

    // nn::Result LoadUserSetting(nn::sf::Out<nn::friends::detail::UserSettingImpl> outSetting, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadUserSetting, (::nn::sf::Out<::nn::friends::detail::UserSettingImpl> outSetting, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadUserSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadUserSetting)
    }

    // nn::Result SyncUserSetting(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SyncUserSetting, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SyncUserSetting)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SyncUserSetting)
    }

    // nn::Result RequestListSummaryOverlayNotification() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestListSummaryOverlayNotification)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestListSummaryOverlayNotification)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestListSummaryOverlayNotification)
    }

    // nn::Result GetExternalApplicationCatalog(nn::sf::Out<nn::friends::ExternalApplicationCatalog> outCatalog, const nn::friends::ExternalApplicationCatalogId& catalogId, nn::settings::LanguageCode language) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetExternalApplicationCatalog, (::nn::sf::Out<::nn::friends::ExternalApplicationCatalog> outCatalog, const ::nn::friends::ExternalApplicationCatalogId& catalogId, ::nn::settings::LanguageCode language))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetExternalApplicationCatalog)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCatalog)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(catalogId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(language)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetExternalApplicationCatalog)
    }

    // nn::Result DropFriendNewlyFlags(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DropFriendNewlyFlags, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DropFriendNewlyFlags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DropFriendNewlyFlags)
    }

    // nn::Result DeleteFriend(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteFriend, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteFriend)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteFriend)
    }

    // nn::Result DropFriendNewlyFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DropFriendNewlyFlag, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DropFriendNewlyFlag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DropFriendNewlyFlag)
    }

    // nn::Result ChangeFriendFavoriteFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangeFriendFavoriteFlag, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, bool newValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ChangeFriendFavoriteFlag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(newValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ChangeFriendFavoriteFlag)
    }

    // nn::Result ChangeFriendOnlineNotificationFlag(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangeFriendOnlineNotificationFlag, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, bool newValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ChangeFriendOnlineNotificationFlag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(newValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ChangeFriendOnlineNotificationFlag)
    }

    // nn::Result SendFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequest, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendFriendRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendFriendRequest)
    }

    // nn::Result SendFriendRequestWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestWithApplicationInfo, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::ApplicationInfo& appInfo, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendFriendRequestWithApplicationInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAppScreenName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(myInAppScreenName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendFriendRequestWithApplicationInfo)
    }

    // nn::Result CancelFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelFriendRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelFriendRequest)
    }

    // nn::Result AcceptFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcceptFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcceptFriendRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcceptFriendRequest)
    }

    // nn::Result RejectFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RejectFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RejectFriendRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RejectFriendRequest)
    }

    // nn::Result ReadFriendRequest(const nn::account::Uid& uid, nn::friends::RequestId requestId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadFriendRequest, (const ::nn::account::Uid& uid, ::nn::friends::RequestId requestId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadFriendRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadFriendRequest)
    }

    // nn::Result GetFacedFriendRequestRegistrationKey(nn::sf::Out<nn::friends::FacedFriendRequestRegistrationKey> outKey, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFacedFriendRequestRegistrationKey, (::nn::sf::Out<::nn::friends::FacedFriendRequestRegistrationKey> outKey, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFacedFriendRequestRegistrationKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFacedFriendRequestRegistrationKey)
    }

    // nn::Result AddFacedFriendRequest(const nn::account::Uid& uid, const nn::friends::FacedFriendRequestRegistrationKey& key, const nn::account::Nickname& nickname, const nn::sf::InBuffer& image) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddFacedFriendRequest, (const ::nn::account::Uid& uid, const ::nn::friends::FacedFriendRequestRegistrationKey& key, const ::nn::account::Nickname& nickname, const ::nn::sf::InBuffer& image))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddFacedFriendRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nickname)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(image)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddFacedFriendRequest)
    }

    // nn::Result CancelFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelFacedFriendRequest, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelFacedFriendRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelFacedFriendRequest)
    }

    // nn::Result GetFacedFriendRequestProfileImage(nn::sf::Out<std::int32_t> outSize, const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFacedFriendRequestProfileImage, (::nn::sf::Out<::std::int32_t> outSize, const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFacedFriendRequestProfileImage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFacedFriendRequestProfileImage)
    }

    // nn::Result GetFacedFriendRequestProfileImageFromPath(nn::sf::Out<std::int32_t> outSize, const nn::sf::InArray<char>& path, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFacedFriendRequestProfileImageFromPath, (::nn::sf::Out<::std::int32_t> outSize, const ::nn::sf::InArray<char>& path, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFacedFriendRequestProfileImageFromPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFacedFriendRequestProfileImageFromPath)
    }

    // nn::Result SendFriendRequestWithExternalApplicationCatalogId(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::ExternalApplicationCatalogId& catalogId, const nn::friends::InAppScreenName& inAppScreenName, const nn::friends::InAppScreenName& myInAppScreenName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestWithExternalApplicationCatalogId, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::ExternalApplicationCatalogId& catalogId, const ::nn::friends::InAppScreenName& inAppScreenName, const ::nn::friends::InAppScreenName& myInAppScreenName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendFriendRequestWithExternalApplicationCatalogId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(catalogId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAppScreenName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(myInAppScreenName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendFriendRequestWithExternalApplicationCatalogId)
    }

    // nn::Result ResendFacedFriendRequest(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResendFacedFriendRequest, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResendFacedFriendRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResendFacedFriendRequest)
    }

    // nn::Result SendFriendRequestWithNintendoNetworkIdInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t requestType, const nn::friends::MiiName& miiName, const nn::friends::MiiImageUrlParam& miiImageUrlParam, const nn::friends::MiiName& myMiiName, const nn::friends::MiiImageUrlParam& myMiiImageUrlParam) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SendFriendRequestWithNintendoNetworkIdInfo, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t requestType, const ::nn::friends::MiiName& miiName, const ::nn::friends::MiiImageUrlParam& miiImageUrlParam, const ::nn::friends::MiiName& myMiiName, const ::nn::friends::MiiImageUrlParam& myMiiImageUrlParam))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SendFriendRequestWithNintendoNetworkIdInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requestType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(miiName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(miiImageUrlParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(myMiiName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(myMiiImageUrlParam)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SendFriendRequestWithNintendoNetworkIdInfo)
    }

    // nn::Result GetSnsAccountLinkPageUrl(nn::sf::Out<nn::friends::WebPageUrl> outUrl, const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSnsAccountLinkPageUrl, (::nn::sf::Out<::nn::friends::WebPageUrl> outUrl, const ::nn::account::Uid& uid, ::std::int32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSnsAccountLinkPageUrl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUrl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSnsAccountLinkPageUrl)
    }

    // nn::Result UnlinkSnsAccount(const nn::account::Uid& uid, std::int32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnlinkSnsAccount, (const ::nn::account::Uid& uid, ::std::int32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnlinkSnsAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnlinkSnsAccount)
    }

    // nn::Result BlockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BlockUser, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t blockReason))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BlockUser)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(blockReason)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BlockUser)
    }

    // nn::Result BlockUserWithApplicationInfo(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId, std::int32_t blockReason, const nn::friends::ApplicationInfo& appInfo, const nn::friends::InAppScreenName& inAppScreenName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BlockUserWithApplicationInfo, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId, ::std::int32_t blockReason, const ::nn::friends::ApplicationInfo& appInfo, const ::nn::friends::InAppScreenName& inAppScreenName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BlockUserWithApplicationInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(blockReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAppScreenName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BlockUserWithApplicationInfo)
    }

    // nn::Result UnblockUser(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnblockUser, (const ::nn::account::Uid& uid, ::nn::account::NetworkServiceAccountId accountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnblockUser)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnblockUser)
    }

    // nn::Result GetProfileExtraFromFriendCode(nn::sf::Out<nn::friends::detail::ProfileExtraImpl> outProfile, const nn::account::Uid& uid, const nn::friends::FriendCode& friendCode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProfileExtraFromFriendCode, (::nn::sf::Out<::nn::friends::detail::ProfileExtraImpl> outProfile, const ::nn::account::Uid& uid, const ::nn::friends::FriendCode& friendCode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProfileExtraFromFriendCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(friendCode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProfileExtraFromFriendCode)
    }

    // nn::Result DeletePlayHistory(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeletePlayHistory, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeletePlayHistory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeletePlayHistory)
    }

    // nn::Result ChangePresencePermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangePresencePermission, (const ::nn::account::Uid& uid, ::std::int32_t newValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ChangePresencePermission)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(newValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ChangePresencePermission)
    }

    // nn::Result ChangeFriendRequestReception(const nn::account::Uid& uid, bool newValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangeFriendRequestReception, (const ::nn::account::Uid& uid, bool newValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ChangeFriendRequestReception)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(newValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ChangeFriendRequestReception)
    }

    // nn::Result ChangePlayLogPermission(const nn::account::Uid& uid, std::int32_t newValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangePlayLogPermission, (const ::nn::account::Uid& uid, ::std::int32_t newValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ChangePlayLogPermission)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(newValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ChangePlayLogPermission)
    }

    // nn::Result IssueFriendCode(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IssueFriendCode, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IssueFriendCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IssueFriendCode)
    }

    // nn::Result ClearPlayLog(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearPlayLog, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearPlayLog)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearPlayLog)
    }

    // nn::Result DeleteNetworkServiceAccountCache(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteNetworkServiceAccountCache, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteNetworkServiceAccountCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteNetworkServiceAccountCache)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::friends::detail::ipc::IFriendService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::friends::detail::ipc::IFriendService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCompletionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCompletionEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFriendListIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAccountIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFriendListIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAccountIds),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFriendList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outFriends)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFriendList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outFriends),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateFriendInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outFriends)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(accountIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateFriendInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outFriends),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(accountIds),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFriendProfileImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFriendProfileImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendFriendRequestForApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inAppScreenName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(myInAppScreenName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendFriendRequestForApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inAppScreenName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(myInAppScreenName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddFacedFriendRequestForApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inAppScreenName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(myInAppScreenName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(image)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddFacedFriendRequestForApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(nickname),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(image),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inAppScreenName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(myInAppScreenName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBlockedUserListIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outAccountIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBlockedUserListIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outAccountIds),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProfileList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outProfiles)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(accountIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProfileList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outProfiles),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(accountIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeclareOpenOnlinePlaySession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeclareOpenOnlinePlaySession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeclareCloseOnlinePlaySession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeclareCloseOnlinePlaySession)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateUserPresence)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(presence)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateUserPresence)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(presence),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPlayHistoryRegistrationKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPlayHistoryRegistrationKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isLocalPlay)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isLocalPlay)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddPlayHistory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(key)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inAppScreenName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(myInAppScreenName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddPlayHistory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inAppScreenName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(myInAppScreenName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProfileImageUrl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProfileImageUrl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outUrl),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(url),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(imageSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFriendCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFriendCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filter),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNewlyFriendCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNewlyFriendCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFriendDetailedInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFriendDetailedInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SyncFriendList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SyncFriendList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSyncFriendList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSyncFriendList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadFriendSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadFriendSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSetting),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReceivedFriendRequestCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReceivedFriendRequestCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outUnreadCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outReadCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFriendRequestList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outRequests)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFriendRequestList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outRequests),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(listType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFriendCandidateList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outCandidates)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFriendCandidateList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outCandidates),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNintendoNetworkIdInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outUserInfo)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outFriends)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNintendoNetworkIdInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUserInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outFriends),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSnsAccountLinkage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSnsAccountLinkage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLinkage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSnsAccountProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outProfile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSnsAccountProfile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outProfile),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSnsAccountFriendList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outFriends)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSnsAccountFriendList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outFriends),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBlockedUserList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outUsers)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBlockedUserList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUsers),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SyncBlockedUserList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SyncBlockedUserList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProfileExtraList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outProfiles)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(accountIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProfileExtraList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outProfiles),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(accountIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRelationship)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRelationship)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRelationship),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetUserPresenceView)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outPresence)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetUserPresenceView)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outPresence),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPlayHistoryList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outHistories)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPlayHistoryList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outHistories),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPlayHistoryStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPlayHistoryStatistics)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStatistics),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadUserSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadUserSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outSetting),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SyncUserSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SyncUserSetting)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestListSummaryOverlayNotification)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestListSummaryOverlayNotification)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetExternalApplicationCatalog)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outCatalog)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetExternalApplicationCatalog)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outCatalog),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(catalogId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(language)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DropFriendNewlyFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DropFriendNewlyFlags)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteFriend)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteFriend)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DropFriendNewlyFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DropFriendNewlyFlag)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ChangeFriendFavoriteFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ChangeFriendFavoriteFlag)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(newValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ChangeFriendOnlineNotificationFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ChangeFriendOnlineNotificationFlag)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(newValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendFriendRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requestType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendFriendRequestWithApplicationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inAppScreenName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(myInAppScreenName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendFriendRequestWithApplicationInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requestType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inAppScreenName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(myInAppScreenName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelFriendRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requestId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcceptFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcceptFriendRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requestId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RejectFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RejectFriendRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requestId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadFriendRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requestId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFacedFriendRequestRegistrationKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFacedFriendRequestRegistrationKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddFacedFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(image)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddFacedFriendRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(nickname),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(image)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelFacedFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelFacedFriendRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFacedFriendRequestProfileImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFacedFriendRequestProfileImage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFacedFriendRequestProfileImageFromPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFacedFriendRequestProfileImageFromPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendFriendRequestWithExternalApplicationCatalogId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inAppScreenName)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(myInAppScreenName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendFriendRequestWithExternalApplicationCatalogId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requestType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(catalogId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inAppScreenName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(myInAppScreenName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResendFacedFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResendFacedFriendRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SendFriendRequestWithNintendoNetworkIdInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SendFriendRequestWithNintendoNetworkIdInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(requestType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(miiName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(miiImageUrlParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(myMiiName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(myMiiImageUrlParam)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSnsAccountLinkPageUrl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outUrl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSnsAccountLinkPageUrl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outUrl),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnlinkSnsAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnlinkSnsAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BlockUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BlockUser)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(blockReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BlockUserWithApplicationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inAppScreenName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BlockUserWithApplicationInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(blockReason),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inAppScreenName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnblockUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnblockUser)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProfileExtraFromFriendCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outProfile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProfileExtraFromFriendCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outProfile),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(friendCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeletePlayHistory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeletePlayHistory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ChangePresencePermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ChangePresencePermission)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(newValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ChangeFriendRequestReception)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ChangeFriendRequestReception)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(newValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ChangePlayLogPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ChangePlayLogPermission)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(newValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IssueFriendCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IssueFriendCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearPlayLog)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearPlayLog)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteNetworkServiceAccountCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteNetworkServiceAccountCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCompletionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFriendListIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFriendList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateFriendInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFriendProfileImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendFriendRequestForApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddFacedFriendRequestForApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBlockedUserListIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProfileList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeclareOpenOnlinePlaySession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeclareCloseOnlinePlaySession)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateUserPresence)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPlayHistoryRegistrationKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPlayHistoryRegistrationKeyWithNetworkServiceAccountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddPlayHistory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProfileImageUrl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFriendCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNewlyFriendCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFriendDetailedInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SyncFriendList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSyncFriendList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadFriendSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReceivedFriendRequestCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFriendRequestList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFriendCandidateList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNintendoNetworkIdInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSnsAccountLinkage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSnsAccountProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSnsAccountFriendList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBlockedUserList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SyncBlockedUserList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProfileExtraList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRelationship)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetUserPresenceView)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPlayHistoryList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPlayHistoryStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadUserSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SyncUserSetting)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestListSummaryOverlayNotification)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetExternalApplicationCatalog)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DropFriendNewlyFlags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteFriend)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DropFriendNewlyFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ChangeFriendFavoriteFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ChangeFriendOnlineNotificationFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendFriendRequestWithApplicationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcceptFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RejectFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFacedFriendRequestRegistrationKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddFacedFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelFacedFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFacedFriendRequestProfileImage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFacedFriendRequestProfileImageFromPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendFriendRequestWithExternalApplicationCatalogId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResendFacedFriendRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SendFriendRequestWithNintendoNetworkIdInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSnsAccountLinkPageUrl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnlinkSnsAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BlockUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BlockUserWithApplicationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnblockUser)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProfileExtraFromFriendCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeletePlayHistory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ChangePresencePermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ChangeFriendRequestReception)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ChangePlayLogPermission)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IssueFriendCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearPlayLog)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteNetworkServiceAccountCache)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::friends::detail::ipc::IFriendService))
