﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      friends モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_FRIENDS_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(friends, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(friends, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(friends, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(friends, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_FRIENDS_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(friends, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(friends, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(friends, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(friends, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_FRIENDS_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(friends, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(friends, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(friends, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(friends, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_FRIENDS_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(friends, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(friends, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(friends, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(friends, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_FRIENDS_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(friends, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(friends, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(friends, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_FRIENDS_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(friends, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_FRIENDS_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Trace, 0, format, args)
#define NN_DETAIL_FRIENDS_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Trace, 1, format, args)
#define NN_DETAIL_FRIENDS_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Trace, 2, format, args)
#define NN_DETAIL_FRIENDS_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Trace, 3, format, args)

#define NN_DETAIL_FRIENDS_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Info, 0, format, args)
#define NN_DETAIL_FRIENDS_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Info, 1, format, args)
#define NN_DETAIL_FRIENDS_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Info, 2, format, args)
#define NN_DETAIL_FRIENDS_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Info, 3, format, args)

#define NN_DETAIL_FRIENDS_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Warn, 0, format, args)
#define NN_DETAIL_FRIENDS_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Warn, 1, format, args)
#define NN_DETAIL_FRIENDS_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Warn, 2, format, args)
#define NN_DETAIL_FRIENDS_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Warn, 3, format, args)

#define NN_DETAIL_FRIENDS_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Error, 0, format, args)
#define NN_DETAIL_FRIENDS_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Error, 1, format, args)
#define NN_DETAIL_FRIENDS_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Error, 2, format, args)
#define NN_DETAIL_FRIENDS_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Error, 3, format, args)

#define NN_DETAIL_FRIENDS_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Fatal, 0, format, args)
#define NN_DETAIL_FRIENDS_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Fatal, 1, format, args)
#define NN_DETAIL_FRIENDS_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Fatal, 2, format, args)
#define NN_DETAIL_FRIENDS_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(friends, Fatal, 3, format, args)

#define NN_DETAIL_FRIENDS_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(friends, Trace, 0, text, length)
#define NN_DETAIL_FRIENDS_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(friends, Trace, 1, text, length)
#define NN_DETAIL_FRIENDS_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(friends, Trace, 2, text, length)
#define NN_DETAIL_FRIENDS_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(friends, Trace, 3, text, length)

#define NN_DETAIL_FRIENDS_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(friends, Info, 0, text, length)
#define NN_DETAIL_FRIENDS_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(friends, Info, 1, text, length)
#define NN_DETAIL_FRIENDS_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(friends, Info, 2, text, length)
#define NN_DETAIL_FRIENDS_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(friends, Info, 3, text, length)

#define NN_DETAIL_FRIENDS_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(friends, Warn, 0, text, length)
#define NN_DETAIL_FRIENDS_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(friends, Warn, 1, text, length)
#define NN_DETAIL_FRIENDS_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(friends, Warn, 2, text, length)
#define NN_DETAIL_FRIENDS_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(friends, Warn, 3, text, length)

#define NN_DETAIL_FRIENDS_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(friends, Error, 0, text, length)
#define NN_DETAIL_FRIENDS_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(friends, Error, 1, text, length)
#define NN_DETAIL_FRIENDS_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(friends, Error, 2, text, length)
#define NN_DETAIL_FRIENDS_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(friends, Error, 3, text, length)

#define NN_DETAIL_FRIENDS_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(friends, Fatal, 0, text, length)
#define NN_DETAIL_FRIENDS_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(friends, Fatal, 1, text, length)
#define NN_DETAIL_FRIENDS_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(friends, Fatal, 2, text, length)
#define NN_DETAIL_FRIENDS_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(friends, Fatal, 3, text, length)
