﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/friends/friends_AsyncContext.h>
#include <nn/friends/detail/friends_AsyncContextInternal.h>

namespace nn { namespace friends { namespace detail {

/*!
    @brief      非同期処理で使用するアロケータを設定します。

    @param[in]  allocateFunction    メモリ確保関数。
    @param[in]  deallocateFunction  メモリ解放関数。
*/
void SetAsyncAllocator(nn::AllocateFunction allocateFunction, nn::DeallocateFunction freeFunction) NN_NOEXCEPT;

/*!
    @brief      非同期呼び出しを行います。

    @param[out] outAsync    非同期コンテキスト。
    @param[in]  threadName  スレッド名。
    @param[in]  function    関数。
    @param[in]  param       関数に渡すパラメータ。
    @param[in]  paramSize   関数に渡すパラメータのサイズ。
*/
nn::Result CallAsync(AsyncContext* outAsync,
    const char* threadName, AsyncContextInternal::SyncCall function, void* param, size_t paramSize) NN_NOEXCEPT;

/*!
    @brief      非同期呼び出しを行います。

    @param[out] outAsync    非同期コンテキスト。
    @param[in]  threadName  スレッド名。
    @param[in]  function    関数。
    @param[in]  callback    ディープコピーコールバック。
    @param[in]  sourceParam ディープコピーコールバックに渡すソースパラメータ。
*/
nn::Result CallAsync(AsyncContext* outAsync,
    const char* threadName, AsyncContextInternal::SyncCall function, AsyncContextInternal::DeepCopyCallback callback, const void* sourceParam) NN_NOEXCEPT;

}}}
