﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/os/os_UserExceptionHandlerTypes.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace fatal {
    void ThrowFatal(const Result& lastResult) NN_NOEXCEPT;
    void ThrowFatal(const Result& lastResult, const nn::os::UserExceptionInfo* exceptionInfo) NN_NOEXCEPT;
    const char* GetExceptionName(nn::Bit32 exceptionType) NN_NOEXCEPT;


    /**
    *   @brief      Fatal エラー画面に遷移した時にシグナルするイベントを返します。
    *
    *   @details    取得できるイベントの数には上限があるため、
    *               下記のプロセス以外がこの API を呼び出してはいけません。
    *
    *               am    ... Fatal を検知してアプリやアプレットを止める。
    *               audio ... Fatal を検知して音を止めたり、audio の遅延アボートを防止。
    *
    *   @param[out] out       取得したイベント。
    */
    void GetFatalEvent(nn::os::SystemEvent* out) NN_NOEXCEPT;

    /**
    *   @brief      エラーレポートを作成することなく Fatal 画面に遷移します。
    *
    *   @details    この API を呼び出して Fatal 画面に遷移した場合、エラーレポートが記録されません。
    *               この API を呼び出すプロセスは、 API 呼び出し前にエラーレポートを作成するようにしてください。
    *
    *   @param[in]  lastResult  Fatal 画面で表示するエラーコードに対応する Result
    */
    void ThrowFatalWithoutErrorReport(const Result& lastResult) NN_NOEXCEPT;

}} // namespace nn::fatal
