﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_SystemSaveData.h>

namespace nn { namespace es {

// 証明書 DB のマウント名です。
static const char* CertificateDbMountName = "escertificate";

// Common チケット DB のマウント名です。
static const char* CommonTicketDbMountName = "escommon";

// Personalized チケット DB のマウント名です。
static const char* PersonalizedTicketDbMountName = "espersonalized";

// チケットメタ記録 DB のマウント名です。
static const char* TicketMetaRecordDbMountName = "esmetarecord";

// eLicense アーカイブストアのマウント名です。
static const char* ELicenseArchiveStoreMountName = "eselicense";

// 証明書 DB の SystemSaveDataId です。
const nn::fs::SystemSaveDataId CertificateDbSystemSaveDataId = 0x80000000000000e0;

// Common チケット DB の SystemSaveDataId です。
const nn::fs::SystemSaveDataId CommonTicketDbSystemSaveDataId = 0x80000000000000e1;

// Personalized チケット DB の SystemSaveDataId です。
const nn::fs::SystemSaveDataId PersonalizedTicketDbSystemSaveDataId = 0x80000000000000e2;

// チケットメタ記録 DB の SystemSaveDataId です。
const nn::fs::SystemSaveDataId TicketMetaRecordDbSystemSaveDataId = 0x80000000000000e3;

// eLicense アーカイブストアの SystemSaveDataId です。
const nn::fs::SystemSaveDataId ELicenseArchiveStoreSystemSaveDataId = 0x80000000000000e4;

}} // namespace nn::es
