﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/ncm/ncm_ContentMetaKey.h>

namespace nn { namespace err {

    enum class ErrorContextType : Bit8
    {
        None,
        Http,
        FileSystem,
        WebMediaPlayer,
        LocalContentShare,
    };

    struct HttpErrorContext
    {
        char fqdn[256];
        char ip[44];
    };

    struct FileSystemErrorContext
    {
        char     path[500];
        uint32_t fsResultValue;
    };

    struct WebMediaPlayerErrorContext
    {
        char openUrl[488];
        int  lastSocketErrors[4];
    };

    struct LocalContentShareErrorContext
    {
        ncm::ApplicationId applicationId;
        uint32_t resultInnerValue;
        uint32_t ip;
        bool isSender;
        bool isApplicationRequest; // keyList を見れば分かる気もするけど、念のため
        bool hasExFatDriver;
        Bit8 padding[1];
        int numKey;
        ncm::ContentMetaKey keyList[2]; // Application を送るが将来あるかもしれないので、一応２つ取っておく。子機は無視
        Bit8 reserved[448];
    };
    NN_STATIC_ASSERT(sizeof(LocalContentShareErrorContext) == 504);

    struct MaxErrorContext
    {
        char reserved[504];
    };

    /**
    * @brief エラーが発生した文脈を表す構造体です。
    */
    struct ErrorContext
    {
        ErrorContextType type;
        Bit8 reserved[7];

        union
        {
            HttpErrorContext http;
            FileSystemErrorContext fileSystem;
            WebMediaPlayerErrorContext webMediaPlayer;
            LocalContentShareErrorContext localContentShare;
            MaxErrorContext max;
        };
    };
    NN_STATIC_ASSERT(sizeof(ErrorContext) == 512);
}}

