﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      err モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_ERR_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(err, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_ERR_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(err, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_ERR_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(err, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_ERR_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(err, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_ERR_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(err, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_ERR_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(err, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_ERR_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(err, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_ERR_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(err, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_ERR_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(err, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_ERR_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(err, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_ERR_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(err, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_ERR_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(err, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_ERR_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(err, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_ERR_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(err, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_ERR_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(err, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_ERR_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(err, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_ERR_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(err, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_ERR_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(err, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_ERR_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(err, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_ERR_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(err, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_ERR_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(err, Trace, 0, format, args)
#define NN_DETAIL_ERR_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(err, Trace, 1, format, args)
#define NN_DETAIL_ERR_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(err, Trace, 2, format, args)
#define NN_DETAIL_ERR_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(err, Trace, 3, format, args)

#define NN_DETAIL_ERR_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(err, Info, 0, format, args)
#define NN_DETAIL_ERR_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(err, Info, 1, format, args)
#define NN_DETAIL_ERR_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(err, Info, 2, format, args)
#define NN_DETAIL_ERR_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(err, Info, 3, format, args)

#define NN_DETAIL_ERR_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(err, Warn, 0, format, args)
#define NN_DETAIL_ERR_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(err, Warn, 1, format, args)
#define NN_DETAIL_ERR_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(err, Warn, 2, format, args)
#define NN_DETAIL_ERR_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(err, Warn, 3, format, args)

#define NN_DETAIL_ERR_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(err, Error, 0, format, args)
#define NN_DETAIL_ERR_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(err, Error, 1, format, args)
#define NN_DETAIL_ERR_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(err, Error, 2, format, args)
#define NN_DETAIL_ERR_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(err, Error, 3, format, args)

#define NN_DETAIL_ERR_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(err, Fatal, 0, format, args)
#define NN_DETAIL_ERR_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(err, Fatal, 1, format, args)
#define NN_DETAIL_ERR_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(err, Fatal, 2, format, args)
#define NN_DETAIL_ERR_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(err, Fatal, 3, format, args)

#define NN_DETAIL_ERR_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(err, Trace, 0, text, length)
#define NN_DETAIL_ERR_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(err, Trace, 1, text, length)
#define NN_DETAIL_ERR_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(err, Trace, 2, text, length)
#define NN_DETAIL_ERR_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(err, Trace, 3, text, length)

#define NN_DETAIL_ERR_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(err, Info, 0, text, length)
#define NN_DETAIL_ERR_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(err, Info, 1, text, length)
#define NN_DETAIL_ERR_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(err, Info, 2, text, length)
#define NN_DETAIL_ERR_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(err, Info, 3, text, length)

#define NN_DETAIL_ERR_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(err, Warn, 0, text, length)
#define NN_DETAIL_ERR_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(err, Warn, 1, text, length)
#define NN_DETAIL_ERR_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(err, Warn, 2, text, length)
#define NN_DETAIL_ERR_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(err, Warn, 3, text, length)

#define NN_DETAIL_ERR_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(err, Error, 0, text, length)
#define NN_DETAIL_ERR_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(err, Error, 1, text, length)
#define NN_DETAIL_ERR_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(err, Error, 2, text, length)
#define NN_DETAIL_ERR_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(err, Error, 3, text, length)

#define NN_DETAIL_ERR_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(err, Fatal, 0, text, length)
#define NN_DETAIL_ERR_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(err, Fatal, 1, text, length)
#define NN_DETAIL_ERR_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(err, Fatal, 2, text, length)
#define NN_DETAIL_ERR_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(err, Fatal, 3, text, length)
