﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ec { namespace system {
    struct DeviceAccountInfo
    {
        char id[32];    //!< null 終端文字列です。
    };

    /**
    * @brief    デバイスアカウントの状態です。
    *
    * @details  data に状態を表す以下の文字列が格納されます。
    *           - "R"：登録済み
    *           - "U"：抹消済み
    *           - "T"：移行済み
    *           - "P"：移行待ち
    *           needTicketSync にチケット同期フラグが立っているかが格納されます。
    *           RequestDeviceRegistrationInfo で値を取得したときは無効値が入り、正しい値を取得することが出来ません。
    *           isDeviceTokenExpired にサーバ上のデバイストークンが有効な状態であるかが格納されます。
    *           RequestDeviceAccountStatus で値を取得したときは無効値が入り、正しい値を取得することが出来ません。
    */
    struct DeviceAccountStatus
    {
        char data[4];               //!< null 終端文字列です。
        bool needsTicketSync;
        bool isDeviceTokenExpired;
        char padding[2];
    };

    struct DeviceRegistrationInfo
    {
        DeviceAccountInfo   accountInfo;
        DeviceAccountStatus accountStatus;
    };
}}}
