﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Eコマース処理を行うAPIに必要な型や定数などのシステム向け定義
 */

#pragma once

#include <nn/ec/ec_ShopTypes.h>
#include <nn/ec/ec_TypesSystem.h>

namespace nn { namespace ec {

/**
 * @brief 呼び出し元を表す値を指定する際に用いる型です。
 */
struct SourceId
{
    char data[4];
};

inline bool operator == (const SourceId& lhs, const SourceId& rhs)
{
    return lhs.data[0] == rhs.data[0] && lhs.data[1] == rhs.data[1] &&
        lhs.data[2] == rhs.data[2] && lhs.data[3] == rhs.data[3];
}
inline bool operator != (const SourceId& lhs, const SourceId& rhs)
{
    return !(lhs == rhs);
}

/**
 * @brief 呼び出し元種類が「未指定」であることを表します。
 */
static const SourceId SourceId_Default = {{0, 0, 0, 0}};
/**
 * @brief 呼び出し元種類が「クイックランチャー」であることを表します。(Quick LaunCher)
 */
static const SourceId SourceId_Launcher = {{'q', 'l', 'c', 0}};
/**
 * @brief 呼び出し元種類が「ニュース」であることを表します。
 */
static const SourceId SourceId_News = {{'n', 'e', 'w', 's'}};
/**
 * @brief 呼び出し元種類が「キラー通知」であることを表します。(Killer NoTiFication)
 */
static const SourceId SourceId_KillerNotification = {{'k', 'n', 't', 'f'}};
/**
 * @brief 呼び出し元種類が「バショトリャー」であることを表します。(PlaceHoLder)
 */
static const SourceId SourceId_Placeholder = {{'p', 'h', 'l', 'd'}};
/**
 * @brief 呼び出し元種類が「体験版」(起動時に出るダイアログで表示される詳細ボタン)であることを表します。
 */
static const SourceId SourceId_DemoTitle = {{'d', 'e', 'm', 'o'}};
/**
 * @brief 呼び出し元種類が「マイページ」であることを表します。
 */
static const SourceId SourceId_MyPage = {{'m', 'y', 0, 0}};
/**
 * @brief 呼び出し元種類が「本体設定」であることを表します。
 */
static const SourceId SourceId_Settings = {{'s', 'e', 't', 0}};
/**
* @brief 呼び出し元種類が「プリンストール」であることを表します。
*/
static const SourceId SourceId_Preinstall = { { 'p', 'r', 'e', 0 } };

}}
