﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace dauth {

//! @name システム開発用の型
//! @{

/**
* @brief   デバイス認証トークンの最大長
*
* @details 終端文字を含まない文字列長です。
*/
const int DeviceAuthenticationTokenLengthMax = 1024;

/**
* @brief   デバイス認証トークンを取得するための必要バッファサイズ
*
* @details デバイス認証トークンを取得するための必要なバッファサイズです。
*/
const size_t RequiredBufferSizeForDeviceAuthenticationToken = DeviceAuthenticationTokenLengthMax + 1;

/**
* @brief   CDN のエッジ認証に使用する認証トークンの最大長
*
* @details 終端文字を含まない文字列長です。
*/
const int EdgeTokenLengthMax = 256;

/**
* @brief   CDN のエッジ認証に使用する認証トークンを取得するための必要バッファサイズ
*
* @details CDN のエッジ認証に使用する認証トークンを取得するための必要なバッファサイズです。
*/
const size_t RequiredBufferSizeForEdgeToken = EdgeTokenLengthMax + 1;

//! @}

}} // ~namespace nn::dauth
