﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      cpad モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_CPAD_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_CPAD_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_CPAD_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_CPAD_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_CPAD_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_CPAD_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(cpad, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_CPAD_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Trace, 0, format, args)
#define NN_DETAIL_CPAD_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Trace, 1, format, args)
#define NN_DETAIL_CPAD_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Trace, 2, format, args)
#define NN_DETAIL_CPAD_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Trace, 3, format, args)

#define NN_DETAIL_CPAD_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Info, 0, format, args)
#define NN_DETAIL_CPAD_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Info, 1, format, args)
#define NN_DETAIL_CPAD_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Info, 2, format, args)
#define NN_DETAIL_CPAD_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Info, 3, format, args)

#define NN_DETAIL_CPAD_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Warn, 0, format, args)
#define NN_DETAIL_CPAD_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Warn, 1, format, args)
#define NN_DETAIL_CPAD_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Warn, 2, format, args)
#define NN_DETAIL_CPAD_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Warn, 3, format, args)

#define NN_DETAIL_CPAD_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Error, 0, format, args)
#define NN_DETAIL_CPAD_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Error, 1, format, args)
#define NN_DETAIL_CPAD_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Error, 2, format, args)
#define NN_DETAIL_CPAD_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Error, 3, format, args)

#define NN_DETAIL_CPAD_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Fatal, 0, format, args)
#define NN_DETAIL_CPAD_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Fatal, 1, format, args)
#define NN_DETAIL_CPAD_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Fatal, 2, format, args)
#define NN_DETAIL_CPAD_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(cpad, Fatal, 3, format, args)

#define NN_DETAIL_CPAD_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Trace, 0, text, length)
#define NN_DETAIL_CPAD_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Trace, 1, text, length)
#define NN_DETAIL_CPAD_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Trace, 2, text, length)
#define NN_DETAIL_CPAD_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Trace, 3, text, length)

#define NN_DETAIL_CPAD_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Info, 0, text, length)
#define NN_DETAIL_CPAD_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Info, 1, text, length)
#define NN_DETAIL_CPAD_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Info, 2, text, length)
#define NN_DETAIL_CPAD_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Info, 3, text, length)

#define NN_DETAIL_CPAD_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Warn, 0, text, length)
#define NN_DETAIL_CPAD_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Warn, 1, text, length)
#define NN_DETAIL_CPAD_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Warn, 2, text, length)
#define NN_DETAIL_CPAD_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Warn, 3, text, length)

#define NN_DETAIL_CPAD_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Error, 0, text, length)
#define NN_DETAIL_CPAD_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Error, 1, text, length)
#define NN_DETAIL_CPAD_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Error, 2, text, length)
#define NN_DETAIL_CPAD_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Error, 3, text, length)

#define NN_DETAIL_CPAD_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Fatal, 0, text, length)
#define NN_DETAIL_CPAD_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Fatal, 1, text, length)
#define NN_DETAIL_CPAD_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Fatal, 2, text, length)
#define NN_DETAIL_CPAD_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(cpad, Fatal, 3, text, length)
