﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/** @file
    @brief      CDMSC Types declaration
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/cdmsc/cdmsc_Result.h>

namespace nn {
namespace cdmsc {

/**
 * @brief Type of aligned memory allocator
 */
typedef void* (*AllocateFunction)(size_t alignment, size_t size);

/**
 * @brief Type of memory deallocator
 */
typedef void  (*DeallocateFunction)(void *pointer, size_t size);

/**
 * @brief Handle representing an enumerated mass storage device.
 *        The lifecycle of this handle begins when a mass storage device is enumerated,
 *        and ends when it is logically disconnected. Value of zero is invalid.
 */
typedef uintptr_t UnitHandle;

/**
 * @brief Profile of a connected device.
 */
struct UnitProfile
{
    UnitHandle   handle;              // Handle of this device
    uint16_t     vid;                 // VID of the device
    uint16_t     pid;                 // PID of the device
    uint32_t     blockSize;           // The size of a logical block, in bytes
    uint64_t     blockCount;          // The total number of logical blocks. Maximum LBA is blockCount-1
    bool         isWriteProtected;    // Does this device currently prohibit writes?
};

}  // cdmsc
}  // nn
