﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/** @file
    @brief      CDMSC configuration
*/

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace cdmsc {

/**
 * @brief Maximum number of enumerated logical units
 */
const int LogicalUnitCountMax = 2;

/**
 * @brief Maximum number of enumerated mass storage devices
 */
const int DeviceCountMax = LogicalUnitCountMax;

/**
 * @brief Maximum number of retry for each phase of a single BOT transaction
 */
const int BotPhaseRetryMax = 3;

/**
 * @brief Maximum number of retry for each BOT transaction
 */
const int BotTransactionRetryMax = 3;

/**
 * @brief Timeout value in millisecond for each BOT transaction
 */
const int BotTransactionTimeout = 25000;


}  // cdmsc
}  // nn
