﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ユーザアプリケーション向けの型宣言
 */

#pragma once

#include <nn/bluetooth/bluetooth_LeTypes.h>

namespace nn { namespace btm { namespace user {

typedef nn::bluetooth::BleAdvertisePacketParameter  BleAdvFilterForGeneral;

typedef nn::bluetooth::GattAttributeUuid BleAdvFilterForSmartDevice;

typedef nn::bluetooth::BleScanResult ScanResult;

typedef nn::bluetooth::BleConnectionInfo BleClientConnState;

/**
    * @brief       GATT Attribute を表す構造体です
    */
struct GattAttribute
{
    nn::bluetooth::GattAttributeType    type;       //!< GATT Attribute のタイプです
    nn::bluetooth::GattAttributeUuid    uuid;       //!< GATT Attribute のUUID です
    uint16_t                            handle;     //!< GATT Attribute を識別するハンドルです
};

/**
    * @brief       GATT Service を表す構造体です
    *
    * @details     GATT Attribute 構造体を継承します
    */
struct GattService : GattAttribute
{
    uint16_t    instanceId;             //!< 同一のGATT Attribute UUID を持つService が存在する場合に、それらを識別するために用いられるサブ識別子です
    uint16_t    endGroupHandle;         //!< 自身に所属するGATT Attribute が持ちうる最大のハンドルの値です
    bool        isPrimaryService;       //!< Primary Service であるかを示すフラグです
};

/**
    * @brief       GATT Characteristic を表す構造体です
    *
    * @details     GATT Attribute 構造体を継承します
    */
struct GattCharacteristic : GattAttribute
{
    uint16_t    instanceId;     //!< 同一のGATT Attribute UUID を持つService が存在する場合に、それらを識別するために用いられるサブ識別子です
    uint16_t    permission;     //!< 自身に許可されたGATT 操作を表すビットフラグです
    uint8_t     property;       //!< 自身へのGATT 操作方法を表すビットフラグです
};

/**
    * @brief       GATT Descriptor を表す構造体です
    *
    * @details     GATT Attribute 構造体を継承します
    */
struct GattDescriptor : GattAttribute
{
    uint16_t    permission;    //!< 自身に許可されたGATT 操作を表すビットフラグです
};

/**
    * @brief       BLE のGatt Attribute の操作結果の通知先を表す列挙型です
    */
typedef enum : uint8_t
{
    BLE_DATA_PATH_GENERAL,
    BLE_DATA_PATH_HID,
} BleDataPathType;

struct BleDataPath
{
    BleDataPathType                     path;
    nn::bluetooth::GattAttributeUuid    uuid;
};

}}} // namespace nn::btm::user

