﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief RTC を操作する機能の API 宣言。
 */

#pragma once

#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/bpc/bpc_WakeupConfigTypes.h>

namespace nn { namespace bpc { namespace driver {

//! @name RTC 時刻の取得・設定
//! @{

nn::Result GetRtcTime(int64_t *pOutRtcTimeInSeconds) NN_NOEXCEPT;
nn::Result SetRtcTime(int64_t rtcTimeInSeconds) NN_NOEXCEPT;
nn::Result GetRtcResetDetected(bool* pOutRtcResetDetected) NN_NOEXCEPT;
nn::Result ClearRtcResetDetected() NN_NOEXCEPT;
nn::Result SetUpRtcResetOnShutdown() NN_NOEXCEPT;

//! @}

//! @name 起動タイマー
//! @{

nn::Result CreateWakeupTimer(int* pOutHandle, nn::TimeSpan interval, WakeupTimerType type) NN_NOEXCEPT;
nn::Result CancelWakeupTimer(int timerHandle) NN_NOEXCEPT;

nn::Result EnableWakeupTimerOnDevice(bool *pOutIsEnabled, int* pOutTimerHandle, WakeupTimerType* pOutTimerType) NN_NOEXCEPT;
WakeupTimerType GetLastEnabledWakeupTimerType() NN_NOEXCEPT;
nn::Result CleanAllWakeupTimers(WakeupTimerType type) NN_NOEXCEPT;

//! @}

}}} // namepsace nn::bpc::driver
