﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace bpc {

//!< タイマーの種類を表す列挙子です。定義値の大きいものが高優先度です。
enum WakeupTimerType
{
    WakeupTimerType_None = 0, //!< 無効なタイマーです。
    WakeupTimerType_BackgroundTask = 0x10, //!< タイマー発動時、システムはバックグラウンドタスク実行ステートに移行します。
    WakeupTimerType_FullWakeup = 0x20, //!< タイマー発動時、システムは起床状態に移行します。
};

//!< 起動タイマーの発動時間に指定できる最小値 (秒) です。
const int64_t MinWakeupIntervalInSeconds = 2LL;

}} // namespace nn::bpc
