﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief 起動タイマーの電源状態制御モジュール向け機能の API 宣言。
 */

#pragma once

#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>

#include "bpc_WakeupConfigTypes.h"

namespace nn { namespace bpc {

//! @name ウェイク設定関連の電源状態制御モジュール向け機能
//! @{

/**
 * @brief 最後に有効にされた起動タイマーのタイプを取得します。
 *
 * @return 最後に有効にされた起動タイマーのタイプ
 *
 * @details
 *  最後に有効にされた起動タイマーのタイプを取得します。 @n
 *  起動タイマーがセットされなかった場合は、 @a nn::bpc::WakeupTimerType_None が返ります。
 */
WakeupTimerType GetLastEnabledWakeupTimerType() NN_NOEXCEPT;

//! @}

}} // namepsace nn::bpc
