﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief 起動タイマーのサーバ向け機能の API 宣言。
 */

#pragma once

#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>

#include "bpc_WakeupConfigTypes.h"

namespace nn { namespace bpc {

//! @name ウェイク設定関連のサーバ向け機能（テスト用）
//! @{

/**
 * @brief       起動タイマーの設定を外部 RTC デバイスに反映します。
 *
 * @param[out]  pOutIsEnabled     タイマーが有効になったかどうか
 * @param[out]  pOutTimerHandle   デバイスにセットされたタイマーのハンドル
 * @param[out]  pOutTimerType     デバイスにセットされたタイマーの種類
 *
 * @retresult
 * @endretresult
 *
 * @pre
 *  - ウェイク設定関連機能ブロックが初期化済
 *
 * @details
 *  起動タイマーの設定を外部 RTC デバイスに反映します。 @n
 *  登録済の起動タイマーの中で期間の短いものを RTC デバイスにセットします。 @n
 *  この関数は、システムがスリープまたはシャットダウンに入るできるだけ直前に一度だけ呼び出してください。
 */
nn::Result EnableWakeupTimerOnDevice(bool *pOutIsEnabled, int* pOutTimerHandle, WakeupTimerType* pOutTimerType) NN_NOEXCEPT;

/**
 * @brief       指定した種類の起動タイマーをすべてキャンセル・解除します。
 *
 * @param[in]  type     解除対象の起動タイマーの種類
 *
 * @retresult
 * @endretresult
 *
 * @pre
 *  - ウェイク設定関連機能ブロックが初期化済
 *
 * @details
 *  指定した種類の起動タイマーをすべてキャンセル・解除します。
 */
nn::Result CleanAllWakeupTimers(WakeupTimerType type) NN_NOEXCEPT;

//! @}

}} // namepsace nn::bpc
