﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/bluetooth/bluetooth_Types.h>
#include <nn/nn_Result.h>
#include <nn/settings/system/settings_BluetoothDevices.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace bluetooth { // NOLINT(whitespace/braces)

class IBluetoothDriver;

class IBluetoothUser;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBluetoothDriver, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBluetoothDriver)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(WaitServerReady)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializeBluetoothImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EnableBluetoothImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DisableBluetoothImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CleanupBluetoothImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAdapterPropertiesImpl, (::nn::sf::Out<::nn::bluetooth::AdapterProperty> pAdapterProperty))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAdapterPropertyImpl, (::nn::bluetooth::BluetoothPropertyType propertyType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAdapterPropertyImpl, (::nn::bluetooth::BluetoothPropertyType propertyType, const ::nn::sf::InArray<::std::uint8_t>& pInArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StartDiscoveryImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelDiscoveryImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateBondImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothTransport transport))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RemoveBondImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelBondImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PinReplyImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t accept, ::std::uint8_t pinLength, const ::nn::bluetooth::BluetoothPinCode& pinCode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SspReplyImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t variant, ::std::uint8_t accept, ::std::uint32_t passkey))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializeHidImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::std::uint16_t version))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidConnectImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidDisconnectImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidSendDataByStructureImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::bluetooth::HidData& pData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidSendDataImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::sf::InArray<::std::uint8_t>& pInArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidSetReportImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothHhReportType reportType, const ::nn::bluetooth::HidData& pData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidGetReportImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothHhReportType reportType, ::std::uint8_t reportId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidWakeControllerImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidAddPairedDeviceImpl, (const ::nn::settings::system::BluetoothDevicesSettings& deviceSettings))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidGetPairedDeviceImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::sf::Out<::nn::settings::system::BluetoothDevicesSettings> deviceSettings))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CleanupHidImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidGetEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetTsiImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t tsiMode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetBurstModeImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isBurst))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetZeroRetranImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::sf::InArray<::std::uint8_t>& pReportIds))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetMcModeImpl, (bool isMcModeEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ExtStartLlrModeImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ExtExitLlrModeImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetRadioImpl, (bool enable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetVisibilityImpl, (bool discoverable, bool connectable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetTbfcScanImpl, (bool enable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterHidReportEventImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HidGetReportEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLatestPlrImpl, (::nn::sf::Out<::nn::bluetooth::PlrStatistics> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ExtGetPendingConnectionsImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetChannelMapImpl, (::nn::sf::Out<::nn::bluetooth::ChannelMap> pOutChannelMap))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnableBluetoothBoostSettingImpl, (bool enable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsBluetoothBoostEnabledImpl, (::nn::sf::Out<bool> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnableBluetoothAfhSettingImpl, (bool enable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsBluetoothAfhEnabledImpl, (::nn::sf::Out<bool> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InitializeBleImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EnableBleImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DisableBleImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CleanupBleImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLeVisibilityImpl, (bool discoverable, bool connectable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLeConnectionParameterImpl, (const ::nn::bluetooth::LeConnectionParams& connectionParams))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLeDefaultConnectionParameterImpl, (const ::nn::bluetooth::LeConnectionParams& connectionParams))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLeAdvertiseDataImpl, (const ::nn::bluetooth::LeAdvertiseData& advertiseData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLeAdvertiseParameterImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint16_t minAdvInt, ::std::uint16_t maxAdvInt))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StartLeScanImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopLeScanImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddLeScanFilterConditionImpl, (const ::nn::bluetooth::BleAdvertiseFilter& filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteLeScanFilterConditionImpl, (const ::nn::bluetooth::BleAdvertiseFilter& filter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteLeScanFilterImpl, (::std::uint8_t filterIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearLeScanFiltersImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnableLeScanFilterImpl, (bool enable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeClientImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeClientImpl, (::std::uint8_t clientIf))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterLeClientAllImpl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientConnectImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint8_t clientIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientCancelConnectionImpl, (::std::uint8_t clientIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDisconnectImpl, (::std::uint32_t connId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientGetAttributesImpl, (::std::uint32_t connId, ::nn::bluetooth::BluetoothAddress bluetoothAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDiscoverServiceImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattAttributeUuid& filterUuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientConfigureMtu, (::std::uint32_t connId, ::std::uint16_t mtu))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeServerImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeServerImpl, (::std::uint8_t serverIf))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeServerConnectImpl, (::std::uint8_t serverIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeServerDisconnectImpl, (::std::uint8_t serverIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateLeServiceImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& uuid, ::std::uint8_t handleNum, bool isPrimaryService))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartLeServiceImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddLeCharacteristicImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& charUuid, ::std::uint16_t permissions, ::std::uint8_t properties))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddLeDescriptorImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& descUuid, ::std::uint16_t permissions))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLeCoreEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeGetFirstCharacteristicImpl, (::nn::sf::Out<::nn::bluetooth::GattId> charOut, ::nn::sf::Out<::std::uint8_t> property, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattAttributeUuid& charFilter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeGetNextCharacteristicImpl, (::nn::sf::Out<::nn::bluetooth::GattId> charOut, ::nn::sf::Out<::std::uint8_t> property, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattAttributeUuid& charFilter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeGetFirstDescriptorImpl, (::nn::sf::Out<::nn::bluetooth::GattId> descrOut, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattAttributeUuid& descrFilter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeGetNextDescriptorImpl, (::nn::sf::Out<::nn::bluetooth::GattId> descrOut, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattId& descrIn, const ::nn::bluetooth::GattAttributeUuid& descrFilter))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeCoreDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeCoreDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeHidDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeHidDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadCharacteristicImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, ::std::uint8_t authType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadDescriptorImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, ::std::uint8_t authType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteCharacteristicImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType, bool withResponse))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteDescriptorImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientRegisterNotificationImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDeregisterNotificationImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLeHidEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleHidEventImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLeScanParameterImpl, (::std::uint16_t scanInterval, ::std::uint16_t scanWindow))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(GetIsManufacturingModeImpl, (bool))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBluetoothDriver)

        ::nn::Result WaitServerReady() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(WaitServerReady);
        }

        ::nn::Result InitializeBluetoothImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializeBluetoothImpl, (handle));
        }

        ::nn::Result EnableBluetoothImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EnableBluetoothImpl);
        }

        ::nn::Result DisableBluetoothImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DisableBluetoothImpl);
        }

        ::nn::Result CleanupBluetoothImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CleanupBluetoothImpl);
        }

        ::nn::Result GetAdapterPropertiesImpl(::nn::sf::Out<::nn::bluetooth::AdapterProperty> pAdapterProperty) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAdapterPropertiesImpl, (pAdapterProperty));
        }

        ::nn::Result GetAdapterPropertyImpl(::nn::bluetooth::BluetoothPropertyType propertyType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAdapterPropertyImpl, (propertyType, pOutArray));
        }

        ::nn::Result SetAdapterPropertyImpl(::nn::bluetooth::BluetoothPropertyType propertyType, const ::nn::sf::InArray<::std::uint8_t>& pInArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAdapterPropertyImpl, (propertyType, pInArray));
        }

        ::nn::Result StartDiscoveryImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StartDiscoveryImpl);
        }

        ::nn::Result CancelDiscoveryImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelDiscoveryImpl);
        }

        ::nn::Result CreateBondImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothTransport transport) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateBondImpl, (bluetoothAddress, transport));
        }

        ::nn::Result RemoveBondImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RemoveBondImpl, (bluetoothAddress));
        }

        ::nn::Result CancelBondImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelBondImpl, (bluetoothAddress));
        }

        ::nn::Result PinReplyImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t accept, ::std::uint8_t pinLength, const ::nn::bluetooth::BluetoothPinCode& pinCode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PinReplyImpl, (bluetoothAddress, accept, pinLength, pinCode));
        }

        ::nn::Result SspReplyImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t variant, ::std::uint8_t accept, ::std::uint32_t passkey) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SspReplyImpl, (bluetoothAddress, variant, accept, passkey));
        }

        ::nn::Result GetEventInfoImpl(::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetEventInfoImpl, (pEventType, pOutArray));
        }

        ::nn::Result InitializeHidImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle, ::std::uint16_t version) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializeHidImpl, (handle, version));
        }

        ::nn::Result HidConnectImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidConnectImpl, (bluetoothAddress));
        }

        ::nn::Result HidDisconnectImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidDisconnectImpl, (bluetoothAddress));
        }

        ::nn::Result HidSendDataByStructureImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::bluetooth::HidData& pData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidSendDataByStructureImpl, (bluetoothAddress, pData));
        }

        ::nn::Result HidSendDataImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::sf::InArray<::std::uint8_t>& pInArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidSendDataImpl, (bluetoothAddress, pInArray));
        }

        ::nn::Result HidSetReportImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothHhReportType reportType, const ::nn::bluetooth::HidData& pData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidSetReportImpl, (bluetoothAddress, reportType, pData));
        }

        ::nn::Result HidGetReportImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothHhReportType reportType, ::std::uint8_t reportId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidGetReportImpl, (bluetoothAddress, reportType, reportId));
        }

        ::nn::Result HidWakeControllerImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidWakeControllerImpl, (bluetoothAddress));
        }

        ::nn::Result HidAddPairedDeviceImpl(const ::nn::settings::system::BluetoothDevicesSettings& deviceSettings) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidAddPairedDeviceImpl, (deviceSettings));
        }

        ::nn::Result HidGetPairedDeviceImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::sf::Out<::nn::settings::system::BluetoothDevicesSettings> deviceSettings) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidGetPairedDeviceImpl, (bluetoothAddress, deviceSettings));
        }

        ::nn::Result CleanupHidImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CleanupHidImpl);
        }

        ::nn::Result HidGetEventInfoImpl(::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidGetEventInfoImpl, (pEventType, pOutArray));
        }

        ::nn::Result ExtSetTsiImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t tsiMode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExtSetTsiImpl, (bluetoothAddress, tsiMode));
        }

        ::nn::Result ExtSetBurstModeImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isBurst) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExtSetBurstModeImpl, (bluetoothAddress, isBurst));
        }

        ::nn::Result ExtSetZeroRetranImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::sf::InArray<::std::uint8_t>& pReportIds) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExtSetZeroRetranImpl, (bluetoothAddress, pReportIds));
        }

        ::nn::Result ExtSetMcModeImpl(bool isMcModeEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExtSetMcModeImpl, (isMcModeEnabled));
        }

        ::nn::Result ExtStartLlrModeImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ExtStartLlrModeImpl);
        }

        ::nn::Result ExtExitLlrModeImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ExtExitLlrModeImpl);
        }

        ::nn::Result ExtSetRadioImpl(bool enable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExtSetRadioImpl, (enable));
        }

        ::nn::Result ExtSetVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExtSetVisibilityImpl, (discoverable, connectable));
        }

        ::nn::Result ExtSetTbfcScanImpl(bool enable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ExtSetTbfcScanImpl, (enable));
        }

        ::nn::Result RegisterHidReportEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterHidReportEventImpl, (handle));
        }

        ::nn::Result HidGetReportEventInfoImpl(::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HidGetReportEventInfoImpl, (pEventType, pOutArray));
        }

        ::nn::Result GetLatestPlrImpl(::nn::sf::Out<::nn::bluetooth::PlrStatistics> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLatestPlrImpl, (pOut));
        }

        ::nn::Result ExtGetPendingConnectionsImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ExtGetPendingConnectionsImpl);
        }

        ::nn::Result GetChannelMapImpl(::nn::sf::Out<::nn::bluetooth::ChannelMap> pOutChannelMap) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetChannelMapImpl, (pOutChannelMap));
        }

        ::nn::Result EnableBluetoothBoostSettingImpl(bool enable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnableBluetoothBoostSettingImpl, (enable));
        }

        ::nn::Result IsBluetoothBoostEnabledImpl(::nn::sf::Out<bool> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsBluetoothBoostEnabledImpl, (pOut));
        }

        ::nn::Result EnableBluetoothAfhSettingImpl(bool enable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnableBluetoothAfhSettingImpl, (enable));
        }

        ::nn::Result IsBluetoothAfhEnabledImpl(::nn::sf::Out<bool> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsBluetoothAfhEnabledImpl, (pOut));
        }

        ::nn::Result InitializeBleImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InitializeBleImpl, (handle));
        }

        ::nn::Result EnableBleImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EnableBleImpl);
        }

        ::nn::Result DisableBleImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DisableBleImpl);
        }

        ::nn::Result CleanupBleImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CleanupBleImpl);
        }

        ::nn::Result SetLeVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLeVisibilityImpl, (discoverable, connectable));
        }

        ::nn::Result SetLeConnectionParameterImpl(const ::nn::bluetooth::LeConnectionParams& connectionParams) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLeConnectionParameterImpl, (connectionParams));
        }

        ::nn::Result SetLeDefaultConnectionParameterImpl(const ::nn::bluetooth::LeConnectionParams& connectionParams) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLeDefaultConnectionParameterImpl, (connectionParams));
        }

        ::nn::Result SetLeAdvertiseDataImpl(const ::nn::bluetooth::LeAdvertiseData& advertiseData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLeAdvertiseDataImpl, (advertiseData));
        }

        ::nn::Result SetLeAdvertiseParameterImpl(::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint16_t minAdvInt, ::std::uint16_t maxAdvInt) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLeAdvertiseParameterImpl, (bluetoothAddress, minAdvInt, maxAdvInt));
        }

        ::nn::Result StartLeScanImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StartLeScanImpl);
        }

        ::nn::Result StopLeScanImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopLeScanImpl);
        }

        ::nn::Result AddLeScanFilterConditionImpl(const ::nn::bluetooth::BleAdvertiseFilter& filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddLeScanFilterConditionImpl, (filter));
        }

        ::nn::Result DeleteLeScanFilterConditionImpl(const ::nn::bluetooth::BleAdvertiseFilter& filter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteLeScanFilterConditionImpl, (filter));
        }

        ::nn::Result DeleteLeScanFilterImpl(::std::uint8_t filterIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteLeScanFilterImpl, (filterIndex));
        }

        ::nn::Result ClearLeScanFiltersImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearLeScanFiltersImpl);
        }

        ::nn::Result EnableLeScanFilterImpl(bool enable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnableLeScanFilterImpl, (enable));
        }

        ::nn::Result RegisterLeClientImpl(const ::nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterLeClientImpl, (uuid));
        }

        ::nn::Result UnregisterLeClientImpl(::std::uint8_t clientIf) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterLeClientImpl, (clientIf));
        }

        ::nn::Result UnregisterLeClientAllImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnregisterLeClientAllImpl);
        }

        ::nn::Result LeClientConnectImpl(::nn::applet::AppletResourceUserId aruid, ::std::uint8_t clientIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientConnectImpl, (aruid, clientIf, bluetoothAddress, isDirect));
        }

        ::nn::Result LeClientCancelConnectionImpl(::std::uint8_t clientIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientCancelConnectionImpl, (clientIf, bluetoothAddress, isDirect));
        }

        ::nn::Result LeClientDisconnectImpl(::std::uint32_t connId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientDisconnectImpl, (connId));
        }

        ::nn::Result LeClientGetAttributesImpl(::std::uint32_t connId, ::nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientGetAttributesImpl, (connId, bluetoothAddress));
        }

        ::nn::Result LeClientDiscoverServiceImpl(::std::uint32_t connId, const ::nn::bluetooth::GattAttributeUuid& filterUuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientDiscoverServiceImpl, (connId, filterUuid));
        }

        ::nn::Result LeClientConfigureMtu(::std::uint32_t connId, ::std::uint16_t mtu) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientConfigureMtu, (connId, mtu));
        }

        ::nn::Result RegisterLeServerImpl(const ::nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterLeServerImpl, (uuid));
        }

        ::nn::Result UnregisterLeServerImpl(::std::uint8_t serverIf) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterLeServerImpl, (serverIf));
        }

        ::nn::Result LeServerConnectImpl(::std::uint8_t serverIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeServerConnectImpl, (serverIf, bluetoothAddress, isDirect));
        }

        ::nn::Result LeServerDisconnectImpl(::std::uint8_t serverIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeServerDisconnectImpl, (serverIf, bluetoothAddress));
        }

        ::nn::Result CreateLeServiceImpl(::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& uuid, ::std::uint8_t handleNum, bool isPrimaryService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateLeServiceImpl, (serverIf, uuid, handleNum, isPrimaryService));
        }

        ::nn::Result StartLeServiceImpl(::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartLeServiceImpl, (serverIf, uuid));
        }

        ::nn::Result AddLeCharacteristicImpl(::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& charUuid, ::std::uint16_t permissions, ::std::uint8_t properties) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddLeCharacteristicImpl, (serverIf, serviceUuid, charUuid, permissions, properties));
        }

        ::nn::Result AddLeDescriptorImpl(::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& descUuid, ::std::uint16_t permissions) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddLeDescriptorImpl, (serverIf, serviceUuid, descUuid, permissions));
        }

        ::nn::Result GetLeCoreEventInfoImpl(::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLeCoreEventInfoImpl, (pEventType, pOutArray));
        }

        ::nn::Result LeGetFirstCharacteristicImpl(::nn::sf::Out<::nn::bluetooth::GattId> charOut, ::nn::sf::Out<::std::uint8_t> property, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattAttributeUuid& charFilter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeGetFirstCharacteristicImpl, (charOut, property, connId, serviceId, isPrimary, charFilter));
        }

        ::nn::Result LeGetNextCharacteristicImpl(::nn::sf::Out<::nn::bluetooth::GattId> charOut, ::nn::sf::Out<::std::uint8_t> property, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattAttributeUuid& charFilter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeGetNextCharacteristicImpl, (charOut, property, connId, serviceId, isPrimary, charIn, charFilter));
        }

        ::nn::Result LeGetFirstDescriptorImpl(::nn::sf::Out<::nn::bluetooth::GattId> descrOut, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattAttributeUuid& descrFilter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeGetFirstDescriptorImpl, (descrOut, connId, serviceId, isPrimary, charIn, descrFilter));
        }

        ::nn::Result LeGetNextDescriptorImpl(::nn::sf::Out<::nn::bluetooth::GattId> descrOut, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattId& descrIn, const ::nn::bluetooth::GattAttributeUuid& descrFilter) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeGetNextDescriptorImpl, (descrOut, connId, serviceId, isPrimary, charIn, descrIn, descrFilter));
        }

        ::nn::Result RegisterLeCoreDataPathImpl(const ::nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterLeCoreDataPathImpl, (uuid));
        }

        ::nn::Result UnregisterLeCoreDataPathImpl(const ::nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterLeCoreDataPathImpl, (uuid));
        }

        ::nn::Result RegisterLeHidDataPathImpl(const ::nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterLeHidDataPathImpl, (uuid));
        }

        ::nn::Result UnregisterLeHidDataPathImpl(const ::nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterLeHidDataPathImpl, (uuid));
        }

        ::nn::Result RegisterLeDataPathImpl(const ::nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterLeDataPathImpl, (uuid));
        }

        ::nn::Result UnregisterLeDataPathImpl(const ::nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterLeDataPathImpl, (uuid));
        }

        ::nn::Result LeClientReadCharacteristicImpl(::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, ::std::uint8_t authType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientReadCharacteristicImpl, (connId, serviceId, isPrimary, charId, authType));
        }

        ::nn::Result LeClientReadDescriptorImpl(::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, ::std::uint8_t authType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientReadDescriptorImpl, (connId, serviceId, isPrimary, charId, descrId, authType));
        }

        ::nn::Result LeClientWriteCharacteristicImpl(::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType, bool withResponse) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientWriteCharacteristicImpl, (connId, serviceId, isPrimary, charId, pData, authType, withResponse));
        }

        ::nn::Result LeClientWriteDescriptorImpl(::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientWriteDescriptorImpl, (connId, serviceId, isPrimary, charId, descrId, pData, authType));
        }

        ::nn::Result LeClientRegisterNotificationImpl(::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientRegisterNotificationImpl, (connId, serviceId, isPrimary, charId));
        }

        ::nn::Result LeClientDeregisterNotificationImpl(::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientDeregisterNotificationImpl, (connId, serviceId, isPrimary, charId));
        }

        ::nn::Result GetLeHidEventInfoImpl(::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLeHidEventInfoImpl, (pEventType, pOutArray));
        }

        ::nn::Result RegisterBleHidEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterBleHidEventImpl, (handle));
        }

        ::nn::Result SetLeScanParameterImpl(::std::uint16_t scanInterval, ::std::uint16_t scanWindow) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLeScanParameterImpl, (scanInterval, scanWindow));
        }

        bool GetIsManufacturingModeImpl() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(GetIsManufacturingModeImpl, (bool));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBluetoothDriver
    {
    public:
        nn::Result WaitServerReady() NN_NOEXCEPT;
        nn::Result InitializeBluetoothImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result EnableBluetoothImpl() NN_NOEXCEPT;
        nn::Result DisableBluetoothImpl() NN_NOEXCEPT;
        nn::Result CleanupBluetoothImpl() NN_NOEXCEPT;
        nn::Result GetAdapterPropertiesImpl(nn::sf::Out<nn::bluetooth::AdapterProperty> pAdapterProperty) NN_NOEXCEPT;
        nn::Result GetAdapterPropertyImpl(nn::bluetooth::BluetoothPropertyType propertyType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
        nn::Result SetAdapterPropertyImpl(nn::bluetooth::BluetoothPropertyType propertyType, const nn::sf::InArray<std::uint8_t>& pInArray) NN_NOEXCEPT;
        nn::Result StartDiscoveryImpl() NN_NOEXCEPT;
        nn::Result CancelDiscoveryImpl() NN_NOEXCEPT;
        nn::Result CreateBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothTransport transport) NN_NOEXCEPT;
        nn::Result RemoveBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
        nn::Result CancelBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
        nn::Result PinReplyImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t accept, std::uint8_t pinLength, const nn::bluetooth::BluetoothPinCode& pinCode) NN_NOEXCEPT;
        nn::Result SspReplyImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t variant, std::uint8_t accept, std::uint32_t passkey) NN_NOEXCEPT;
        nn::Result GetEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
        nn::Result InitializeHidImpl(nn::sf::Out<nn::sf::NativeHandle> handle, std::uint16_t version) NN_NOEXCEPT;
        nn::Result HidConnectImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
        nn::Result HidDisconnectImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
        nn::Result HidSendDataByStructureImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::bluetooth::HidData& pData) NN_NOEXCEPT;
        nn::Result HidSendDataImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::sf::InArray<std::uint8_t>& pInArray) NN_NOEXCEPT;
        nn::Result HidSetReportImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothHhReportType reportType, const nn::bluetooth::HidData& pData) NN_NOEXCEPT;
        nn::Result HidGetReportImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothHhReportType reportType, std::uint8_t reportId) NN_NOEXCEPT;
        nn::Result HidWakeControllerImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
        nn::Result HidAddPairedDeviceImpl(const nn::settings::system::BluetoothDevicesSettings& deviceSettings) NN_NOEXCEPT;
        nn::Result HidGetPairedDeviceImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::sf::Out<nn::settings::system::BluetoothDevicesSettings> deviceSettings) NN_NOEXCEPT;
        nn::Result CleanupHidImpl() NN_NOEXCEPT;
        nn::Result HidGetEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
        nn::Result ExtSetTsiImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t tsiMode) NN_NOEXCEPT;
        nn::Result ExtSetBurstModeImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, bool isBurst) NN_NOEXCEPT;
        nn::Result ExtSetZeroRetranImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::sf::InArray<std::uint8_t>& pReportIds) NN_NOEXCEPT;
        nn::Result ExtSetMcModeImpl(bool isMcModeEnabled) NN_NOEXCEPT;
        nn::Result ExtStartLlrModeImpl() NN_NOEXCEPT;
        nn::Result ExtExitLlrModeImpl() NN_NOEXCEPT;
        nn::Result ExtSetRadioImpl(bool enable) NN_NOEXCEPT;
        nn::Result ExtSetVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT;
        nn::Result ExtSetTbfcScanImpl(bool enable) NN_NOEXCEPT;
        nn::Result RegisterHidReportEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result HidGetReportEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
        nn::Result GetLatestPlrImpl(nn::sf::Out<nn::bluetooth::PlrStatistics> pOut) NN_NOEXCEPT;
        nn::Result ExtGetPendingConnectionsImpl() NN_NOEXCEPT;
        nn::Result GetChannelMapImpl(nn::sf::Out<nn::bluetooth::ChannelMap> pOutChannelMap) NN_NOEXCEPT;
        nn::Result EnableBluetoothBoostSettingImpl(bool enable) NN_NOEXCEPT;
        nn::Result IsBluetoothBoostEnabledImpl(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
        nn::Result EnableBluetoothAfhSettingImpl(bool enable) NN_NOEXCEPT;
        nn::Result IsBluetoothAfhEnabledImpl(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
        nn::Result InitializeBleImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result EnableBleImpl() NN_NOEXCEPT;
        nn::Result DisableBleImpl() NN_NOEXCEPT;
        nn::Result CleanupBleImpl() NN_NOEXCEPT;
        nn::Result SetLeVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT;
        nn::Result SetLeConnectionParameterImpl(const nn::bluetooth::LeConnectionParams& connectionParams) NN_NOEXCEPT;
        nn::Result SetLeDefaultConnectionParameterImpl(const nn::bluetooth::LeConnectionParams& connectionParams) NN_NOEXCEPT;
        nn::Result SetLeAdvertiseDataImpl(const nn::bluetooth::LeAdvertiseData& advertiseData) NN_NOEXCEPT;
        nn::Result SetLeAdvertiseParameterImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint16_t minAdvInt, std::uint16_t maxAdvInt) NN_NOEXCEPT;
        nn::Result StartLeScanImpl() NN_NOEXCEPT;
        nn::Result StopLeScanImpl() NN_NOEXCEPT;
        nn::Result AddLeScanFilterConditionImpl(const nn::bluetooth::BleAdvertiseFilter& filter) NN_NOEXCEPT;
        nn::Result DeleteLeScanFilterConditionImpl(const nn::bluetooth::BleAdvertiseFilter& filter) NN_NOEXCEPT;
        nn::Result DeleteLeScanFilterImpl(std::uint8_t filterIndex) NN_NOEXCEPT;
        nn::Result ClearLeScanFiltersImpl() NN_NOEXCEPT;
        nn::Result EnableLeScanFilterImpl(bool enable) NN_NOEXCEPT;
        nn::Result RegisterLeClientImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
        nn::Result UnregisterLeClientImpl(std::uint8_t clientIf) NN_NOEXCEPT;
        nn::Result UnregisterLeClientAllImpl() NN_NOEXCEPT;
        nn::Result LeClientConnectImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t clientIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT;
        nn::Result LeClientCancelConnectionImpl(std::uint8_t clientIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT;
        nn::Result LeClientDisconnectImpl(std::uint32_t connId) NN_NOEXCEPT;
        nn::Result LeClientGetAttributesImpl(std::uint32_t connId, nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
        nn::Result LeClientDiscoverServiceImpl(std::uint32_t connId, const nn::bluetooth::GattAttributeUuid& filterUuid) NN_NOEXCEPT;
        nn::Result LeClientConfigureMtu(std::uint32_t connId, std::uint16_t mtu) NN_NOEXCEPT;
        nn::Result RegisterLeServerImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
        nn::Result UnregisterLeServerImpl(std::uint8_t serverIf) NN_NOEXCEPT;
        nn::Result LeServerConnectImpl(std::uint8_t serverIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT;
        nn::Result LeServerDisconnectImpl(std::uint8_t serverIf, nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
        nn::Result CreateLeServiceImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& uuid, std::uint8_t handleNum, bool isPrimaryService) NN_NOEXCEPT;
        nn::Result StartLeServiceImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
        nn::Result AddLeCharacteristicImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& charUuid, std::uint16_t permissions, std::uint8_t properties) NN_NOEXCEPT;
        nn::Result AddLeDescriptorImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& descUuid, std::uint16_t permissions) NN_NOEXCEPT;
        nn::Result GetLeCoreEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
        nn::Result LeGetFirstCharacteristicImpl(nn::sf::Out<nn::bluetooth::GattId> charOut, nn::sf::Out<std::uint8_t> property, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattAttributeUuid& charFilter) NN_NOEXCEPT;
        nn::Result LeGetNextCharacteristicImpl(nn::sf::Out<nn::bluetooth::GattId> charOut, nn::sf::Out<std::uint8_t> property, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattAttributeUuid& charFilter) NN_NOEXCEPT;
        nn::Result LeGetFirstDescriptorImpl(nn::sf::Out<nn::bluetooth::GattId> descrOut, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattAttributeUuid& descrFilter) NN_NOEXCEPT;
        nn::Result LeGetNextDescriptorImpl(nn::sf::Out<nn::bluetooth::GattId> descrOut, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattId& descrIn, const nn::bluetooth::GattAttributeUuid& descrFilter) NN_NOEXCEPT;
        nn::Result RegisterLeCoreDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
        nn::Result UnregisterLeCoreDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
        nn::Result RegisterLeHidDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
        nn::Result UnregisterLeHidDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
        nn::Result RegisterLeDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
        nn::Result UnregisterLeDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
        nn::Result LeClientReadCharacteristicImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, std::uint8_t authType) NN_NOEXCEPT;
        nn::Result LeClientReadDescriptorImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, std::uint8_t authType) NN_NOEXCEPT;
        nn::Result LeClientWriteCharacteristicImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType, bool withResponse) NN_NOEXCEPT;
        nn::Result LeClientWriteDescriptorImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType) NN_NOEXCEPT;
        nn::Result LeClientRegisterNotificationImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT;
        nn::Result LeClientDeregisterNotificationImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT;
        nn::Result GetLeHidEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
        nn::Result RegisterBleHidEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
        nn::Result SetLeScanParameterImpl(std::uint16_t scanInterval, std::uint16_t scanWindow) NN_NOEXCEPT;
        bool GetIsManufacturingModeImpl() NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result WaitServerReady() NN_NOEXCEPT;
    nn::Result InitializeBluetoothImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result EnableBluetoothImpl() NN_NOEXCEPT;
    nn::Result DisableBluetoothImpl() NN_NOEXCEPT;
    nn::Result CleanupBluetoothImpl() NN_NOEXCEPT;
    nn::Result GetAdapterPropertiesImpl(nn::sf::Out<nn::bluetooth::AdapterProperty> pAdapterProperty) NN_NOEXCEPT;
    nn::Result GetAdapterPropertyImpl(nn::bluetooth::BluetoothPropertyType propertyType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
    nn::Result SetAdapterPropertyImpl(nn::bluetooth::BluetoothPropertyType propertyType, const nn::sf::InArray<std::uint8_t>& pInArray) NN_NOEXCEPT;
    nn::Result StartDiscoveryImpl() NN_NOEXCEPT;
    nn::Result CancelDiscoveryImpl() NN_NOEXCEPT;
    nn::Result CreateBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothTransport transport) NN_NOEXCEPT;
    nn::Result RemoveBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result CancelBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result PinReplyImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t accept, std::uint8_t pinLength, const nn::bluetooth::BluetoothPinCode& pinCode) NN_NOEXCEPT;
    nn::Result SspReplyImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t variant, std::uint8_t accept, std::uint32_t passkey) NN_NOEXCEPT;
    nn::Result GetEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
    nn::Result InitializeHidImpl(nn::sf::Out<nn::sf::NativeHandle> handle, std::uint16_t version) NN_NOEXCEPT;
    nn::Result HidConnectImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result HidDisconnectImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result HidSendDataByStructureImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::bluetooth::HidData& pData) NN_NOEXCEPT;
    nn::Result HidSendDataImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::sf::InArray<std::uint8_t>& pInArray) NN_NOEXCEPT;
    nn::Result HidSetReportImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothHhReportType reportType, const nn::bluetooth::HidData& pData) NN_NOEXCEPT;
    nn::Result HidGetReportImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothHhReportType reportType, std::uint8_t reportId) NN_NOEXCEPT;
    nn::Result HidWakeControllerImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result HidAddPairedDeviceImpl(const nn::settings::system::BluetoothDevicesSettings& deviceSettings) NN_NOEXCEPT;
    nn::Result HidGetPairedDeviceImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::sf::Out<nn::settings::system::BluetoothDevicesSettings> deviceSettings) NN_NOEXCEPT;
    nn::Result CleanupHidImpl() NN_NOEXCEPT;
    nn::Result HidGetEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
    nn::Result ExtSetTsiImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t tsiMode) NN_NOEXCEPT;
    nn::Result ExtSetBurstModeImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, bool isBurst) NN_NOEXCEPT;
    nn::Result ExtSetZeroRetranImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::sf::InArray<std::uint8_t>& pReportIds) NN_NOEXCEPT;
    nn::Result ExtSetMcModeImpl(bool isMcModeEnabled) NN_NOEXCEPT;
    nn::Result ExtStartLlrModeImpl() NN_NOEXCEPT;
    nn::Result ExtExitLlrModeImpl() NN_NOEXCEPT;
    nn::Result ExtSetRadioImpl(bool enable) NN_NOEXCEPT;
    nn::Result ExtSetVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT;
    nn::Result ExtSetTbfcScanImpl(bool enable) NN_NOEXCEPT;
    nn::Result RegisterHidReportEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result HidGetReportEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
    nn::Result GetLatestPlrImpl(nn::sf::Out<nn::bluetooth::PlrStatistics> pOut) NN_NOEXCEPT;
    nn::Result ExtGetPendingConnectionsImpl() NN_NOEXCEPT;
    nn::Result GetChannelMapImpl(nn::sf::Out<nn::bluetooth::ChannelMap> pOutChannelMap) NN_NOEXCEPT;
    nn::Result EnableBluetoothBoostSettingImpl(bool enable) NN_NOEXCEPT;
    nn::Result IsBluetoothBoostEnabledImpl(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
    nn::Result EnableBluetoothAfhSettingImpl(bool enable) NN_NOEXCEPT;
    nn::Result IsBluetoothAfhEnabledImpl(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
    nn::Result InitializeBleImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result EnableBleImpl() NN_NOEXCEPT;
    nn::Result DisableBleImpl() NN_NOEXCEPT;
    nn::Result CleanupBleImpl() NN_NOEXCEPT;
    nn::Result SetLeVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT;
    nn::Result SetLeConnectionParameterImpl(const nn::bluetooth::LeConnectionParams& connectionParams) NN_NOEXCEPT;
    nn::Result SetLeDefaultConnectionParameterImpl(const nn::bluetooth::LeConnectionParams& connectionParams) NN_NOEXCEPT;
    nn::Result SetLeAdvertiseDataImpl(const nn::bluetooth::LeAdvertiseData& advertiseData) NN_NOEXCEPT;
    nn::Result SetLeAdvertiseParameterImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint16_t minAdvInt, std::uint16_t maxAdvInt) NN_NOEXCEPT;
    nn::Result StartLeScanImpl() NN_NOEXCEPT;
    nn::Result StopLeScanImpl() NN_NOEXCEPT;
    nn::Result AddLeScanFilterConditionImpl(const nn::bluetooth::BleAdvertiseFilter& filter) NN_NOEXCEPT;
    nn::Result DeleteLeScanFilterConditionImpl(const nn::bluetooth::BleAdvertiseFilter& filter) NN_NOEXCEPT;
    nn::Result DeleteLeScanFilterImpl(std::uint8_t filterIndex) NN_NOEXCEPT;
    nn::Result ClearLeScanFiltersImpl() NN_NOEXCEPT;
    nn::Result EnableLeScanFilterImpl(bool enable) NN_NOEXCEPT;
    nn::Result RegisterLeClientImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    nn::Result UnregisterLeClientImpl(std::uint8_t clientIf) NN_NOEXCEPT;
    nn::Result UnregisterLeClientAllImpl() NN_NOEXCEPT;
    nn::Result LeClientConnectImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t clientIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT;
    nn::Result LeClientCancelConnectionImpl(std::uint8_t clientIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT;
    nn::Result LeClientDisconnectImpl(std::uint32_t connId) NN_NOEXCEPT;
    nn::Result LeClientGetAttributesImpl(std::uint32_t connId, nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result LeClientDiscoverServiceImpl(std::uint32_t connId, const nn::bluetooth::GattAttributeUuid& filterUuid) NN_NOEXCEPT;
    nn::Result LeClientConfigureMtu(std::uint32_t connId, std::uint16_t mtu) NN_NOEXCEPT;
    nn::Result RegisterLeServerImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    nn::Result UnregisterLeServerImpl(std::uint8_t serverIf) NN_NOEXCEPT;
    nn::Result LeServerConnectImpl(std::uint8_t serverIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT;
    nn::Result LeServerDisconnectImpl(std::uint8_t serverIf, nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result CreateLeServiceImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& uuid, std::uint8_t handleNum, bool isPrimaryService) NN_NOEXCEPT;
    nn::Result StartLeServiceImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    nn::Result AddLeCharacteristicImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& charUuid, std::uint16_t permissions, std::uint8_t properties) NN_NOEXCEPT;
    nn::Result AddLeDescriptorImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& descUuid, std::uint16_t permissions) NN_NOEXCEPT;
    nn::Result GetLeCoreEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
    nn::Result LeGetFirstCharacteristicImpl(nn::sf::Out<nn::bluetooth::GattId> charOut, nn::sf::Out<std::uint8_t> property, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattAttributeUuid& charFilter) NN_NOEXCEPT;
    nn::Result LeGetNextCharacteristicImpl(nn::sf::Out<nn::bluetooth::GattId> charOut, nn::sf::Out<std::uint8_t> property, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattAttributeUuid& charFilter) NN_NOEXCEPT;
    nn::Result LeGetFirstDescriptorImpl(nn::sf::Out<nn::bluetooth::GattId> descrOut, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattAttributeUuid& descrFilter) NN_NOEXCEPT;
    nn::Result LeGetNextDescriptorImpl(nn::sf::Out<nn::bluetooth::GattId> descrOut, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattId& descrIn, const nn::bluetooth::GattAttributeUuid& descrFilter) NN_NOEXCEPT;
    nn::Result RegisterLeCoreDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    nn::Result UnregisterLeCoreDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    nn::Result RegisterLeHidDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    nn::Result UnregisterLeHidDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    nn::Result RegisterLeDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    nn::Result UnregisterLeDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    nn::Result LeClientReadCharacteristicImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, std::uint8_t authType) NN_NOEXCEPT;
    nn::Result LeClientReadDescriptorImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, std::uint8_t authType) NN_NOEXCEPT;
    nn::Result LeClientWriteCharacteristicImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType, bool withResponse) NN_NOEXCEPT;
    nn::Result LeClientWriteDescriptorImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType) NN_NOEXCEPT;
    nn::Result LeClientRegisterNotificationImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT;
    nn::Result LeClientDeregisterNotificationImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT;
    nn::Result GetLeHidEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT;
    nn::Result RegisterBleHidEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result SetLeScanParameterImpl(std::uint16_t scanInterval, std::uint16_t scanWindow) NN_NOEXCEPT;
    bool GetIsManufacturingModeImpl() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::bluetooth::IBluetoothDriver))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(WaitServerReady)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(WaitServerReady);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeBluetoothImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializeBluetoothImpl, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableBluetoothImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EnableBluetoothImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableBluetoothImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DisableBluetoothImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CleanupBluetoothImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CleanupBluetoothImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAdapterPropertiesImpl, (::nn::sf::Out<::nn::bluetooth::AdapterProperty> pAdapterProperty))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAdapterPropertiesImpl, (pAdapterProperty));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAdapterPropertyImpl, (::nn::bluetooth::BluetoothPropertyType propertyType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAdapterPropertyImpl, (propertyType, pOutArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAdapterPropertyImpl, (::nn::bluetooth::BluetoothPropertyType propertyType, const ::nn::sf::InArray<::std::uint8_t>& pInArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAdapterPropertyImpl, (propertyType, pInArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartDiscoveryImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StartDiscoveryImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelDiscoveryImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelDiscoveryImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateBondImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothTransport transport))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateBondImpl, (bluetoothAddress, transport));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveBondImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RemoveBondImpl, (bluetoothAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelBondImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelBondImpl, (bluetoothAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PinReplyImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t accept, ::std::uint8_t pinLength, const ::nn::bluetooth::BluetoothPinCode& pinCode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PinReplyImpl, (bluetoothAddress, accept, pinLength, pinCode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SspReplyImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t variant, ::std::uint8_t accept, ::std::uint32_t passkey))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SspReplyImpl, (bluetoothAddress, variant, accept, passkey));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetEventInfoImpl, (pEventType, pOutArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeHidImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::std::uint16_t version))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializeHidImpl, (handle, version));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidConnectImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidConnectImpl, (bluetoothAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidDisconnectImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidDisconnectImpl, (bluetoothAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidSendDataByStructureImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::bluetooth::HidData& pData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidSendDataByStructureImpl, (bluetoothAddress, pData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidSendDataImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::sf::InArray<::std::uint8_t>& pInArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidSendDataImpl, (bluetoothAddress, pInArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidSetReportImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothHhReportType reportType, const ::nn::bluetooth::HidData& pData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidSetReportImpl, (bluetoothAddress, reportType, pData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidGetReportImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothHhReportType reportType, ::std::uint8_t reportId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidGetReportImpl, (bluetoothAddress, reportType, reportId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidWakeControllerImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidWakeControllerImpl, (bluetoothAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidAddPairedDeviceImpl, (const ::nn::settings::system::BluetoothDevicesSettings& deviceSettings))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidAddPairedDeviceImpl, (deviceSettings));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidGetPairedDeviceImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::sf::Out<::nn::settings::system::BluetoothDevicesSettings> deviceSettings))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidGetPairedDeviceImpl, (bluetoothAddress, deviceSettings));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CleanupHidImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CleanupHidImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidGetEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidGetEventInfoImpl, (pEventType, pOutArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetTsiImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t tsiMode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExtSetTsiImpl, (bluetoothAddress, tsiMode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetBurstModeImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isBurst))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExtSetBurstModeImpl, (bluetoothAddress, isBurst));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetZeroRetranImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::sf::InArray<::std::uint8_t>& pReportIds))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExtSetZeroRetranImpl, (bluetoothAddress, pReportIds));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetMcModeImpl, (bool isMcModeEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExtSetMcModeImpl, (isMcModeEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ExtStartLlrModeImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ExtStartLlrModeImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ExtExitLlrModeImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ExtExitLlrModeImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetRadioImpl, (bool enable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExtSetRadioImpl, (enable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetVisibilityImpl, (bool discoverable, bool connectable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExtSetVisibilityImpl, (discoverable, connectable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetTbfcScanImpl, (bool enable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ExtSetTbfcScanImpl, (enable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterHidReportEventImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterHidReportEventImpl, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidGetReportEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HidGetReportEventInfoImpl, (pEventType, pOutArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLatestPlrImpl, (::nn::sf::Out<::nn::bluetooth::PlrStatistics> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLatestPlrImpl, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ExtGetPendingConnectionsImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ExtGetPendingConnectionsImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChannelMapImpl, (::nn::sf::Out<::nn::bluetooth::ChannelMap> pOutChannelMap))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetChannelMapImpl, (pOutChannelMap));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableBluetoothBoostSettingImpl, (bool enable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnableBluetoothBoostSettingImpl, (enable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsBluetoothBoostEnabledImpl, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsBluetoothBoostEnabledImpl, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableBluetoothAfhSettingImpl, (bool enable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnableBluetoothAfhSettingImpl, (enable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsBluetoothAfhEnabledImpl, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsBluetoothAfhEnabledImpl, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeBleImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InitializeBleImpl, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableBleImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EnableBleImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableBleImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DisableBleImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CleanupBleImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CleanupBleImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeVisibilityImpl, (bool discoverable, bool connectable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLeVisibilityImpl, (discoverable, connectable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeConnectionParameterImpl, (const ::nn::bluetooth::LeConnectionParams& connectionParams))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLeConnectionParameterImpl, (connectionParams));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeDefaultConnectionParameterImpl, (const ::nn::bluetooth::LeConnectionParams& connectionParams))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLeDefaultConnectionParameterImpl, (connectionParams));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeAdvertiseDataImpl, (const ::nn::bluetooth::LeAdvertiseData& advertiseData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLeAdvertiseDataImpl, (advertiseData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeAdvertiseParameterImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint16_t minAdvInt, ::std::uint16_t maxAdvInt))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLeAdvertiseParameterImpl, (bluetoothAddress, minAdvInt, maxAdvInt));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartLeScanImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StartLeScanImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopLeScanImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopLeScanImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddLeScanFilterConditionImpl, (const ::nn::bluetooth::BleAdvertiseFilter& filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddLeScanFilterConditionImpl, (filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteLeScanFilterConditionImpl, (const ::nn::bluetooth::BleAdvertiseFilter& filter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteLeScanFilterConditionImpl, (filter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteLeScanFilterImpl, (::std::uint8_t filterIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteLeScanFilterImpl, (filterIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearLeScanFiltersImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearLeScanFiltersImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableLeScanFilterImpl, (bool enable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnableLeScanFilterImpl, (enable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeClientImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterLeClientImpl, (uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeClientImpl, (::std::uint8_t clientIf))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterLeClientImpl, (clientIf));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterLeClientAllImpl)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnregisterLeClientAllImpl);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientConnectImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint8_t clientIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientConnectImpl, (aruid, clientIf, bluetoothAddress, isDirect));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientCancelConnectionImpl, (::std::uint8_t clientIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientCancelConnectionImpl, (clientIf, bluetoothAddress, isDirect));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDisconnectImpl, (::std::uint32_t connId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientDisconnectImpl, (connId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientGetAttributesImpl, (::std::uint32_t connId, ::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientGetAttributesImpl, (connId, bluetoothAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDiscoverServiceImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattAttributeUuid& filterUuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientDiscoverServiceImpl, (connId, filterUuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientConfigureMtu, (::std::uint32_t connId, ::std::uint16_t mtu))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientConfigureMtu, (connId, mtu));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeServerImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterLeServerImpl, (uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeServerImpl, (::std::uint8_t serverIf))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterLeServerImpl, (serverIf));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeServerConnectImpl, (::std::uint8_t serverIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeServerConnectImpl, (serverIf, bluetoothAddress, isDirect));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeServerDisconnectImpl, (::std::uint8_t serverIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeServerDisconnectImpl, (serverIf, bluetoothAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateLeServiceImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& uuid, ::std::uint8_t handleNum, bool isPrimaryService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateLeServiceImpl, (serverIf, uuid, handleNum, isPrimaryService));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartLeServiceImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartLeServiceImpl, (serverIf, uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddLeCharacteristicImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& charUuid, ::std::uint16_t permissions, ::std::uint8_t properties))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddLeCharacteristicImpl, (serverIf, serviceUuid, charUuid, permissions, properties));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddLeDescriptorImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& descUuid, ::std::uint16_t permissions))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddLeDescriptorImpl, (serverIf, serviceUuid, descUuid, permissions));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLeCoreEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLeCoreEventInfoImpl, (pEventType, pOutArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeGetFirstCharacteristicImpl, (::nn::sf::Out<::nn::bluetooth::GattId> charOut, ::nn::sf::Out<::std::uint8_t> property, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattAttributeUuid& charFilter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeGetFirstCharacteristicImpl, (charOut, property, connId, serviceId, isPrimary, charFilter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeGetNextCharacteristicImpl, (::nn::sf::Out<::nn::bluetooth::GattId> charOut, ::nn::sf::Out<::std::uint8_t> property, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattAttributeUuid& charFilter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeGetNextCharacteristicImpl, (charOut, property, connId, serviceId, isPrimary, charIn, charFilter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeGetFirstDescriptorImpl, (::nn::sf::Out<::nn::bluetooth::GattId> descrOut, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattAttributeUuid& descrFilter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeGetFirstDescriptorImpl, (descrOut, connId, serviceId, isPrimary, charIn, descrFilter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeGetNextDescriptorImpl, (::nn::sf::Out<::nn::bluetooth::GattId> descrOut, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattId& descrIn, const ::nn::bluetooth::GattAttributeUuid& descrFilter))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeGetNextDescriptorImpl, (descrOut, connId, serviceId, isPrimary, charIn, descrIn, descrFilter));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeCoreDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterLeCoreDataPathImpl, (uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeCoreDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterLeCoreDataPathImpl, (uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeHidDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterLeHidDataPathImpl, (uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeHidDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterLeHidDataPathImpl, (uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterLeDataPathImpl, (uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterLeDataPathImpl, (uuid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadCharacteristicImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, ::std::uint8_t authType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientReadCharacteristicImpl, (connId, serviceId, isPrimary, charId, authType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadDescriptorImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, ::std::uint8_t authType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientReadDescriptorImpl, (connId, serviceId, isPrimary, charId, descrId, authType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteCharacteristicImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType, bool withResponse))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientWriteCharacteristicImpl, (connId, serviceId, isPrimary, charId, pData, authType, withResponse));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteDescriptorImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientWriteDescriptorImpl, (connId, serviceId, isPrimary, charId, descrId, pData, authType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientRegisterNotificationImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientRegisterNotificationImpl, (connId, serviceId, isPrimary, charId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDeregisterNotificationImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientDeregisterNotificationImpl, (connId, serviceId, isPrimary, charId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLeHidEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLeHidEventInfoImpl, (pEventType, pOutArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleHidEventImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterBleHidEventImpl, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeScanParameterImpl, (::std::uint16_t scanInterval, ::std::uint16_t scanWindow))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLeScanParameterImpl, (scanInterval, scanWindow));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetIsManufacturingModeImpl, (bool))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(GetIsManufacturingModeImpl, (bool));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::bluetooth::IBluetoothDriver>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::bluetooth::IBluetoothDriver))

    // nn::Result WaitServerReady() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WaitServerReady)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WaitServerReady)

    // nn::Result InitializeBluetoothImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeBluetoothImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeBluetoothImpl)

    // nn::Result EnableBluetoothImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableBluetoothImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableBluetoothImpl)

    // nn::Result DisableBluetoothImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableBluetoothImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableBluetoothImpl)

    // nn::Result CleanupBluetoothImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CleanupBluetoothImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CleanupBluetoothImpl)

    // nn::Result GetAdapterPropertiesImpl(nn::sf::Out<nn::bluetooth::AdapterProperty> pAdapterProperty) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAdapterPropertiesImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pAdapterProperty, 0, (::nn::sf::Out<::nn::bluetooth::AdapterProperty>), 259, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pAdapterProperty))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pAdapterProperty)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAdapterPropertiesImpl)

    // nn::Result GetAdapterPropertyImpl(nn::bluetooth::BluetoothPropertyType propertyType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAdapterPropertyImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutArray, 0, (const ::nn::sf::OutArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(propertyType, (::nn::bluetooth::BluetoothPropertyType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (propertyType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(propertyType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAdapterPropertyImpl)

    // nn::Result SetAdapterPropertyImpl(nn::bluetooth::BluetoothPropertyType propertyType, const nn::sf::InArray<std::uint8_t>& pInArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAdapterPropertyImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pInArray, 0, (const ::nn::sf::InArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pInArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(propertyType, (::nn::bluetooth::BluetoothPropertyType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (propertyType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(propertyType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pInArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAdapterPropertyImpl)

    // nn::Result StartDiscoveryImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartDiscoveryImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartDiscoveryImpl)

    // nn::Result CancelDiscoveryImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelDiscoveryImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelDiscoveryImpl)

    // nn::Result CreateBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothTransport transport) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateBondImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(transport, 0, (::nn::bluetooth::BluetoothTransport), 4, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (transport))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bluetoothAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transport)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateBondImpl)

    // nn::Result RemoveBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RemoveBondImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bluetoothAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RemoveBondImpl)

    // nn::Result CancelBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelBondImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bluetoothAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelBondImpl)

    // nn::Result PinReplyImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t accept, std::uint8_t pinLength, const nn::bluetooth::BluetoothPinCode& pinCode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PinReplyImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accept, (::std::uint8_t), 6)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pinLength, (::std::uint8_t), 7)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pinCode, (::nn::bluetooth::BluetoothPinCode), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (bluetoothAddress, accept, pinLength, pinCode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accept), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pinLength), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pinCode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PinReplyImpl)

    // nn::Result SspReplyImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t variant, std::uint8_t accept, std::uint32_t passkey) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SspReplyImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(variant, (::std::uint8_t), 6)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accept, (::std::uint8_t), 7)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(passkey, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (bluetoothAddress, variant, accept, passkey))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(variant), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accept), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(passkey)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SspReplyImpl)

    // nn::Result GetEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetEventInfoImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutArray, 0, (const ::nn::sf::OutArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pEventType, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pEventType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEventType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetEventInfoImpl)

    // nn::Result InitializeHidImpl(nn::sf::Out<nn::sf::NativeHandle> handle, std::uint16_t version) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeHidImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (version))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeHidImpl)

    // nn::Result HidConnectImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidConnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bluetoothAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidConnectImpl)

    // nn::Result HidDisconnectImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidDisconnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bluetoothAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidDisconnectImpl)

    // nn::Result HidSendDataByStructureImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::bluetooth::HidData& pData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidSendDataByStructureImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pData, 0, (const ::nn::bluetooth::HidData&), 642, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bluetoothAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidSendDataByStructureImpl)

    // nn::Result HidSendDataImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::sf::InArray<std::uint8_t>& pInArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidSendDataImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pInArray, 0, (const ::nn::sf::InArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pInArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bluetoothAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pInArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidSendDataImpl)

    // nn::Result HidSetReportImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothHhReportType reportType, const nn::bluetooth::HidData& pData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidSetReportImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pData, 0, (const ::nn::bluetooth::HidData&), 642, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(reportType, (::nn::bluetooth::BluetoothHhReportType), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bluetoothAddress, reportType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(reportType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidSetReportImpl)

    // nn::Result HidGetReportImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothHhReportType reportType, std::uint8_t reportId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidGetReportImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(reportId, (::std::uint8_t), 6)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(reportType, (::nn::bluetooth::BluetoothHhReportType), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (bluetoothAddress, reportId, reportType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(reportType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(reportId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidGetReportImpl)

    // nn::Result HidWakeControllerImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidWakeControllerImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bluetoothAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidWakeControllerImpl)

    // nn::Result HidAddPairedDeviceImpl(const nn::settings::system::BluetoothDevicesSettings& deviceSettings) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidAddPairedDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(deviceSettings, 0, (const ::nn::settings::system::BluetoothDevicesSettings&), 512, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (deviceSettings))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceSettings)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidAddPairedDeviceImpl)

    // nn::Result HidGetPairedDeviceImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::sf::Out<nn::settings::system::BluetoothDevicesSettings> deviceSettings) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidGetPairedDeviceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(deviceSettings, 0, (::nn::sf::Out<::nn::settings::system::BluetoothDevicesSettings>), 512, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (deviceSettings))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bluetoothAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(deviceSettings)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidGetPairedDeviceImpl)

    // nn::Result CleanupHidImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CleanupHidImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CleanupHidImpl)

    // nn::Result HidGetEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidGetEventInfoImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutArray, 0, (const ::nn::sf::OutArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pEventType, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pEventType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEventType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidGetEventInfoImpl)

    // nn::Result ExtSetTsiImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t tsiMode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExtSetTsiImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(tsiMode, (::std::uint8_t), 6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bluetoothAddress, tsiMode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(7)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(tsiMode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExtSetTsiImpl)

    // nn::Result ExtSetBurstModeImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, bool isBurst) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExtSetBurstModeImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(29)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isBurst, (bool), 6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bluetoothAddress, isBurst))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(7)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isBurst)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExtSetBurstModeImpl)

    // nn::Result ExtSetZeroRetranImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::sf::InArray<std::uint8_t>& pReportIds) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExtSetZeroRetranImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pReportIds, 0, (const ::nn::sf::InArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pReportIds))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bluetoothAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pReportIds)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExtSetZeroRetranImpl)

    // nn::Result ExtSetMcModeImpl(bool isMcModeEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExtSetMcModeImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isMcModeEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isMcModeEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isMcModeEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExtSetMcModeImpl)

    // nn::Result ExtStartLlrModeImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExtStartLlrModeImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExtStartLlrModeImpl)

    // nn::Result ExtExitLlrModeImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExtExitLlrModeImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(33)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExtExitLlrModeImpl)

    // nn::Result ExtSetRadioImpl(bool enable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExtSetRadioImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(34)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (enable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExtSetRadioImpl)

    // nn::Result ExtSetVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExtSetVisibilityImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(discoverable, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectable, (bool), 1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (discoverable, connectable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(discoverable), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExtSetVisibilityImpl)

    // nn::Result ExtSetTbfcScanImpl(bool enable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExtSetTbfcScanImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(36)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (enable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExtSetTbfcScanImpl)

    // nn::Result RegisterHidReportEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterHidReportEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(37)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterHidReportEventImpl)

    // nn::Result HidGetReportEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HidGetReportEventInfoImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(38)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutArray, 0, (const ::nn::sf::OutArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pEventType, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pEventType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEventType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HidGetReportEventInfoImpl)

    // nn::Result GetLatestPlrImpl(nn::sf::Out<nn::bluetooth::PlrStatistics> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLatestPlrImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(39)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOut, 0, (::nn::sf::Out<::nn::bluetooth::PlrStatistics>), 132, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLatestPlrImpl)

    // nn::Result ExtGetPendingConnectionsImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ExtGetPendingConnectionsImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ExtGetPendingConnectionsImpl)

    // nn::Result GetChannelMapImpl(nn::sf::Out<nn::bluetooth::ChannelMap> pOutChannelMap) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetChannelMapImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(41)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutChannelMap, 0, (::nn::sf::Out<::nn::bluetooth::ChannelMap>), 136, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutChannelMap))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutChannelMap)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetChannelMapImpl)

    // nn::Result EnableBluetoothBoostSettingImpl(bool enable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableBluetoothBoostSettingImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(42)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (enable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableBluetoothBoostSettingImpl)

    // nn::Result IsBluetoothBoostEnabledImpl(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsBluetoothBoostEnabledImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(43)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsBluetoothBoostEnabledImpl)

    // nn::Result EnableBluetoothAfhSettingImpl(bool enable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableBluetoothAfhSettingImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(44)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (enable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableBluetoothAfhSettingImpl)

    // nn::Result IsBluetoothAfhEnabledImpl(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsBluetoothAfhEnabledImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(45)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsBluetoothAfhEnabledImpl)

    // nn::Result InitializeBleImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeBleImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(46)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeBleImpl)

    // nn::Result EnableBleImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableBleImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(47)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableBleImpl)

    // nn::Result DisableBleImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableBleImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableBleImpl)

    // nn::Result CleanupBleImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CleanupBleImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(49)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CleanupBleImpl)

    // nn::Result SetLeVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLeVisibilityImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(50)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(discoverable, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectable, (bool), 1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (discoverable, connectable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(discoverable), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLeVisibilityImpl)

    // nn::Result SetLeConnectionParameterImpl(const nn::bluetooth::LeConnectionParams& connectionParams) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLeConnectionParameterImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(51)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionParams, (::nn::bluetooth::LeConnectionParams), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (connectionParams))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionParams)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLeConnectionParameterImpl)

    // nn::Result SetLeDefaultConnectionParameterImpl(const nn::bluetooth::LeConnectionParams& connectionParams) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLeDefaultConnectionParameterImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(52)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connectionParams, (::nn::bluetooth::LeConnectionParams), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (connectionParams))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connectionParams)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLeDefaultConnectionParameterImpl)

    // nn::Result SetLeAdvertiseDataImpl(const nn::bluetooth::LeAdvertiseData& advertiseData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLeAdvertiseDataImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(53)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(advertiseData, 0, (const ::nn::bluetooth::LeAdvertiseData&), 204, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (advertiseData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(advertiseData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLeAdvertiseDataImpl)

    // nn::Result SetLeAdvertiseParameterImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint16_t minAdvInt, std::uint16_t maxAdvInt) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLeAdvertiseParameterImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(54)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(minAdvInt, (::std::uint16_t), 6)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxAdvInt, (::std::uint16_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (bluetoothAddress, minAdvInt, maxAdvInt))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(10)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(minAdvInt), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxAdvInt)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLeAdvertiseParameterImpl)

    // nn::Result StartLeScanImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartLeScanImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(55)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartLeScanImpl)

    // nn::Result StopLeScanImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopLeScanImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopLeScanImpl)

    // nn::Result AddLeScanFilterConditionImpl(const nn::bluetooth::BleAdvertiseFilter& filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddLeScanFilterConditionImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(57)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(filter, 0, (const ::nn::bluetooth::BleAdvertiseFilter&), 62, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (filter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddLeScanFilterConditionImpl)

    // nn::Result DeleteLeScanFilterConditionImpl(const nn::bluetooth::BleAdvertiseFilter& filter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteLeScanFilterConditionImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(58)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(filter, 0, (const ::nn::bluetooth::BleAdvertiseFilter&), 62, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (filter))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteLeScanFilterConditionImpl)

    // nn::Result DeleteLeScanFilterImpl(std::uint8_t filterIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteLeScanFilterImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(59)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filterIndex, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (filterIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filterIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteLeScanFilterImpl)

    // nn::Result ClearLeScanFiltersImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearLeScanFiltersImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(60)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearLeScanFiltersImpl)

    // nn::Result EnableLeScanFilterImpl(bool enable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableLeScanFilterImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(61)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (enable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableLeScanFilterImpl)

    // nn::Result RegisterLeClientImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterLeClientImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(62)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterLeClientImpl)

    // nn::Result UnregisterLeClientImpl(std::uint8_t clientIf) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterLeClientImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(63)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clientIf, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (clientIf))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientIf)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterLeClientImpl)

    // nn::Result UnregisterLeClientAllImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterLeClientAllImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(64)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterLeClientAllImpl)

    // nn::Result LeClientConnectImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t clientIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientConnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(65)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clientIf, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isDirect, (bool), 7)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (clientIf, bluetoothAddress, isDirect, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientIf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isDirect)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientConnectImpl)

    // nn::Result LeClientCancelConnectionImpl(std::uint8_t clientIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientCancelConnectionImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(66)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clientIf, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isDirect, (bool), 7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (clientIf, bluetoothAddress, isDirect))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientIf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isDirect)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientCancelConnectionImpl)

    // nn::Result LeClientDisconnectImpl(std::uint32_t connId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientDisconnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(67)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (connId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientDisconnectImpl)

    // nn::Result LeClientGetAttributesImpl(std::uint32_t connId, nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientGetAttributesImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(68)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bluetoothAddress, connId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientGetAttributesImpl)

    // nn::Result LeClientDiscoverServiceImpl(std::uint32_t connId, const nn::bluetooth::GattAttributeUuid& filterUuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientDiscoverServiceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(69)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(filterUuid, (::nn::bluetooth::GattAttributeUuid), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (connId, filterUuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(filterUuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientDiscoverServiceImpl)

    // nn::Result LeClientConfigureMtu(std::uint32_t connId, std::uint16_t mtu) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientConfigureMtu)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(70)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mtu, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (mtu, connId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mtu)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientConfigureMtu)

    // nn::Result RegisterLeServerImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterLeServerImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(71)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterLeServerImpl)

    // nn::Result UnregisterLeServerImpl(std::uint8_t serverIf) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterLeServerImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(72)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serverIf, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (serverIf))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serverIf)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterLeServerImpl)

    // nn::Result LeServerConnectImpl(std::uint8_t serverIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeServerConnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(73)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serverIf, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isDirect, (bool), 7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (serverIf, bluetoothAddress, isDirect))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serverIf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isDirect)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeServerConnectImpl)

    // nn::Result LeServerDisconnectImpl(std::uint8_t serverIf, nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeServerDisconnectImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(74)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serverIf, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bluetoothAddress, (::nn::bluetooth::BluetoothAddress), 1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (serverIf, bluetoothAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(7)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serverIf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bluetoothAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeServerDisconnectImpl)

    // nn::Result CreateLeServiceImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& uuid, std::uint8_t handleNum, bool isPrimaryService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateLeServiceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(75)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serverIf, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handleNum, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimaryService, (bool), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (serverIf, handleNum, isPrimaryService, uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serverIf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handleNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimaryService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateLeServiceImpl)

    // nn::Result StartLeServiceImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartLeServiceImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(76)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serverIf, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (serverIf, uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serverIf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartLeServiceImpl)

    // nn::Result AddLeCharacteristicImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& charUuid, std::uint16_t permissions, std::uint8_t properties) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddLeCharacteristicImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(77)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serverIf, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(properties, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(permissions, (::std::uint16_t), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceUuid, (::nn::bluetooth::GattAttributeUuid), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charUuid, (::nn::bluetooth::GattAttributeUuid), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (serverIf, properties, permissions, serviceUuid, charUuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(44)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serverIf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceUuid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charUuid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(permissions), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(properties)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddLeCharacteristicImpl)

    // nn::Result AddLeDescriptorImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& descUuid, std::uint16_t permissions) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddLeDescriptorImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(78)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serverIf, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(permissions, (::std::uint16_t), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceUuid, (::nn::bluetooth::GattAttributeUuid), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descUuid, (::nn::bluetooth::GattAttributeUuid), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (serverIf, permissions, serviceUuid, descUuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(44)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serverIf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceUuid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descUuid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(permissions)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddLeDescriptorImpl)

    // nn::Result GetLeCoreEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLeCoreEventInfoImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(79)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutArray, 0, (const ::nn::sf::OutArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pEventType, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pEventType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEventType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLeCoreEventInfoImpl)

    // nn::Result LeGetFirstCharacteristicImpl(nn::sf::Out<nn::bluetooth::GattId> charOut, nn::sf::Out<std::uint8_t> property, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattAttributeUuid& charFilter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeGetFirstCharacteristicImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charFilter, (::nn::bluetooth::GattAttributeUuid), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (isPrimary, connId, serviceId, charFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(52)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(property, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(charOut, (::nn::bluetooth::GattId), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (property, charOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(28)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(property), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charFilter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeGetFirstCharacteristicImpl)

    // nn::Result LeGetNextCharacteristicImpl(nn::sf::Out<nn::bluetooth::GattId> charOut, nn::sf::Out<std::uint8_t> property, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattAttributeUuid& charFilter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeGetNextCharacteristicImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(81)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charIn, (::nn::bluetooth::GattId), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charFilter, (::nn::bluetooth::GattAttributeUuid), 56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (isPrimary, connId, serviceId, charIn, charFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(76)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(property, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(charOut, (::nn::bluetooth::GattId), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (property, charOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(28)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(property), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charFilter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeGetNextCharacteristicImpl)

    // nn::Result LeGetFirstDescriptorImpl(nn::sf::Out<nn::bluetooth::GattId> descrOut, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattAttributeUuid& descrFilter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeGetFirstDescriptorImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(82)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charIn, (::nn::bluetooth::GattId), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descrFilter, (::nn::bluetooth::GattAttributeUuid), 56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (isPrimary, connId, serviceId, charIn, descrFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(76)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(descrOut, (::nn::bluetooth::GattId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (descrOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descrOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descrFilter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeGetFirstDescriptorImpl)

    // nn::Result LeGetNextDescriptorImpl(nn::sf::Out<nn::bluetooth::GattId> descrOut, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattId& descrIn, const nn::bluetooth::GattAttributeUuid& descrFilter) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeGetNextDescriptorImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(83)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charIn, (::nn::bluetooth::GattId), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descrIn, (::nn::bluetooth::GattId), 56)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descrFilter, (::nn::bluetooth::GattAttributeUuid), 80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (isPrimary, connId, serviceId, charIn, descrIn, descrFilter))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(100)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(descrOut, (::nn::bluetooth::GattId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (descrOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descrOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descrIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descrFilter)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeGetNextDescriptorImpl)

    // nn::Result RegisterLeCoreDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterLeCoreDataPathImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(84)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterLeCoreDataPathImpl)

    // nn::Result UnregisterLeCoreDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterLeCoreDataPathImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(85)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterLeCoreDataPathImpl)

    // nn::Result RegisterLeHidDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterLeHidDataPathImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(86)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterLeHidDataPathImpl)

    // nn::Result UnregisterLeHidDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterLeHidDataPathImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(87)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterLeHidDataPathImpl)

    // nn::Result RegisterLeDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterLeDataPathImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(88)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterLeDataPathImpl)

    // nn::Result UnregisterLeDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterLeDataPathImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(89)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uuid, (::nn::bluetooth::GattAttributeUuid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uuid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uuid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterLeDataPathImpl)

    // nn::Result LeClientReadCharacteristicImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientReadCharacteristicImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(90)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(authType, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (isPrimary, authType, connId, serviceId, charId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(authType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientReadCharacteristicImpl)

    // nn::Result LeClientReadDescriptorImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientReadDescriptorImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(91)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(authType, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descrId, (::nn::bluetooth::GattId), 56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (isPrimary, authType, connId, serviceId, charId, descrId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descrId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(authType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientReadDescriptorImpl)

    // nn::Result LeClientWriteCharacteristicImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType, bool withResponse) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientWriteCharacteristicImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(92)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pData, 0, (const ::nn::sf::InArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(authType, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(withResponse, (bool), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (isPrimary, authType, withResponse, connId, serviceId, charId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(authType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(withResponse)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientWriteCharacteristicImpl)

    // nn::Result LeClientWriteDescriptorImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientWriteDescriptorImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(93)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pData, 0, (const ::nn::sf::InArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(authType, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descrId, (::nn::bluetooth::GattId), 56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (isPrimary, authType, connId, serviceId, charId, descrId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(80)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descrId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(authType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientWriteDescriptorImpl)

    // nn::Result LeClientRegisterNotificationImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientRegisterNotificationImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(94)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (isPrimary, connId, serviceId, charId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientRegisterNotificationImpl)

    // nn::Result LeClientDeregisterNotificationImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientDeregisterNotificationImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(95)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (isPrimary, connId, serviceId, charId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientDeregisterNotificationImpl)

    // nn::Result GetLeHidEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLeHidEventInfoImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(96)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutArray, 0, (const ::nn::sf::OutArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pEventType, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pEventType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEventType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLeHidEventInfoImpl)

    // nn::Result RegisterBleHidEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterBleHidEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(97)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterBleHidEventImpl)

    // nn::Result SetLeScanParameterImpl(std::uint16_t scanInterval, std::uint16_t scanWindow) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLeScanParameterImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(98)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(scanInterval, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(scanWindow, (::std::uint16_t), 2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (scanInterval, scanWindow))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(scanInterval), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(scanWindow)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLeScanParameterImpl)

    // bool GetIsManufacturingModeImpl() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetIsManufacturingModeImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(256)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetIsManufacturingModeImpl)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::AdapterProperty), 259, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::BluetoothPropertyType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::BluetoothAddress), 6, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::BluetoothTransport), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::BluetoothPinCode), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::HidData), 642, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::BluetoothHhReportType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::settings::system::BluetoothDevicesSettings), 512, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::PlrStatistics), 132, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::ChannelMap), 136, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::LeConnectionParams), 20, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::LeAdvertiseData), 204, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::BleAdvertiseFilter), 62, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::GattAttributeUuid), 20, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::GattId), 24, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::bluetooth::IBluetoothDriver, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::bluetooth::IBluetoothDriver))

    // nn::Result WaitServerReady() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(WaitServerReady)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WaitServerReady)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WaitServerReady)
    }

    // nn::Result InitializeBluetoothImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeBluetoothImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeBluetoothImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeBluetoothImpl)
    }

    // nn::Result EnableBluetoothImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableBluetoothImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableBluetoothImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableBluetoothImpl)
    }

    // nn::Result DisableBluetoothImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableBluetoothImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableBluetoothImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableBluetoothImpl)
    }

    // nn::Result CleanupBluetoothImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CleanupBluetoothImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CleanupBluetoothImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CleanupBluetoothImpl)
    }

    // nn::Result GetAdapterPropertiesImpl(nn::sf::Out<nn::bluetooth::AdapterProperty> pAdapterProperty) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAdapterPropertiesImpl, (::nn::sf::Out<::nn::bluetooth::AdapterProperty> pAdapterProperty))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAdapterPropertiesImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pAdapterProperty)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAdapterPropertiesImpl)
    }

    // nn::Result GetAdapterPropertyImpl(nn::bluetooth::BluetoothPropertyType propertyType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAdapterPropertyImpl, (::nn::bluetooth::BluetoothPropertyType propertyType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAdapterPropertyImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(propertyType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAdapterPropertyImpl)
    }

    // nn::Result SetAdapterPropertyImpl(nn::bluetooth::BluetoothPropertyType propertyType, const nn::sf::InArray<std::uint8_t>& pInArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAdapterPropertyImpl, (::nn::bluetooth::BluetoothPropertyType propertyType, const ::nn::sf::InArray<::std::uint8_t>& pInArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAdapterPropertyImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(propertyType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pInArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAdapterPropertyImpl)
    }

    // nn::Result StartDiscoveryImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartDiscoveryImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartDiscoveryImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartDiscoveryImpl)
    }

    // nn::Result CancelDiscoveryImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelDiscoveryImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelDiscoveryImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelDiscoveryImpl)
    }

    // nn::Result CreateBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothTransport transport) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateBondImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothTransport transport))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateBondImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transport)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateBondImpl)
    }

    // nn::Result RemoveBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveBondImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RemoveBondImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RemoveBondImpl)
    }

    // nn::Result CancelBondImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelBondImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelBondImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelBondImpl)
    }

    // nn::Result PinReplyImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t accept, std::uint8_t pinLength, const nn::bluetooth::BluetoothPinCode& pinCode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PinReplyImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t accept, ::std::uint8_t pinLength, const ::nn::bluetooth::BluetoothPinCode& pinCode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PinReplyImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accept)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pinLength)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pinCode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PinReplyImpl)
    }

    // nn::Result SspReplyImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t variant, std::uint8_t accept, std::uint32_t passkey) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SspReplyImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t variant, ::std::uint8_t accept, ::std::uint32_t passkey))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SspReplyImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(variant)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accept)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(passkey)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SspReplyImpl)
    }

    // nn::Result GetEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetEventInfoImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEventType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetEventInfoImpl)
    }

    // nn::Result InitializeHidImpl(nn::sf::Out<nn::sf::NativeHandle> handle, std::uint16_t version) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeHidImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::std::uint16_t version))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeHidImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeHidImpl)
    }

    // nn::Result HidConnectImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidConnectImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidConnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidConnectImpl)
    }

    // nn::Result HidDisconnectImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidDisconnectImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidDisconnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidDisconnectImpl)
    }

    // nn::Result HidSendDataByStructureImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::bluetooth::HidData& pData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidSendDataByStructureImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::bluetooth::HidData& pData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidSendDataByStructureImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidSendDataByStructureImpl)
    }

    // nn::Result HidSendDataImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::sf::InArray<std::uint8_t>& pInArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidSendDataImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::sf::InArray<::std::uint8_t>& pInArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidSendDataImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pInArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidSendDataImpl)
    }

    // nn::Result HidSetReportImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothHhReportType reportType, const nn::bluetooth::HidData& pData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidSetReportImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothHhReportType reportType, const ::nn::bluetooth::HidData& pData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidSetReportImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(reportType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidSetReportImpl)
    }

    // nn::Result HidGetReportImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::bluetooth::BluetoothHhReportType reportType, std::uint8_t reportId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidGetReportImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::bluetooth::BluetoothHhReportType reportType, ::std::uint8_t reportId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidGetReportImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(reportType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(reportId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidGetReportImpl)
    }

    // nn::Result HidWakeControllerImpl(nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidWakeControllerImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidWakeControllerImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidWakeControllerImpl)
    }

    // nn::Result HidAddPairedDeviceImpl(const nn::settings::system::BluetoothDevicesSettings& deviceSettings) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidAddPairedDeviceImpl, (const ::nn::settings::system::BluetoothDevicesSettings& deviceSettings))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidAddPairedDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceSettings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidAddPairedDeviceImpl)
    }

    // nn::Result HidGetPairedDeviceImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, nn::sf::Out<nn::settings::system::BluetoothDevicesSettings> deviceSettings) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidGetPairedDeviceImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::nn::sf::Out<::nn::settings::system::BluetoothDevicesSettings> deviceSettings))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidGetPairedDeviceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(deviceSettings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidGetPairedDeviceImpl)
    }

    // nn::Result CleanupHidImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CleanupHidImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CleanupHidImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CleanupHidImpl)
    }

    // nn::Result HidGetEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidGetEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidGetEventInfoImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEventType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidGetEventInfoImpl)
    }

    // nn::Result ExtSetTsiImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint8_t tsiMode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetTsiImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint8_t tsiMode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExtSetTsiImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(tsiMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExtSetTsiImpl)
    }

    // nn::Result ExtSetBurstModeImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, bool isBurst) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetBurstModeImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isBurst))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExtSetBurstModeImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isBurst)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExtSetBurstModeImpl)
    }

    // nn::Result ExtSetZeroRetranImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, const nn::sf::InArray<std::uint8_t>& pReportIds) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetZeroRetranImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, const ::nn::sf::InArray<::std::uint8_t>& pReportIds))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExtSetZeroRetranImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pReportIds)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExtSetZeroRetranImpl)
    }

    // nn::Result ExtSetMcModeImpl(bool isMcModeEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetMcModeImpl, (bool isMcModeEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExtSetMcModeImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isMcModeEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExtSetMcModeImpl)
    }

    // nn::Result ExtStartLlrModeImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ExtStartLlrModeImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExtStartLlrModeImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExtStartLlrModeImpl)
    }

    // nn::Result ExtExitLlrModeImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ExtExitLlrModeImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExtExitLlrModeImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExtExitLlrModeImpl)
    }

    // nn::Result ExtSetRadioImpl(bool enable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetRadioImpl, (bool enable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExtSetRadioImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExtSetRadioImpl)
    }

    // nn::Result ExtSetVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetVisibilityImpl, (bool discoverable, bool connectable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExtSetVisibilityImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(discoverable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExtSetVisibilityImpl)
    }

    // nn::Result ExtSetTbfcScanImpl(bool enable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ExtSetTbfcScanImpl, (bool enable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExtSetTbfcScanImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExtSetTbfcScanImpl)
    }

    // nn::Result RegisterHidReportEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterHidReportEventImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterHidReportEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterHidReportEventImpl)
    }

    // nn::Result HidGetReportEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HidGetReportEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HidGetReportEventInfoImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEventType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HidGetReportEventInfoImpl)
    }

    // nn::Result GetLatestPlrImpl(nn::sf::Out<nn::bluetooth::PlrStatistics> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLatestPlrImpl, (::nn::sf::Out<::nn::bluetooth::PlrStatistics> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLatestPlrImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLatestPlrImpl)
    }

    // nn::Result ExtGetPendingConnectionsImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ExtGetPendingConnectionsImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ExtGetPendingConnectionsImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ExtGetPendingConnectionsImpl)
    }

    // nn::Result GetChannelMapImpl(nn::sf::Out<nn::bluetooth::ChannelMap> pOutChannelMap) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChannelMapImpl, (::nn::sf::Out<::nn::bluetooth::ChannelMap> pOutChannelMap))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetChannelMapImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutChannelMap)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetChannelMapImpl)
    }

    // nn::Result EnableBluetoothBoostSettingImpl(bool enable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableBluetoothBoostSettingImpl, (bool enable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableBluetoothBoostSettingImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableBluetoothBoostSettingImpl)
    }

    // nn::Result IsBluetoothBoostEnabledImpl(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsBluetoothBoostEnabledImpl, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsBluetoothBoostEnabledImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsBluetoothBoostEnabledImpl)
    }

    // nn::Result EnableBluetoothAfhSettingImpl(bool enable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableBluetoothAfhSettingImpl, (bool enable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableBluetoothAfhSettingImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableBluetoothAfhSettingImpl)
    }

    // nn::Result IsBluetoothAfhEnabledImpl(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsBluetoothAfhEnabledImpl, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsBluetoothAfhEnabledImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsBluetoothAfhEnabledImpl)
    }

    // nn::Result InitializeBleImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InitializeBleImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeBleImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeBleImpl)
    }

    // nn::Result EnableBleImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableBleImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableBleImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableBleImpl)
    }

    // nn::Result DisableBleImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DisableBleImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableBleImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableBleImpl)
    }

    // nn::Result CleanupBleImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CleanupBleImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CleanupBleImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CleanupBleImpl)
    }

    // nn::Result SetLeVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeVisibilityImpl, (bool discoverable, bool connectable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLeVisibilityImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(discoverable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLeVisibilityImpl)
    }

    // nn::Result SetLeConnectionParameterImpl(const nn::bluetooth::LeConnectionParams& connectionParams) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeConnectionParameterImpl, (const ::nn::bluetooth::LeConnectionParams& connectionParams))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLeConnectionParameterImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionParams)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLeConnectionParameterImpl)
    }

    // nn::Result SetLeDefaultConnectionParameterImpl(const nn::bluetooth::LeConnectionParams& connectionParams) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeDefaultConnectionParameterImpl, (const ::nn::bluetooth::LeConnectionParams& connectionParams))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLeDefaultConnectionParameterImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connectionParams)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLeDefaultConnectionParameterImpl)
    }

    // nn::Result SetLeAdvertiseDataImpl(const nn::bluetooth::LeAdvertiseData& advertiseData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeAdvertiseDataImpl, (const ::nn::bluetooth::LeAdvertiseData& advertiseData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLeAdvertiseDataImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(advertiseData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLeAdvertiseDataImpl)
    }

    // nn::Result SetLeAdvertiseParameterImpl(nn::bluetooth::BluetoothAddress bluetoothAddress, std::uint16_t minAdvInt, std::uint16_t maxAdvInt) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeAdvertiseParameterImpl, (::nn::bluetooth::BluetoothAddress bluetoothAddress, ::std::uint16_t minAdvInt, ::std::uint16_t maxAdvInt))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLeAdvertiseParameterImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(minAdvInt)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxAdvInt)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLeAdvertiseParameterImpl)
    }

    // nn::Result StartLeScanImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartLeScanImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartLeScanImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartLeScanImpl)
    }

    // nn::Result StopLeScanImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopLeScanImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopLeScanImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopLeScanImpl)
    }

    // nn::Result AddLeScanFilterConditionImpl(const nn::bluetooth::BleAdvertiseFilter& filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddLeScanFilterConditionImpl, (const ::nn::bluetooth::BleAdvertiseFilter& filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddLeScanFilterConditionImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddLeScanFilterConditionImpl)
    }

    // nn::Result DeleteLeScanFilterConditionImpl(const nn::bluetooth::BleAdvertiseFilter& filter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteLeScanFilterConditionImpl, (const ::nn::bluetooth::BleAdvertiseFilter& filter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteLeScanFilterConditionImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteLeScanFilterConditionImpl)
    }

    // nn::Result DeleteLeScanFilterImpl(std::uint8_t filterIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteLeScanFilterImpl, (::std::uint8_t filterIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteLeScanFilterImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filterIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteLeScanFilterImpl)
    }

    // nn::Result ClearLeScanFiltersImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearLeScanFiltersImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearLeScanFiltersImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearLeScanFiltersImpl)
    }

    // nn::Result EnableLeScanFilterImpl(bool enable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableLeScanFilterImpl, (bool enable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableLeScanFilterImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableLeScanFilterImpl)
    }

    // nn::Result RegisterLeClientImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeClientImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterLeClientImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterLeClientImpl)
    }

    // nn::Result UnregisterLeClientImpl(std::uint8_t clientIf) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeClientImpl, (::std::uint8_t clientIf))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterLeClientImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientIf)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterLeClientImpl)
    }

    // nn::Result UnregisterLeClientAllImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterLeClientAllImpl)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterLeClientAllImpl)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterLeClientAllImpl)
    }

    // nn::Result LeClientConnectImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t clientIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientConnectImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint8_t clientIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientConnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientIf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isDirect)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientConnectImpl)
    }

    // nn::Result LeClientCancelConnectionImpl(std::uint8_t clientIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientCancelConnectionImpl, (::std::uint8_t clientIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientCancelConnectionImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientIf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isDirect)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientCancelConnectionImpl)
    }

    // nn::Result LeClientDisconnectImpl(std::uint32_t connId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDisconnectImpl, (::std::uint32_t connId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientDisconnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientDisconnectImpl)
    }

    // nn::Result LeClientGetAttributesImpl(std::uint32_t connId, nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientGetAttributesImpl, (::std::uint32_t connId, ::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientGetAttributesImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientGetAttributesImpl)
    }

    // nn::Result LeClientDiscoverServiceImpl(std::uint32_t connId, const nn::bluetooth::GattAttributeUuid& filterUuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDiscoverServiceImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattAttributeUuid& filterUuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientDiscoverServiceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(filterUuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientDiscoverServiceImpl)
    }

    // nn::Result LeClientConfigureMtu(std::uint32_t connId, std::uint16_t mtu) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientConfigureMtu, (::std::uint32_t connId, ::std::uint16_t mtu))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientConfigureMtu)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mtu)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientConfigureMtu)
    }

    // nn::Result RegisterLeServerImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeServerImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterLeServerImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterLeServerImpl)
    }

    // nn::Result UnregisterLeServerImpl(std::uint8_t serverIf) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeServerImpl, (::std::uint8_t serverIf))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterLeServerImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serverIf)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterLeServerImpl)
    }

    // nn::Result LeServerConnectImpl(std::uint8_t serverIf, nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeServerConnectImpl, (::std::uint8_t serverIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress, bool isDirect))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeServerConnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serverIf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isDirect)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeServerConnectImpl)
    }

    // nn::Result LeServerDisconnectImpl(std::uint8_t serverIf, nn::bluetooth::BluetoothAddress bluetoothAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeServerDisconnectImpl, (::std::uint8_t serverIf, ::nn::bluetooth::BluetoothAddress bluetoothAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeServerDisconnectImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serverIf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bluetoothAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeServerDisconnectImpl)
    }

    // nn::Result CreateLeServiceImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& uuid, std::uint8_t handleNum, bool isPrimaryService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateLeServiceImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& uuid, ::std::uint8_t handleNum, bool isPrimaryService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateLeServiceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serverIf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handleNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimaryService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateLeServiceImpl)
    }

    // nn::Result StartLeServiceImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartLeServiceImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartLeServiceImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serverIf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartLeServiceImpl)
    }

    // nn::Result AddLeCharacteristicImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& charUuid, std::uint16_t permissions, std::uint8_t properties) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddLeCharacteristicImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& charUuid, ::std::uint16_t permissions, ::std::uint8_t properties))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddLeCharacteristicImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serverIf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceUuid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charUuid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(permissions)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(properties)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddLeCharacteristicImpl)
    }

    // nn::Result AddLeDescriptorImpl(std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& descUuid, std::uint16_t permissions) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddLeDescriptorImpl, (::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& descUuid, ::std::uint16_t permissions))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddLeDescriptorImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serverIf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceUuid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descUuid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(permissions)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddLeDescriptorImpl)
    }

    // nn::Result GetLeCoreEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLeCoreEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLeCoreEventInfoImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEventType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLeCoreEventInfoImpl)
    }

    // nn::Result LeGetFirstCharacteristicImpl(nn::sf::Out<nn::bluetooth::GattId> charOut, nn::sf::Out<std::uint8_t> property, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattAttributeUuid& charFilter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeGetFirstCharacteristicImpl, (::nn::sf::Out<::nn::bluetooth::GattId> charOut, ::nn::sf::Out<::std::uint8_t> property, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattAttributeUuid& charFilter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeGetFirstCharacteristicImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(property)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charFilter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeGetFirstCharacteristicImpl)
    }

    // nn::Result LeGetNextCharacteristicImpl(nn::sf::Out<nn::bluetooth::GattId> charOut, nn::sf::Out<std::uint8_t> property, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattAttributeUuid& charFilter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeGetNextCharacteristicImpl, (::nn::sf::Out<::nn::bluetooth::GattId> charOut, ::nn::sf::Out<::std::uint8_t> property, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattAttributeUuid& charFilter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeGetNextCharacteristicImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(property)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charFilter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeGetNextCharacteristicImpl)
    }

    // nn::Result LeGetFirstDescriptorImpl(nn::sf::Out<nn::bluetooth::GattId> descrOut, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattAttributeUuid& descrFilter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeGetFirstDescriptorImpl, (::nn::sf::Out<::nn::bluetooth::GattId> descrOut, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattAttributeUuid& descrFilter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeGetFirstDescriptorImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descrOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descrFilter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeGetFirstDescriptorImpl)
    }

    // nn::Result LeGetNextDescriptorImpl(nn::sf::Out<nn::bluetooth::GattId> descrOut, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charIn, const nn::bluetooth::GattId& descrIn, const nn::bluetooth::GattAttributeUuid& descrFilter) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeGetNextDescriptorImpl, (::nn::sf::Out<::nn::bluetooth::GattId> descrOut, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charIn, const ::nn::bluetooth::GattId& descrIn, const ::nn::bluetooth::GattAttributeUuid& descrFilter))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeGetNextDescriptorImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descrOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descrIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descrFilter)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeGetNextDescriptorImpl)
    }

    // nn::Result RegisterLeCoreDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeCoreDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterLeCoreDataPathImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterLeCoreDataPathImpl)
    }

    // nn::Result UnregisterLeCoreDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeCoreDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterLeCoreDataPathImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterLeCoreDataPathImpl)
    }

    // nn::Result RegisterLeHidDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeHidDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterLeHidDataPathImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterLeHidDataPathImpl)
    }

    // nn::Result UnregisterLeHidDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeHidDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterLeHidDataPathImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterLeHidDataPathImpl)
    }

    // nn::Result RegisterLeDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterLeDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterLeDataPathImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterLeDataPathImpl)
    }

    // nn::Result UnregisterLeDataPathImpl(const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterLeDataPathImpl, (const ::nn::bluetooth::GattAttributeUuid& uuid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterLeDataPathImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uuid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterLeDataPathImpl)
    }

    // nn::Result LeClientReadCharacteristicImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadCharacteristicImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, ::std::uint8_t authType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientReadCharacteristicImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(authType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientReadCharacteristicImpl)
    }

    // nn::Result LeClientReadDescriptorImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadDescriptorImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, ::std::uint8_t authType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientReadDescriptorImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descrId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(authType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientReadDescriptorImpl)
    }

    // nn::Result LeClientWriteCharacteristicImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType, bool withResponse) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteCharacteristicImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType, bool withResponse))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientWriteCharacteristicImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(authType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(withResponse)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientWriteCharacteristicImpl)
    }

    // nn::Result LeClientWriteDescriptorImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteDescriptorImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientWriteDescriptorImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descrId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(authType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientWriteDescriptorImpl)
    }

    // nn::Result LeClientRegisterNotificationImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientRegisterNotificationImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientRegisterNotificationImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientRegisterNotificationImpl)
    }

    // nn::Result LeClientDeregisterNotificationImpl(std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDeregisterNotificationImpl, (::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientDeregisterNotificationImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientDeregisterNotificationImpl)
    }

    // nn::Result GetLeHidEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLeHidEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLeHidEventInfoImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEventType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLeHidEventInfoImpl)
    }

    // nn::Result RegisterBleHidEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleHidEventImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterBleHidEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterBleHidEventImpl)
    }

    // nn::Result SetLeScanParameterImpl(std::uint16_t scanInterval, std::uint16_t scanWindow) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeScanParameterImpl, (::std::uint16_t scanInterval, ::std::uint16_t scanWindow))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLeScanParameterImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(scanInterval)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(scanWindow)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLeScanParameterImpl)
    }

    // bool GetIsManufacturingModeImpl() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(GetIsManufacturingModeImpl, (bool))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetIsManufacturingModeImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetIsManufacturingModeImpl)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::bluetooth::IBluetoothDriver>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::bluetooth::IBluetoothDriver))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WaitServerReady)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WaitServerReady)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeBluetoothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeBluetoothImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableBluetoothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableBluetoothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableBluetoothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableBluetoothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CleanupBluetoothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CleanupBluetoothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAdapterPropertiesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pAdapterProperty)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAdapterPropertiesImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pAdapterProperty)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAdapterPropertyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAdapterPropertyImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(propertyType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAdapterPropertyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pInArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAdapterPropertyImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(propertyType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pInArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateBondImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(transport)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateBondImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(transport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RemoveBondImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RemoveBondImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelBondImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelBondImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PinReplyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PinReplyImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accept),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pinLength),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pinCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SspReplyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SspReplyImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(variant),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accept),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(passkey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetEventInfoImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pEventType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeHidImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeHidImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidConnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidDisconnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidSendDataByStructureImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidSendDataByStructureImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidSendDataImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pInArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidSendDataImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pInArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidSetReportImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidSetReportImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(reportType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidGetReportImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidGetReportImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(reportType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(reportId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidWakeControllerImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidWakeControllerImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidAddPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(deviceSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidAddPairedDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(deviceSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidGetPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(deviceSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidGetPairedDeviceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(deviceSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CleanupHidImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CleanupHidImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidGetEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidGetEventInfoImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pEventType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExtSetTsiImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExtSetTsiImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(tsiMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExtSetBurstModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExtSetBurstModeImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isBurst)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExtSetZeroRetranImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pReportIds)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExtSetZeroRetranImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pReportIds)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExtSetMcModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExtSetMcModeImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isMcModeEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExtStartLlrModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExtStartLlrModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExtExitLlrModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExtExitLlrModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExtSetRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExtSetRadioImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExtSetVisibilityImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExtSetVisibilityImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(discoverable),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExtSetTbfcScanImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExtSetTbfcScanImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterHidReportEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterHidReportEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HidGetReportEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HidGetReportEventInfoImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pEventType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLatestPlrImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLatestPlrImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ExtGetPendingConnectionsImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ExtGetPendingConnectionsImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetChannelMapImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutChannelMap)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetChannelMapImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutChannelMap)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableBluetoothBoostSettingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableBluetoothBoostSettingImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsBluetoothBoostEnabledImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsBluetoothBoostEnabledImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableBluetoothAfhSettingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableBluetoothAfhSettingImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsBluetoothAfhEnabledImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsBluetoothAfhEnabledImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeBleImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeBleImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableBleImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableBleImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableBleImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableBleImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CleanupBleImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CleanupBleImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLeVisibilityImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLeVisibilityImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(discoverable),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLeConnectionParameterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLeConnectionParameterImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionParams)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLeDefaultConnectionParameterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLeDefaultConnectionParameterImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connectionParams)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLeAdvertiseDataImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(advertiseData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLeAdvertiseDataImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(advertiseData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLeAdvertiseParameterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLeAdvertiseParameterImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(minAdvInt),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxAdvInt)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartLeScanImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartLeScanImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopLeScanImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopLeScanImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddLeScanFilterConditionImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(filter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddLeScanFilterConditionImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteLeScanFilterConditionImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(filter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteLeScanFilterConditionImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(filter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteLeScanFilterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteLeScanFilterImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filterIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearLeScanFiltersImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearLeScanFiltersImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableLeScanFilterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableLeScanFilterImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterLeClientImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterLeClientImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterLeClientImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterLeClientImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clientIf)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterLeClientAllImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterLeClientAllImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientConnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clientIf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isDirect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientCancelConnectionImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientCancelConnectionImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clientIf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isDirect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientDisconnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientGetAttributesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientGetAttributesImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientDiscoverServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientDiscoverServiceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(filterUuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientConfigureMtu)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientConfigureMtu)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mtu)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterLeServerImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterLeServerImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterLeServerImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterLeServerImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serverIf)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeServerConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeServerConnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serverIf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isDirect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeServerDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeServerDisconnectImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serverIf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bluetoothAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateLeServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateLeServiceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serverIf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handleNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimaryService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartLeServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartLeServiceImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serverIf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddLeCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddLeCharacteristicImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serverIf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceUuid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charUuid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(permissions),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(properties)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddLeDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddLeDescriptorImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serverIf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceUuid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descUuid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(permissions)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLeCoreEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLeCoreEventInfoImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pEventType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeGetFirstCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeGetFirstCharacteristicImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(charOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(property),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeGetNextCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeGetNextCharacteristicImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(charOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(property),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeGetFirstDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeGetFirstDescriptorImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(descrOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descrFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeGetNextDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeGetNextDescriptorImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(descrOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descrIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descrFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterLeCoreDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterLeCoreDataPathImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterLeCoreDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterLeCoreDataPathImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterLeHidDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterLeHidDataPathImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterLeHidDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterLeHidDataPathImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterLeDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterLeDataPathImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterLeDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterLeDataPathImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uuid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientReadCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientReadCharacteristicImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(authType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientReadDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientReadDescriptorImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descrId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(authType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientWriteCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientWriteCharacteristicImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(authType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(withResponse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientWriteDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientWriteDescriptorImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descrId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(authType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientRegisterNotificationImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientRegisterNotificationImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientDeregisterNotificationImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientDeregisterNotificationImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLeHidEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLeHidEventInfoImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pEventType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterBleHidEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterBleHidEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLeScanParameterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLeScanParameterImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(scanInterval),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(scanWindow)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetIsManufacturingModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetIsManufacturingModeImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WaitServerReady)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeBluetoothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableBluetoothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableBluetoothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CleanupBluetoothImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAdapterPropertiesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAdapterPropertyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAdapterPropertyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelDiscoveryImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateBondImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RemoveBondImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelBondImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PinReplyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SspReplyImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeHidImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidSendDataByStructureImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidSendDataImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidSetReportImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidGetReportImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidWakeControllerImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidAddPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidGetPairedDeviceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CleanupHidImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidGetEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExtSetTsiImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExtSetBurstModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExtSetZeroRetranImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExtSetMcModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExtStartLlrModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExtExitLlrModeImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExtSetRadioImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExtSetVisibilityImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExtSetTbfcScanImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterHidReportEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HidGetReportEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLatestPlrImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ExtGetPendingConnectionsImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetChannelMapImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableBluetoothBoostSettingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsBluetoothBoostEnabledImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableBluetoothAfhSettingImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsBluetoothAfhEnabledImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeBleImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableBleImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableBleImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CleanupBleImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLeVisibilityImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLeConnectionParameterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLeDefaultConnectionParameterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLeAdvertiseDataImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLeAdvertiseParameterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartLeScanImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopLeScanImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddLeScanFilterConditionImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteLeScanFilterConditionImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteLeScanFilterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearLeScanFiltersImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableLeScanFilterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterLeClientImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterLeClientImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterLeClientAllImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientCancelConnectionImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientGetAttributesImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientDiscoverServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientConfigureMtu)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterLeServerImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterLeServerImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeServerConnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeServerDisconnectImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateLeServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartLeServiceImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddLeCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddLeDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLeCoreEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeGetFirstCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeGetNextCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeGetFirstDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeGetNextDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterLeCoreDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterLeCoreDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterLeHidDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterLeHidDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterLeDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterLeDataPathImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientReadCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientReadDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientWriteCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientWriteDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientRegisterNotificationImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientDeregisterNotificationImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLeHidEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterBleHidEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLeScanParameterImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetIsManufacturingModeImpl)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::bluetooth::IBluetoothDriver))

namespace nn { namespace bluetooth { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IBluetoothUser, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IBluetoothUser)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadCharacteristicImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, ::std::uint8_t authType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadDescriptorImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, ::std::uint8_t authType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteCharacteristicImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType, bool withResponse))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteDescriptorImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientRegisterNotificationImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDeregisterNotificationImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetLeResponseImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& attrUuid, const ::nn::sf::InArray<::std::uint8_t>& pData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LeSendIndicationImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& charUuid, const ::nn::sf::InArray<::std::uint8_t>& pData, bool confirm))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLeEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray, ::nn::applet::AppletResourceUserId aruid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleEventImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::applet::AppletResourceUserId aruid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IBluetoothUser)

        ::nn::Result LeClientReadCharacteristicImpl(::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, ::std::uint8_t authType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientReadCharacteristicImpl, (aruid, connId, serviceId, isPrimary, charId, authType));
        }

        ::nn::Result LeClientReadDescriptorImpl(::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, ::std::uint8_t authType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientReadDescriptorImpl, (aruid, connId, serviceId, isPrimary, charId, descrId, authType));
        }

        ::nn::Result LeClientWriteCharacteristicImpl(::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType, bool withResponse) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientWriteCharacteristicImpl, (aruid, connId, serviceId, isPrimary, charId, pData, authType, withResponse));
        }

        ::nn::Result LeClientWriteDescriptorImpl(::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientWriteDescriptorImpl, (aruid, connId, serviceId, isPrimary, charId, descrId, pData, authType));
        }

        ::nn::Result LeClientRegisterNotificationImpl(::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientRegisterNotificationImpl, (aruid, connId, serviceId, isPrimary, charId));
        }

        ::nn::Result LeClientDeregisterNotificationImpl(::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeClientDeregisterNotificationImpl, (aruid, connId, serviceId, isPrimary, charId));
        }

        ::nn::Result SetLeResponseImpl(::nn::applet::AppletResourceUserId aruid, ::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& attrUuid, const ::nn::sf::InArray<::std::uint8_t>& pData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetLeResponseImpl, (aruid, serverIf, serviceUuid, attrUuid, pData));
        }

        ::nn::Result LeSendIndicationImpl(::nn::applet::AppletResourceUserId aruid, ::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& charUuid, const ::nn::sf::InArray<::std::uint8_t>& pData, bool confirm) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LeSendIndicationImpl, (aruid, serverIf, serviceUuid, charUuid, pData, confirm));
        }

        ::nn::Result GetLeEventInfoImpl(::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLeEventInfoImpl, (pEventType, pOutArray, aruid));
        }

        ::nn::Result RegisterBleEventImpl(::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterBleEventImpl, (handle, aruid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IBluetoothUser
    {
    public:
        nn::Result LeClientReadCharacteristicImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, std::uint8_t authType) NN_NOEXCEPT;
        nn::Result LeClientReadDescriptorImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, std::uint8_t authType) NN_NOEXCEPT;
        nn::Result LeClientWriteCharacteristicImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType, bool withResponse) NN_NOEXCEPT;
        nn::Result LeClientWriteDescriptorImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType) NN_NOEXCEPT;
        nn::Result LeClientRegisterNotificationImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT;
        nn::Result LeClientDeregisterNotificationImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT;
        nn::Result SetLeResponseImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& attrUuid, const nn::sf::InArray<std::uint8_t>& pData) NN_NOEXCEPT;
        nn::Result LeSendIndicationImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& charUuid, const nn::sf::InArray<std::uint8_t>& pData, bool confirm) NN_NOEXCEPT;
        nn::Result GetLeEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result RegisterBleEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result LeClientReadCharacteristicImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, std::uint8_t authType) NN_NOEXCEPT;
    nn::Result LeClientReadDescriptorImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, std::uint8_t authType) NN_NOEXCEPT;
    nn::Result LeClientWriteCharacteristicImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType, bool withResponse) NN_NOEXCEPT;
    nn::Result LeClientWriteDescriptorImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType) NN_NOEXCEPT;
    nn::Result LeClientRegisterNotificationImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT;
    nn::Result LeClientDeregisterNotificationImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT;
    nn::Result SetLeResponseImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& attrUuid, const nn::sf::InArray<std::uint8_t>& pData) NN_NOEXCEPT;
    nn::Result LeSendIndicationImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& charUuid, const nn::sf::InArray<std::uint8_t>& pData, bool confirm) NN_NOEXCEPT;
    nn::Result GetLeEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    nn::Result RegisterBleEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::bluetooth::IBluetoothUser))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadCharacteristicImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, ::std::uint8_t authType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientReadCharacteristicImpl, (aruid, connId, serviceId, isPrimary, charId, authType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadDescriptorImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, ::std::uint8_t authType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientReadDescriptorImpl, (aruid, connId, serviceId, isPrimary, charId, descrId, authType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteCharacteristicImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType, bool withResponse))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientWriteCharacteristicImpl, (aruid, connId, serviceId, isPrimary, charId, pData, authType, withResponse));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteDescriptorImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientWriteDescriptorImpl, (aruid, connId, serviceId, isPrimary, charId, descrId, pData, authType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientRegisterNotificationImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientRegisterNotificationImpl, (aruid, connId, serviceId, isPrimary, charId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDeregisterNotificationImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeClientDeregisterNotificationImpl, (aruid, connId, serviceId, isPrimary, charId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeResponseImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& attrUuid, const ::nn::sf::InArray<::std::uint8_t>& pData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetLeResponseImpl, (aruid, serverIf, serviceUuid, attrUuid, pData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeSendIndicationImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& charUuid, const ::nn::sf::InArray<::std::uint8_t>& pData, bool confirm))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LeSendIndicationImpl, (aruid, serverIf, serviceUuid, charUuid, pData, confirm));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLeEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLeEventInfoImpl, (pEventType, pOutArray, aruid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleEventImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterBleEventImpl, (handle, aruid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::bluetooth::IBluetoothUser>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::bluetooth::IBluetoothUser))

    // nn::Result LeClientReadCharacteristicImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientReadCharacteristicImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(authType, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (isPrimary, authType, connId, serviceId, charId, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(authType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientReadCharacteristicImpl)

    // nn::Result LeClientReadDescriptorImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientReadDescriptorImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(authType, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descrId, (::nn::bluetooth::GattId), 56)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(7, (isPrimary, authType, connId, serviceId, charId, descrId, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(88)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descrId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(authType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientReadDescriptorImpl)

    // nn::Result LeClientWriteCharacteristicImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType, bool withResponse) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientWriteCharacteristicImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pData, 0, (const ::nn::sf::InArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(authType, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(withResponse, (bool), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(7, (isPrimary, authType, withResponse, connId, serviceId, charId, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(authType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(withResponse)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientWriteCharacteristicImpl)

    // nn::Result LeClientWriteDescriptorImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientWriteDescriptorImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pData, 0, (const ::nn::sf::InArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(authType, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(descrId, (::nn::bluetooth::GattId), 56)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(7, (isPrimary, authType, connId, serviceId, charId, descrId, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(88)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(descrId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(authType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientWriteDescriptorImpl)

    // nn::Result LeClientRegisterNotificationImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientRegisterNotificationImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (isPrimary, connId, serviceId, charId, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientRegisterNotificationImpl)

    // nn::Result LeClientDeregisterNotificationImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeClientDeregisterNotificationImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isPrimary, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(connId, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceId, (::nn::bluetooth::GattId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charId, (::nn::bluetooth::GattId), 32)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (isPrimary, connId, serviceId, charId, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(connId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isPrimary), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeClientDeregisterNotificationImpl)

    // nn::Result SetLeResponseImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& attrUuid, const nn::sf::InArray<std::uint8_t>& pData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetLeResponseImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pData, 0, (const ::nn::sf::InArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serverIf, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceUuid, (::nn::bluetooth::GattAttributeUuid), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attrUuid, (::nn::bluetooth::GattAttributeUuid), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (serverIf, serviceUuid, attrUuid, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serverIf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceUuid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attrUuid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetLeResponseImpl)

    // nn::Result LeSendIndicationImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& charUuid, const nn::sf::InArray<std::uint8_t>& pData, bool confirm) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LeSendIndicationImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pData, 0, (const ::nn::sf::InArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serverIf, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(confirm, (bool), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serviceUuid, (::nn::bluetooth::GattAttributeUuid), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(charUuid, (::nn::bluetooth::GattAttributeUuid), 24)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (serverIf, confirm, serviceUuid, charUuid, aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(56)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serverIf), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceUuid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(charUuid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(confirm)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LeSendIndicationImpl)

    // nn::Result GetLeEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLeEventInfoImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutArray, 0, (const ::nn::sf::OutArray<::std::uint8_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pEventType, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pEventType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEventType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLeEventInfoImpl)

    // nn::Result RegisterBleEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterBleEventImpl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(handle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (handle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(aruid, (::nn::applet::AppletResourceUserId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (aruid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(aruid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterBleEventImpl)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::applet::AppletResourceUserId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::GattId), 24, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::bluetooth::GattAttributeUuid), 20, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::bluetooth::IBluetoothUser, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::bluetooth::IBluetoothUser))

    // nn::Result LeClientReadCharacteristicImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadCharacteristicImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, ::std::uint8_t authType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientReadCharacteristicImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(authType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientReadCharacteristicImpl)
    }

    // nn::Result LeClientReadDescriptorImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientReadDescriptorImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, ::std::uint8_t authType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientReadDescriptorImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descrId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(authType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientReadDescriptorImpl)
    }

    // nn::Result LeClientWriteCharacteristicImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType, bool withResponse) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteCharacteristicImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType, bool withResponse))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientWriteCharacteristicImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(authType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(withResponse)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientWriteCharacteristicImpl)
    }

    // nn::Result LeClientWriteDescriptorImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId, const nn::bluetooth::GattId& descrId, const nn::sf::InArray<std::uint8_t>& pData, std::uint8_t authType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientWriteDescriptorImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId, const ::nn::bluetooth::GattId& descrId, const ::nn::sf::InArray<::std::uint8_t>& pData, ::std::uint8_t authType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientWriteDescriptorImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(descrId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(authType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientWriteDescriptorImpl)
    }

    // nn::Result LeClientRegisterNotificationImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientRegisterNotificationImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientRegisterNotificationImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientRegisterNotificationImpl)
    }

    // nn::Result LeClientDeregisterNotificationImpl(nn::applet::AppletResourceUserId aruid, std::uint32_t connId, const nn::bluetooth::GattId& serviceId, bool isPrimary, const nn::bluetooth::GattId& charId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeClientDeregisterNotificationImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint32_t connId, const ::nn::bluetooth::GattId& serviceId, bool isPrimary, const ::nn::bluetooth::GattId& charId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeClientDeregisterNotificationImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(connId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isPrimary)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeClientDeregisterNotificationImpl)
    }

    // nn::Result SetLeResponseImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& attrUuid, const nn::sf::InArray<std::uint8_t>& pData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetLeResponseImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& attrUuid, const ::nn::sf::InArray<::std::uint8_t>& pData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetLeResponseImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serverIf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceUuid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attrUuid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetLeResponseImpl)
    }

    // nn::Result LeSendIndicationImpl(nn::applet::AppletResourceUserId aruid, std::uint8_t serverIf, const nn::bluetooth::GattAttributeUuid& serviceUuid, const nn::bluetooth::GattAttributeUuid& charUuid, const nn::sf::InArray<std::uint8_t>& pData, bool confirm) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LeSendIndicationImpl, (::nn::applet::AppletResourceUserId aruid, ::std::uint8_t serverIf, const ::nn::bluetooth::GattAttributeUuid& serviceUuid, const ::nn::bluetooth::GattAttributeUuid& charUuid, const ::nn::sf::InArray<::std::uint8_t>& pData, bool confirm))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LeSendIndicationImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serverIf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceUuid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(charUuid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(confirm)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LeSendIndicationImpl)
    }

    // nn::Result GetLeEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& pOutArray, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLeEventInfoImpl, (::nn::sf::Out<::std::uint32_t> pEventType, const ::nn::sf::OutArray<::std::uint8_t>& pOutArray, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLeEventInfoImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEventType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLeEventInfoImpl)
    }

    // nn::Result RegisterBleEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterBleEventImpl, (::nn::sf::Out<::nn::sf::NativeHandle> handle, ::nn::applet::AppletResourceUserId aruid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterBleEventImpl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(aruid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterBleEventImpl)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::bluetooth::IBluetoothUser>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::bluetooth::IBluetoothUser))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientReadCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientReadCharacteristicImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(authType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientReadDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientReadDescriptorImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descrId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(authType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientWriteCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientWriteCharacteristicImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(authType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(withResponse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientWriteDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientWriteDescriptorImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(descrId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(authType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientRegisterNotificationImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientRegisterNotificationImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeClientDeregisterNotificationImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeClientDeregisterNotificationImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(connId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isPrimary),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetLeResponseImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetLeResponseImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serverIf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceUuid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attrUuid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LeSendIndicationImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LeSendIndicationImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serverIf),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serviceUuid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(charUuid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(confirm)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLeEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLeEventInfoImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pEventType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterBleEventImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(handle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_APPLY_PROCESS_ID(_, CheckAppletResourceUserId(_processId, _), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterBleEventImpl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(aruid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientReadCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientReadDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientWriteCharacteristicImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientWriteDescriptorImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientRegisterNotificationImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeClientDeregisterNotificationImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetLeResponseImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LeSendIndicationImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLeEventInfoImpl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterBleEventImpl)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::bluetooth::IBluetoothUser))
