﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/service/bcat_Common.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace core {

/*!
    @brief      ID の発行モジュールです。

    @details
                システムの生存期間中被らない ID を発行します。
*/
class IdIssuer
{
private:
    NN_DISALLOW_COPY(IdIssuer);
    NN_DISALLOW_MOVE(IdIssuer);

private:
    /*!
        @brief      コンストラクタです。
    */
    IdIssuer() NN_NOEXCEPT :
        m_Counter(0)
    {
    }

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static IdIssuer& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(IdIssuer, s_Instance);
        return s_Instance;
    }

public:
    /*!
        @brief      タスク ID を発行します。

        @return     タスク ID。
    */
    TaskId IssueTaskId() NN_NOEXCEPT
    {
        TaskId id = {++m_Counter};
        return id;
    }

    /*!
        @brief      セッション ID を発行します。

        @return     セッション ID。
    */
    SessionId IssueSessionId() NN_NOEXCEPT
    {
        SessionId id = {++m_Counter};
        return id;
    }

private:
    //
    std::atomic<uint64_t> m_Counter;
};

}}}}}
