﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace core {

/*!
    @brief      ブロックサイズです。
*/
const int64_t BlockSize = 16 * 1024;

/*!
    @brief      システム情報ストレージのサイズです。

    @details
                - タスクデータ
                -- bcat-sys:/dc/task.bin
                -- 2KB
                - 実行中アプリケーション情報
                -- bcat-sys:/dc/running.app
                -- 8B

                合計：2 blocks: 32KB

                設定値：256 blocks: 4096KB (reserved 254 blocks: 4064KB)
*/
const int64_t SystemStorageSize = 256 * BlockSize;

/*!
    @brief      システム情報ストレージのジャーナルサイズです。

    @details
                設定値：48 blocks: 768KB
*/
const int64_t SystemStorageJournalSize = 48 * BlockSize;

/*!
    @brief      ダウンロードストレージのサイズです。

    @details
                設定値：4352 blocks: 68MB
*/
const int64_t DownloadStorageSize = 4352 * BlockSize;

/*!
    @brief      ダウンロードストレージのジャーナルサイズです。

    @details
                設定値：768 blocks: 12MB
*/
const int64_t DownloadStorageJournalSize = 768 * BlockSize;

}}}}}
