﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/bcat/detail/service/bcat_Common.h>
#include <nn/bcat/detail/service/bcat_ServiceHeap.h>
#include <nn/bcat/detail/ipc/bcat_ServiceConfig.h>

namespace nn { namespace bcat { namespace detail { namespace service {

/*!
    @brief      サービスのメモリ管理モジュールです。
*/
class ServiceMemoryManager
{
public:
    /*!
        @brief      BcatService に割り当てるバッファサイズです。
    */
    static const size_t BcatServiceSize = 128;

    /*!
        @brief      BcatService のヒープサイズです。
    */
    static const size_t BcatServiceHeapSize = BcatServiceSize * detail::ipc::BcatServiceCountMax;

    /*!
        @brief      DeliveryCacheStorageService に割り当てるバッファサイズです。
    */
    static const size_t DeliveryCacheStorageServiceSize = 128;

    /*!
        @brief      DeliveryCacheStorageService のヒープサイズです。
    */
    static const size_t DeliveryCacheStorageServiceHeapSize = DeliveryCacheStorageServiceSize * detail::ipc::DeliveryCacheStorageServiceCountMax;

    /*!
        @brief      DeliveryCacheFileService に割り当てるバッファサイズです。
    */
    static const size_t DeliveryCacheFileServiceSize = 384;

    /*!
        @brief      DeliveryCacheFileService のヒープサイズです。
    */
    static const size_t DeliveryCacheFileServiceHeapSize = DeliveryCacheFileServiceSize * detail::ipc::DeliveryCacheFileServiceCountMax;

    /*!
        @brief      DeliveryCacheDirectoryService に割り当てるバッファサイズです。
    */
    static const size_t DeliveryCacheDirectoryServiceSize = 256;

    /*!
        @brief      DeliveryCacheDirectoryService のヒープサイズです。
    */
    static const size_t DeliveryCacheDirectoryServiceHeapSize = DeliveryCacheDirectoryServiceSize * detail::ipc::DeliveryCacheDirectoryServiceCountMax;

    /*!
        @brief      DeliveryCacheProgressService に割り当てるバッファサイズです。
    */
    static const size_t DeliveryCacheProgressServiceSize = 192;

    /*!
        @brief      DeliveryCacheProgressService のヒープサイズです。
    */
    static const size_t DeliveryCacheProgressServiceHeapSize = DeliveryCacheProgressServiceSize * detail::ipc::DeliveryCacheProgressServiceCountMax;

private:
    /*!
        @brief      コンストラクタです。
    */
    ServiceMemoryManager() NN_NOEXCEPT;

    /*!
        @brief      デストラクタです。
    */
    ~ServiceMemoryManager() NN_NOEXCEPT;

public:
    /*!
        @brief      インスタンスを取得します。

        @return     インスタンス。
    */
    static ServiceMemoryManager& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(ServiceMemoryManager, s_Instance);
        return s_Instance;
    }

public:
    /*!
        @brief      BcatService 用アロケータを取得します。

        @return     BcatService 用アロケータ。
    */
    nn::sf::ExpHeapAllocator& GetBcatServiceAllocator() NN_NOEXCEPT;

    /*!
        @brief      DeliveryCacheStorageService 用アロケータを取得します。

        @return     DeliveryCacheStorageService 用アロケータ。
    */
    nn::sf::ExpHeapAllocator& GetDeliveryCacheStorageServiceAllocator() NN_NOEXCEPT;

    /*!
        @brief      DeliveryCacheFileService 用アロケータを取得します。

        @return     DeliveryCacheFileService 用アロケータ。
    */
    nn::sf::ExpHeapAllocator& GetDeliveryCacheFileServiceAllocator() NN_NOEXCEPT;

    /*!
        @brief      DeliveryCacheDirectoryService 用アロケータを取得します。

        @return     DeliveryCacheDirectoryService 用アロケータ。
    */
    nn::sf::ExpHeapAllocator& GetDeliveryCacheDirectoryServiceAllocator() NN_NOEXCEPT;

    /*!
        @brief      DeliveryCacheProgressService 用アロケータを取得します。

        @return     DeliveryCacheProgressService 用アロケータ。
    */
    nn::sf::ExpHeapAllocator& GetDeliveryCacheProgressServiceAllocator() NN_NOEXCEPT;

private:
    //
    ServiceHeap<BcatServiceHeapSize> m_BcatServiceHeap;
    ServiceHeap<DeliveryCacheStorageServiceHeapSize> m_DeliveryCacheStorageServiceHeap;
    ServiceHeap<DeliveryCacheFileServiceHeapSize> m_DeliveryCacheFileServiceHeap;
    ServiceHeap<DeliveryCacheDirectoryServiceHeapSize> m_DeliveryCacheDirectoryServiceHeap;
    ServiceHeap<DeliveryCacheProgressServiceHeapSize> m_DeliveryCacheProgressServiceHeap;
};

}}}}
