﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_ExpHeapAllocator.h>

namespace nn { namespace bcat { namespace detail { namespace service {

/*!
    @brief      サービスオブジェクト生成用のヒープです。
*/
template <size_t Size> class ServiceHeap
{
public:
    /*!
        @brief      コンストラクタです。
    */
    ServiceHeap() NN_NOEXCEPT
    {
        m_HeapHandle = nn::lmem::CreateExpHeap(m_Buffer, sizeof (m_Buffer), nn::lmem::CreationOption_ThreadSafe);
        m_Allocator.Attach(m_HeapHandle);
    }

    /*!
        @brief      デストラクタです。
    */
    ~ServiceHeap() NN_NOEXCEPT
    {
        m_Allocator.Detach();
        nn::lmem::DestroyExpHeap(m_HeapHandle);
    }

    /*!
        @brief      アロケータを取得します。

        @return     アロケータ。
    */
    nn::sf::ExpHeapAllocator& GetAllocator() NN_NOEXCEPT
    {
        return m_Allocator;
    }

private:
    //
    nn::sf::ExpHeapAllocator m_Allocator;
    //
    nn::lmem::HeapHandle m_HeapHandle;
    Bit64 m_Buffer[(Size + sizeof (nn::lmem::HeapCommonHead)) / sizeof (Bit64)];
};

}}}}
